/*
 * Decompiled with CFR 0.152.
 */
package org.mp4parser.muxer.tracks;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.channels.Channels;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.mp4parser.Box;
import org.mp4parser.boxes.iso14496.part1.objectdescriptors.BaseDescriptor;
import org.mp4parser.boxes.iso14496.part1.objectdescriptors.DecoderConfigDescriptor;
import org.mp4parser.boxes.iso14496.part1.objectdescriptors.ESDescriptor;
import org.mp4parser.boxes.iso14496.part12.CompositionTimeToSample;
import org.mp4parser.boxes.iso14496.part12.SampleDependencyTypeBox;
import org.mp4parser.boxes.iso14496.part12.SampleDescriptionBox;
import org.mp4parser.boxes.iso14496.part12.SubSampleInformationBox;
import org.mp4parser.boxes.iso14496.part14.AbstractDescriptorBox;
import org.mp4parser.boxes.iso14496.part14.ESDescriptorBox;
import org.mp4parser.boxes.sampleentry.AudioSampleEntry;
import org.mp4parser.boxes.sampleentry.SampleEntry;
import org.mp4parser.boxes.sampleentry.VisualSampleEntry;
import org.mp4parser.muxer.AbstractTrack;
import org.mp4parser.muxer.Sample;
import org.mp4parser.muxer.Track;
import org.mp4parser.muxer.TrackMetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppendTrack
extends AbstractTrack {
    private static Logger LOG = LoggerFactory.getLogger(AppendTrack.class);
    Track[] tracks;
    private List<Sample> lists = new ArrayList<Sample>();
    private List<SampleEntry> sampleEntries = new ArrayList<SampleEntry>();
    private long[] decodingTimes;

    public AppendTrack(Track ... tracks) throws IOException {
        super(AppendTrack.appendTracknames(tracks));
        this.tracks = tracks;
        for (Track track : tracks) {
            this.sampleEntries.addAll(track.getSampleEntries());
        }
        for (Track track : tracks) {
            this.lists.addAll(track.getSamples());
        }
        int numSamples = 0;
        for (Track track : tracks) {
            numSamples += track.getSampleDurations().length;
        }
        this.decodingTimes = new long[numSamples];
        int index = 0;
        for (Track track : tracks) {
            long[] durs = track.getSampleDurations();
            System.arraycopy(durs, 0, this.decodingTimes, index, durs.length);
            index += durs.length;
        }
    }

    public static String appendTracknames(Track ... tracks) {
        String name = "";
        for (Track track : tracks) {
            name = name + track.getName() + " + ";
        }
        return name.substring(0, name.length() - 3);
    }

    @Override
    public void close() throws IOException {
        for (Track track : this.tracks) {
            track.close();
        }
    }

    private SampleDescriptionBox mergeStsds(SampleDescriptionBox stsd1, SampleDescriptionBox stsd2) throws IOException {
        ByteArrayOutputStream curBaos = new ByteArrayOutputStream();
        ByteArrayOutputStream refBaos = new ByteArrayOutputStream();
        try {
            stsd1.getBox(Channels.newChannel(curBaos));
            stsd2.getBox(Channels.newChannel(refBaos));
        }
        catch (IOException e) {
            LOG.error(e.getMessage());
            return null;
        }
        byte[] cur = curBaos.toByteArray();
        byte[] ref = refBaos.toByteArray();
        if (!Arrays.equals(ref, cur)) {
            SampleEntry se = this.mergeSampleEntry((SampleEntry)stsd1.getBoxes(SampleEntry.class).get(0), (SampleEntry)stsd2.getBoxes(SampleEntry.class).get(0));
            if (se != null) {
                stsd1.setBoxes(Collections.singletonList(se));
            } else {
                throw new IOException("Cannot merge " + stsd1.getBoxes(SampleEntry.class).get(0) + " and " + stsd2.getBoxes(SampleEntry.class).get(0));
            }
        }
        return stsd1;
    }

    private SampleEntry mergeSampleEntry(SampleEntry se1, SampleEntry se2) {
        if (!se1.getType().equals(se2.getType())) {
            return null;
        }
        if (se1 instanceof VisualSampleEntry && se2 instanceof VisualSampleEntry) {
            return this.mergeVisualSampleEntry((VisualSampleEntry)se1, (VisualSampleEntry)se2);
        }
        if (se1 instanceof AudioSampleEntry && se2 instanceof AudioSampleEntry) {
            return this.mergeAudioSampleEntries((AudioSampleEntry)se1, (AudioSampleEntry)se2);
        }
        return null;
    }

    private VisualSampleEntry mergeVisualSampleEntry(VisualSampleEntry vse1, VisualSampleEntry vse2) {
        VisualSampleEntry vse = new VisualSampleEntry();
        if (vse1.getHorizresolution() != vse2.getHorizresolution()) {
            LOG.error("Horizontal Resolution differs");
            return null;
        }
        vse.setHorizresolution(vse1.getHorizresolution());
        vse.setCompressorname(vse1.getCompressorname());
        if (vse1.getDepth() != vse2.getDepth()) {
            LOG.error("Depth differs");
            return null;
        }
        vse.setDepth(vse1.getDepth());
        if (vse1.getFrameCount() != vse2.getFrameCount()) {
            LOG.error("frame count differs");
            return null;
        }
        vse.setFrameCount(vse1.getFrameCount());
        if (vse1.getHeight() != vse2.getHeight()) {
            LOG.error("height differs");
            return null;
        }
        vse.setHeight(vse1.getHeight());
        if (vse1.getWidth() != vse2.getWidth()) {
            LOG.error("width differs");
            return null;
        }
        vse.setWidth(vse1.getWidth());
        if (vse1.getVertresolution() != vse2.getVertresolution()) {
            LOG.error("vert resolution differs");
            return null;
        }
        vse.setVertresolution(vse1.getVertresolution());
        if (vse1.getHorizresolution() != vse2.getHorizresolution()) {
            LOG.error("horizontal resolution differs");
            return null;
        }
        vse.setHorizresolution(vse1.getHorizresolution());
        if (vse1.getBoxes().size() == vse2.getBoxes().size()) {
            Iterator bxs1 = vse1.getBoxes().iterator();
            Iterator bxs2 = vse2.getBoxes().iterator();
            while (bxs1.hasNext()) {
                Box cur1 = (Box)bxs1.next();
                Box cur2 = (Box)bxs2.next();
                ByteArrayOutputStream baos1 = new ByteArrayOutputStream();
                ByteArrayOutputStream baos2 = new ByteArrayOutputStream();
                try {
                    cur1.getBox(Channels.newChannel(baos1));
                    cur2.getBox(Channels.newChannel(baos2));
                }
                catch (IOException e) {
                    LOG.warn(e.getMessage());
                    return null;
                }
                if (Arrays.equals(baos1.toByteArray(), baos2.toByteArray())) {
                    vse.addBox(cur1);
                    continue;
                }
                if (!(cur1 instanceof AbstractDescriptorBox) || !(cur2 instanceof AbstractDescriptorBox)) continue;
                ESDescriptor esd = this.mergeDescriptors(((AbstractDescriptorBox)cur1).getDescriptor(), ((AbstractDescriptorBox)cur2).getDescriptor());
                ((AbstractDescriptorBox)cur1).setDescriptor((BaseDescriptor)esd);
                vse.addBox(cur1);
            }
        }
        return vse;
    }

    private AudioSampleEntry mergeAudioSampleEntries(AudioSampleEntry ase1, AudioSampleEntry ase2) {
        AudioSampleEntry ase = new AudioSampleEntry(ase2.getType());
        if (ase1.getBytesPerFrame() != ase2.getBytesPerFrame()) {
            LOG.error("BytesPerFrame differ");
            return null;
        }
        ase.setBytesPerFrame(ase1.getBytesPerFrame());
        if (ase1.getBytesPerPacket() != ase2.getBytesPerPacket()) {
            return null;
        }
        ase.setBytesPerPacket(ase1.getBytesPerPacket());
        if (ase1.getBytesPerSample() != ase2.getBytesPerSample()) {
            LOG.error("BytesPerSample differ");
            return null;
        }
        ase.setBytesPerSample(ase1.getBytesPerSample());
        if (ase1.getChannelCount() != ase2.getChannelCount()) {
            return null;
        }
        ase.setChannelCount(ase1.getChannelCount());
        if (ase1.getPacketSize() != ase2.getPacketSize()) {
            LOG.error("ChannelCount differ");
            return null;
        }
        ase.setPacketSize(ase1.getPacketSize());
        if (ase1.getCompressionId() != ase2.getCompressionId()) {
            return null;
        }
        ase.setCompressionId(ase1.getCompressionId());
        if (ase1.getSampleRate() != ase2.getSampleRate()) {
            return null;
        }
        ase.setSampleRate(ase1.getSampleRate());
        if (ase1.getSampleSize() != ase2.getSampleSize()) {
            return null;
        }
        ase.setSampleSize(ase1.getSampleSize());
        if (ase1.getSamplesPerPacket() != ase2.getSamplesPerPacket()) {
            return null;
        }
        ase.setSamplesPerPacket(ase1.getSamplesPerPacket());
        if (ase1.getSoundVersion() != ase2.getSoundVersion()) {
            return null;
        }
        ase.setSoundVersion(ase1.getSoundVersion());
        if (!Arrays.equals(ase1.getSoundVersion2Data(), ase2.getSoundVersion2Data())) {
            return null;
        }
        ase.setSoundVersion2Data(ase1.getSoundVersion2Data());
        if (ase1.getBoxes().size() == ase2.getBoxes().size()) {
            Iterator bxs1 = ase1.getBoxes().iterator();
            Iterator bxs2 = ase2.getBoxes().iterator();
            while (bxs1.hasNext()) {
                Box cur1 = (Box)bxs1.next();
                Box cur2 = (Box)bxs2.next();
                ByteArrayOutputStream baos1 = new ByteArrayOutputStream();
                ByteArrayOutputStream baos2 = new ByteArrayOutputStream();
                try {
                    cur1.getBox(Channels.newChannel(baos1));
                    cur2.getBox(Channels.newChannel(baos2));
                }
                catch (IOException e) {
                    LOG.warn(e.getMessage());
                    return null;
                }
                if (Arrays.equals(baos1.toByteArray(), baos2.toByteArray())) {
                    ase.addBox(cur1);
                    continue;
                }
                if (!"esds".equals(cur1.getType()) || !"esds".equals(cur2.getType())) continue;
                ESDescriptorBox esdsBox1 = (ESDescriptorBox)cur1;
                ESDescriptorBox esdsBox2 = (ESDescriptorBox)cur2;
                ESDescriptor esd = this.mergeDescriptors((BaseDescriptor)esdsBox1.getEsDescriptor(), (BaseDescriptor)esdsBox2.getEsDescriptor());
                esdsBox1.setDescriptor((BaseDescriptor)esd);
                ase.addBox(cur1);
            }
        }
        return ase;
    }

    private ESDescriptor mergeDescriptors(BaseDescriptor des1, BaseDescriptor des2) {
        if (des1 instanceof ESDescriptor && des2 instanceof ESDescriptor) {
            ESDescriptor esds1 = (ESDescriptor)des1;
            ESDescriptor esds2 = (ESDescriptor)des2;
            if (esds1.getURLFlag() != esds2.getURLFlag()) {
                return null;
            }
            if (esds1.getURLLength() != esds2.getURLLength()) {
                // empty if block
            }
            if (esds1.getDependsOnEsId() != esds2.getDependsOnEsId()) {
                return null;
            }
            if (esds1.getEsId() != esds2.getEsId()) {
                return null;
            }
            if (esds1.getoCREsId() != esds2.getoCREsId()) {
                return null;
            }
            if (esds1.getoCRstreamFlag() != esds2.getoCRstreamFlag()) {
                return null;
            }
            if (esds1.getRemoteODFlag() != esds2.getRemoteODFlag()) {
                return null;
            }
            if (esds1.getStreamDependenceFlag() != esds2.getStreamDependenceFlag()) {
                return null;
            }
            if (esds1.getStreamPriority() != esds2.getStreamPriority()) {
                // empty if block
            }
            if (esds1.getURLString() != null ? !esds1.getURLString().equals(esds2.getURLString()) : esds2.getURLString() != null) {
                // empty if block
            }
            if (esds1.getDecoderConfigDescriptor() != null ? !esds1.getDecoderConfigDescriptor().equals(esds2.getDecoderConfigDescriptor()) : esds2.getDecoderConfigDescriptor() != null) {
                DecoderConfigDescriptor dcd1 = esds1.getDecoderConfigDescriptor();
                DecoderConfigDescriptor dcd2 = esds2.getDecoderConfigDescriptor();
                if (dcd1.getAudioSpecificInfo() != null && dcd2.getAudioSpecificInfo() != null && !dcd1.getAudioSpecificInfo().equals((Object)dcd2.getAudioSpecificInfo())) {
                    return null;
                }
                if (dcd1.getAvgBitRate() != dcd2.getAvgBitRate()) {
                    dcd1.setAvgBitRate((dcd1.getAvgBitRate() + dcd2.getAvgBitRate()) / 2L);
                }
                if (dcd1.getBufferSizeDB() != dcd2.getBufferSizeDB()) {
                    // empty if block
                }
                if (dcd1.getDecoderSpecificInfo() != null ? !dcd1.getDecoderSpecificInfo().equals((Object)dcd2.getDecoderSpecificInfo()) : dcd2.getDecoderSpecificInfo() != null) {
                    return null;
                }
                if (dcd1.getMaxBitRate() != dcd2.getMaxBitRate()) {
                    dcd1.setMaxBitRate(Math.max(dcd1.getMaxBitRate(), dcd2.getMaxBitRate()));
                }
                if (!dcd1.getProfileLevelIndicationDescriptors().equals(dcd2.getProfileLevelIndicationDescriptors())) {
                    return null;
                }
                if (dcd1.getObjectTypeIndication() != dcd2.getObjectTypeIndication()) {
                    return null;
                }
                if (dcd1.getStreamType() != dcd2.getStreamType()) {
                    return null;
                }
                if (dcd1.getUpStream() != dcd2.getUpStream()) {
                    return null;
                }
            }
            if (esds1.getOtherDescriptors() != null ? !esds1.getOtherDescriptors().equals(esds2.getOtherDescriptors()) : esds2.getOtherDescriptors() != null) {
                return null;
            }
            if (esds1.getSlConfigDescriptor() != null ? !esds1.getSlConfigDescriptor().equals((Object)esds2.getSlConfigDescriptor()) : esds2.getSlConfigDescriptor() != null) {
                return null;
            }
            return esds1;
        }
        LOG.error("I can only merge ESDescriptors");
        return null;
    }

    @Override
    public List<Sample> getSamples() {
        return this.lists;
    }

    @Override
    public List<SampleEntry> getSampleEntries() {
        return this.sampleEntries;
    }

    @Override
    public synchronized long[] getSampleDurations() {
        return this.decodingTimes;
    }

    @Override
    public List<CompositionTimeToSample.Entry> getCompositionTimeEntries() {
        if (this.tracks[0].getCompositionTimeEntries() != null && !this.tracks[0].getCompositionTimeEntries().isEmpty()) {
            LinkedList<int[]> lists = new LinkedList<int[]>();
            for (Track track : this.tracks) {
                lists.add(CompositionTimeToSample.blowupCompositionTimes(track.getCompositionTimeEntries()));
            }
            LinkedList<CompositionTimeToSample.Entry> compositionTimeEntries = new LinkedList<CompositionTimeToSample.Entry>();
            Iterator iterator = lists.iterator();
            while (iterator.hasNext()) {
                int[] list;
                for (int compositionTime : list = (int[])iterator.next()) {
                    CompositionTimeToSample.Entry e;
                    if (compositionTimeEntries.isEmpty() || compositionTimeEntries.getLast().getOffset() != compositionTime) {
                        e = new CompositionTimeToSample.Entry(1, compositionTime);
                        compositionTimeEntries.add(e);
                        continue;
                    }
                    e = compositionTimeEntries.getLast();
                    e.setCount(e.getCount() + 1);
                }
            }
            return compositionTimeEntries;
        }
        return null;
    }

    @Override
    public long[] getSyncSamples() {
        if (this.tracks[0].getSyncSamples() != null && this.tracks[0].getSyncSamples().length > 0) {
            int numSyncSamples = 0;
            for (Track track : this.tracks) {
                numSyncSamples += track.getSyncSamples() != null ? track.getSyncSamples().length : 0;
            }
            long[] returnSyncSamples = new long[numSyncSamples];
            int pos = 0;
            long samplesBefore = 0L;
            for (Track track : this.tracks) {
                if (track.getSyncSamples() != null) {
                    for (long l : track.getSyncSamples()) {
                        returnSyncSamples[pos++] = samplesBefore + l;
                    }
                }
                samplesBefore += (long)track.getSamples().size();
            }
            return returnSyncSamples;
        }
        return null;
    }

    @Override
    public List<SampleDependencyTypeBox.Entry> getSampleDependencies() {
        if (this.tracks[0].getSampleDependencies() != null && !this.tracks[0].getSampleDependencies().isEmpty()) {
            LinkedList<SampleDependencyTypeBox.Entry> list = new LinkedList<SampleDependencyTypeBox.Entry>();
            for (Track track : this.tracks) {
                list.addAll(track.getSampleDependencies());
            }
            return list;
        }
        return null;
    }

    @Override
    public TrackMetaData getTrackMetaData() {
        return this.tracks[0].getTrackMetaData();
    }

    @Override
    public String getHandler() {
        return this.tracks[0].getHandler();
    }

    @Override
    public SubSampleInformationBox getSubsampleInformationBox() {
        return this.tracks[0].getSubsampleInformationBox();
    }
}

