/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.settings;

import java.util.ArrayList;
import java.util.List;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.ui.components.tree.TmmTreeDataProvider;
import org.tinymediamanager.ui.components.tree.TmmTreeNode;
import org.tinymediamanager.ui.movies.MovieUIModule;
import org.tinymediamanager.ui.moviesets.MovieSetUIModule;
import org.tinymediamanager.ui.settings.ArdSettingsPanel;
import org.tinymediamanager.ui.settings.ExternalDevicesSettingsPanel;
import org.tinymediamanager.ui.settings.ExternalServicesSettingsPanel;
import org.tinymediamanager.ui.settings.ExternalToolsSettingsPanel;
import org.tinymediamanager.ui.settings.FileTypesSettingsPanel;
import org.tinymediamanager.ui.settings.MiscSettingsPanel;
import org.tinymediamanager.ui.settings.SortTitleSettingsPanel;
import org.tinymediamanager.ui.settings.SystemSettingsPanel;
import org.tinymediamanager.ui.settings.TmmSettingsNode;
import org.tinymediamanager.ui.settings.UiSettingsPanel;
import org.tinymediamanager.ui.tvshows.TvShowUIModule;

public class TmmSettingsDataProvider
extends TmmTreeDataProvider<TmmTreeNode> {
    private final TmmTreeNode root;

    public TmmSettingsDataProvider() {
        TmmSettingsNode rootSettingsNode = new TmmSettingsNode("", null);
        this.root = new TmmTreeNode((Object)rootSettingsNode, this);
        TmmSettingsNode generalSettingsNode = new TmmSettingsNode(TmmResourceBundle.getString("Settings.general"), new UiSettingsPanel());
        generalSettingsNode.setBoldText(true);
        generalSettingsNode.addChild(new TmmSettingsNode(TmmResourceBundle.getString("Settings.filetypes"), new FileTypesSettingsPanel()));
        generalSettingsNode.addChild(new TmmSettingsNode(TmmResourceBundle.getString("Settings.sorting"), new SortTitleSettingsPanel()));
        generalSettingsNode.addChild(new TmmSettingsNode(TmmResourceBundle.getString("Settings.externaltools"), new ExternalToolsSettingsPanel()));
        generalSettingsNode.addChild(new TmmSettingsNode(TmmResourceBundle.getString("Settings.externaldevices"), new ExternalDevicesSettingsPanel()));
        generalSettingsNode.addChild(new TmmSettingsNode(TmmResourceBundle.getString("Settings.externalservices"), new ExternalServicesSettingsPanel()));
        generalSettingsNode.addChild(new TmmSettingsNode(TmmResourceBundle.getString("Settings.system"), new SystemSettingsPanel()));
        generalSettingsNode.addChild(new TmmSettingsNode(TmmResourceBundle.getString("Settings.ard"), new ArdSettingsPanel()));
        generalSettingsNode.addChild(new TmmSettingsNode(TmmResourceBundle.getString("Settings.misc"), new MiscSettingsPanel()));
        rootSettingsNode.addChild(generalSettingsNode);
        rootSettingsNode.addChild(MovieUIModule.getInstance().getSettingsNode());
        rootSettingsNode.addChild(MovieSetUIModule.getInstance().getSettingsNode());
        rootSettingsNode.addChild(TvShowUIModule.getInstance().getSettingsNode());
    }

    @Override
    public TmmTreeNode getRoot() {
        return this.root;
    }

    @Override
    public TmmTreeNode getParent(TmmTreeNode node) {
        if (node == this.root) {
            return null;
        }
        TmmSettingsNode settingsNode = (TmmSettingsNode)node.getUserObject();
        if (settingsNode == null || settingsNode.getParent() == null) {
            return this.root;
        }
        return this.getNodeFromCache(settingsNode.getParent());
    }

    @Override
    public List<TmmTreeNode> getChildren(TmmTreeNode parent) {
        TmmSettingsNode settingsNode;
        ArrayList<TmmTreeNode> children = new ArrayList<TmmTreeNode>();
        if (parent.getUserObject() instanceof TmmSettingsNode && (settingsNode = (TmmSettingsNode)parent.getUserObject()) != null) {
            for (TmmSettingsNode child : settingsNode.getChildren()) {
                TmmTreeNode node = new TmmTreeNode((Object)child, this);
                this.putNodeToCache(child, node);
                children.add(node);
            }
        }
        return children;
    }

    @Override
    public boolean isLeaf(TmmTreeNode node) {
        if (node == this.root) {
            return false;
        }
        return node.getUserObject() instanceof TmmSettingsNode && ((TmmSettingsNode)node.getUserObject()).getChildren().isEmpty();
    }
}

