/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.settings;

import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.swingbinding.JListBinding;
import org.jdesktop.swingbinding.SwingBindings;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.components.button.DocsButton;
import org.tinymediamanager.ui.components.button.SquareIconButton;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.components.panel.CollapsiblePanel;
import org.tinymediamanager.ui.components.textfield.ReadOnlyTextArea;

class SortTitleSettingsPanel
extends JPanel {
    private final Settings settings = Settings.getInstance();
    private JList<String> listSortPrefixes;
    private JTextField tfSortPrefix;
    private JButton btnRemoveSortPrefix;
    private JButton btnAddSortPrefix;

    SortTitleSettingsPanel() {
        this.initComponents();
        this.initDataBindings();
        this.btnAddSortPrefix.addActionListener(e -> {
            if (StringUtils.isNotEmpty((CharSequence)this.tfSortPrefix.getText())) {
                Settings.getInstance().addTitlePrefix(this.tfSortPrefix.getText());
                this.tfSortPrefix.setText("");
                MovieModuleManager.getInstance().getMovieList().invalidateTitleSortable();
                TvShowModuleManager.getInstance().getTvShowList().invalidateTitleSortable();
            }
        });
        this.btnRemoveSortPrefix.addActionListener(arg0 -> {
            int row = this.listSortPrefixes.getSelectedIndex();
            if (row != -1) {
                String prefix = Settings.getInstance().getTitlePrefix().get(row);
                Settings.getInstance().removeTitlePrefix(prefix);
                MovieModuleManager.getInstance().getMovieList().invalidateTitleSortable();
                TvShowModuleManager.getInstance().getTvShowList().invalidateTitleSortable();
            }
        });
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("", "[grow]", "[]"));
        JPanel panelSorttitle = new JPanel((LayoutManager)new MigLayout("hidemode 1, insets 0", "[20lp!][150lp][][200lp]", "[][250lp][]"));
        TmmLabel lblSorttitleT = new TmmLabel(TmmResourceBundle.getString("Settings.sorting"), 1.16667);
        CollapsiblePanel collapsiblePanel = new CollapsiblePanel((JComponent)panelSorttitle, lblSorttitleT, true);
        collapsiblePanel.addExtraTitleComponent(new DocsButton("/settings#title-sorting"));
        this.add((Component)collapsiblePanel, "cell 0 0,growx, wmin 0");
        ReadOnlyTextArea tpSortingHint = new ReadOnlyTextArea(TmmResourceBundle.getString("Settings.sorting.info"));
        panelSorttitle.add((Component)tpSortingHint, "cell 1 0 3 1,growx, wmin 0");
        JScrollPane scrollPane = new JScrollPane();
        panelSorttitle.add((Component)scrollPane, "cell 1 1,grow");
        this.listSortPrefixes = new JList();
        scrollPane.setViewportView(this.listSortPrefixes);
        this.btnRemoveSortPrefix = new SquareIconButton(IconManager.REMOVE_INV);
        this.btnRemoveSortPrefix.setToolTipText(TmmResourceBundle.getString("Button.remove"));
        panelSorttitle.add((Component)this.btnRemoveSortPrefix, "cell 2 1,aligny bottom, growx");
        this.tfSortPrefix = new JTextField();
        panelSorttitle.add((Component)this.tfSortPrefix, "cell 1 2,growx");
        this.btnAddSortPrefix = new SquareIconButton(IconManager.ADD_INV);
        this.btnAddSortPrefix.setToolTipText(TmmResourceBundle.getString("Button.add"));
        panelSorttitle.add((Component)this.btnAddSortPrefix, "cell 2 2, growx");
    }

    protected void initDataBindings() {
        BeanProperty settingsBeanProperty_1 = BeanProperty.create((String)"titlePrefix");
        JListBinding jListBinding = SwingBindings.createJListBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_1, this.listSortPrefixes);
        jListBinding.bind();
    }
}

