/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.panels;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.ui.IconManager;

class MemoryUsagePanel
extends JPanel {
    private static final int MB = 0x100000;
    private static final int HISTORY_SIZE = 10;
    private static final int HIGH_USAGE_THRESHOLD = 85;
    private static boolean oomDetected = false;
    private final Timer timer;
    private final JLabel lblMemory;
    private long maxMem;
    private long totalMem;
    private long freeMem;
    private long usedMem;
    private final int[] usageHistory = new int[10];
    private int usageCount = 0;
    private int usageIndex = 0;
    private boolean highUsage = false;

    public MemoryUsagePanel() {
        this.setLayout(new FlowLayout());
        this.setOpaque(false);
        this.setFocusable(false);
        this.getMemory();
        this.lblMemory = new JLabel();
        this.lblMemory.setHorizontalTextPosition(2);
        this.lblMemory.setMinimumSize(this.getLabelMinimumSize());
        this.lblMemory.setOpaque(false);
        this.add(this.lblMemory);
        this.setMemoryText();
        this.timer = new Timer(1000, null);
        this.timer.addActionListener(evt -> {
            if (oomDetected && this.lblMemory.getIcon() == null) {
                this.lblMemory.setIcon(IconManager.WARN_RED);
            }
            this.getMemory();
            this.updateUsageHistoryAndAverage();
            this.setMemoryText();
            this.repaint();
        });
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.timer.start();
        } else {
            this.timer.stop();
        }
    }

    private void getMemory() {
        Runtime rt = Runtime.getRuntime();
        this.totalMem = rt.totalMemory();
        this.maxMem = rt.maxMemory();
        this.freeMem = rt.freeMemory();
        this.usedMem = this.totalMem - this.freeMem;
    }

    private void setMemoryText() {
        this.lblMemory.setText(this.usedMem / 0x100000L + " / " + this.maxMem / 0x100000L + "M");
    }

    @Override
    public void paintComponent(Graphics g) {
        Dimension size = this.getSize();
        int barWidth = size.width;
        int usedBarLength = (int)((long)barWidth * this.usedMem / (this.maxMem == 0L ? 1L : this.maxMem));
        if (this.highUsage) {
            g.setColor(UIManager.getColor("Component.warning.focusedBorderColor"));
        } else {
            g.setColor(UIManager.getColor("Panel.tmmAlternateBackground"));
        }
        g.fillRect(0, 0, usedBarLength, size.height - 1);
        super.paintComponent(g);
    }

    @Override
    public String getToolTipText() {
        long megs = 0x100000L;
        long used = this.totalMem - this.freeMem;
        long free = this.maxMem - used;
        String text = TmmResourceBundle.getString("tmm.memoryused") + " " + used / megs + " MiB  /  " + TmmResourceBundle.getString("tmm.memoryfree") + " " + free / megs + " MiB  /  " + TmmResourceBundle.getString("tmm.memorymax") + " " + this.maxMem / megs + " MiB";
        if (oomDetected) {
            text = text + "\n\n" + TmmResourceBundle.getString("tmm.oom");
        }
        return text;
    }

    private Dimension getLabelMinimumSize() {
        String text = this.maxMem * 10L / 0x100000L + " / " + this.maxMem / 0x100000L + "M";
        Insets insets = this.lblMemory.getInsets();
        int width = insets.left + insets.right + this.lblMemory.getFontMetrics(this.lblMemory.getFont()).stringWidth(text);
        int height = this.lblMemory.getMinimumSize().height;
        return new Dimension(width, height);
    }

    private void updateUsageHistoryAndAverage() {
        int percent = 0;
        if (this.maxMem > 0L) {
            double p = (double)this.usedMem * 100.0 / (double)this.maxMem;
            if (p < 0.0) {
                p = 0.0;
            } else if (p > 100.0) {
                p = 100.0;
            }
            percent = (int)Math.round(p);
        }
        this.usageHistory[this.usageIndex] = percent;
        this.usageIndex = (this.usageIndex + 1) % 10;
        if (this.usageCount < 10) {
            ++this.usageCount;
        }
        int sum = 0;
        for (int i = 0; i < this.usageCount; ++i) {
            sum += this.usageHistory[i];
        }
        int avg = this.usageCount > 0 ? sum / this.usageCount : 0;
        this.highUsage = avg >= 85;
    }

    static void setOomDetected() {
        oomDetected = true;
    }
}

