/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.actions;

import java.awt.event.ActionEvent;
import java.nio.file.Path;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.tasks.MediaEntityCopyTask;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.movies.MovieUIModule;

public class MovieCopyToAction
extends TmmAction {
    public MovieCopyToAction() {
        this.putValue("Name", TmmResourceBundle.getString("movie.copyto"));
        this.putValue("ShortDescription", TmmResourceBundle.getString("movie.copyto.desc"));
        this.putValue("SmallIcon", IconManager.COPY);
        this.putValue("SwingLargeIconKey", IconManager.COPY);
    }

    @Override
    protected void processAction(ActionEvent e) {
        List<Movie> selectedMovies = MovieUIModule.getInstance().getSelectionModel().getSelectedMovies(true);
        if (selectedMovies.isEmpty()) {
            JOptionPane.showMessageDialog(MainWindow.getInstance(), TmmResourceBundle.getString("tmm.nothingselected"));
            return;
        }
        SwingUtilities.invokeLater(() -> {
            Path folder = TmmUIHelper.selectDirectory(TmmResourceBundle.getString("movie.copyto"), null);
            if (folder != null) {
                MediaEntityCopyTask task = new MediaEntityCopyTask(selectedMovies, folder);
                TmmTaskManager.getInstance().addUnnamedTask(task);
            }
        });
    }
}

