/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.actions;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.nio.file.Path;
import java.util.List;
import javax.swing.JOptionPane;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.UpgradeTasks;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.actions.TmmAction;

public class ImportV4DataAction
extends TmmAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImportV4DataAction.class);

    public ImportV4DataAction() {
        this.putValue("Name", TmmResourceBundle.getString("tmm.importv4"));
        this.putValue("ShortDescription", TmmResourceBundle.getString("tmm.importv4.desc"));
    }

    @Override
    protected void processAction(ActionEvent e) {
        Object[] options = new Object[]{TmmResourceBundle.getString("Button.yes"), TmmResourceBundle.getString("Button.no")};
        int answer = JOptionPane.showOptionDialog(MainWindow.getInstance(), TmmResourceBundle.getString("tmm.importv4.hint"), TmmResourceBundle.getString("tmm.importv4"), 0, 3, null, options, null);
        if (answer != 0) {
            return;
        }
        Path path = null;
        path = SystemUtils.IS_OS_MAC ? TmmUIHelper.selectApplication(TmmResourceBundle.getString("tmm.importv4.installation"), "") : TmmUIHelper.selectDirectory(TmmResourceBundle.getString("tmm.importv4.installation"), "");
        if (path != null) {
            List<Path> files = Utils.listFilesRecursive(path);
            for (Path file : files) {
                if (!file.endsWith("tmm.json") || !file.getParent().endsWith("data")) continue;
                LOGGER.debug("found v4 installation - copying data from '{}'", (Object)file.getParent());
                MainWindow.getInstance().setCursor(Cursor.getPredefinedCursor(3));
                UpgradeTasks.copyV4Data(file.getParent());
            }
        }
        JOptionPane.showMessageDialog(MainWindow.getInstance(), TmmResourceBundle.getString("tmm.importv4.notfound"), TmmResourceBundle.getString("tmm.importv4"), 1);
    }
}

