/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow;

import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.TvShowSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaSearchAndScrapeOptions;
import org.tinymediamanager.scraper.entities.MediaEpisodeGroup;
import org.tinymediamanager.scraper.entities.MediaType;

public class TvShowEpisodeSearchAndScrapeOptions
extends MediaSearchAndScrapeOptions {
    private final Map<String, Object> tvShowIds = new HashMap<String, Object>();
    private MediaEpisodeGroup episodeGroup = MediaEpisodeGroup.DEFAULT_AIRED;

    public TvShowEpisodeSearchAndScrapeOptions() {
        super(MediaType.TV_EPISODE);
    }

    public TvShowEpisodeSearchAndScrapeOptions(@NotNull Map<String, Object> tvShowIds) {
        super(MediaType.TV_EPISODE);
        this.setTvShowIds(tvShowIds);
    }

    public TvShowEpisodeSearchAndScrapeOptions(TvShowEpisodeSearchAndScrapeOptions original) {
        super(original);
        this.setTvShowIds(original.tvShowIds);
        this.setEpisodeGroup(original.episodeGroup);
    }

    @Override
    public void setDataFromOtherOptions(@NotNull MediaSearchAndScrapeOptions original) {
        super.setDataFromOtherOptions(original);
        if (original instanceof TvShowEpisodeSearchAndScrapeOptions) {
            TvShowEpisodeSearchAndScrapeOptions options = (TvShowEpisodeSearchAndScrapeOptions)original;
            this.setTvShowIds(options.tvShowIds);
            this.setEpisodeGroup(options.episodeGroup);
        }
        if (original instanceof TvShowSearchAndScrapeOptions) {
            this.setTvShowIds(original.getIds());
        }
    }

    public Map<String, Object> getTvShowIds() {
        return this.tvShowIds;
    }

    public void setTvShowIds(@NotNull Map<String, Object> tvShowIds) {
        if (this.tvShowIds == null) {
            return;
        }
        this.tvShowIds.clear();
        this.tvShowIds.putAll(tvShowIds);
        this.ids.put("tvShowIds", tvShowIds);
    }

    public MediaEpisodeGroup getEpisodeGroup() {
        return this.episodeGroup;
    }

    public void setEpisodeGroup(@NotNull MediaEpisodeGroup episodeGroup) {
        this.episodeGroup = episodeGroup;
    }

    public TvShowSearchAndScrapeOptions createTvShowSearchAndScrapeOptions() {
        TvShowSearchAndScrapeOptions options = new TvShowSearchAndScrapeOptions();
        options.setDataFromOtherOptions(this);
        options.setIds(this.tvShowIds);
        options.setEpisodeGroup(this.episodeGroup);
        return options;
    }

    public void loadDefaults() {
        this.language = TvShowModuleManager.getInstance().getSettings().getScraperLanguage();
        this.metadataScraper = TvShowModuleManager.getInstance().getTvShowList().getDefaultMediaScraper();
        this.artworkScrapers.addAll(TvShowModuleManager.getInstance().getTvShowList().getDefaultArtworkScrapers());
        this.trailerScrapers.addAll(TvShowModuleManager.getInstance().getTvShowList().getDefaultTrailerScrapers());
        this.subtitleScrapers.addAll(TvShowModuleManager.getInstance().getTvShowList().getDefaultSubtitleScrapers());
    }
}

