/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.filters;

import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.tvshows.filters.AbstractTvShowUIFilter;

public class TvShowWatchedFilter
extends AbstractTvShowUIFilter {
    private JComboBox<WatchedFlag> comboBox;

    @Override
    public String getId() {
        return "tvShowWatched";
    }

    @Override
    public String getFilterValueAsString() {
        try {
            return ((WatchedFlag)((Object)this.comboBox.getSelectedItem())).name();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void setFilterValue(Object value) {
        WatchedFlag watchedFlag;
        if (value == null) {
            return;
        }
        if (value instanceof WatchedFlag) {
            this.comboBox.setSelectedItem(value);
        } else if (value instanceof String && (watchedFlag = WatchedFlag.valueOf((String)value)) != null) {
            this.comboBox.setSelectedItem((Object)watchedFlag);
        }
    }

    @Override
    public void clearFilter() {
        this.comboBox.setSelectedItem((Object)this.comboBox.getItemAt(0));
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(TmmResourceBundle.getString("metatag.watched"));
    }

    @Override
    protected JComponent createFilterComponent() {
        this.comboBox = new JComboBox<WatchedFlag>(WatchedFlag.values());
        return this.comboBox;
    }

    @Override
    protected boolean accept(TvShow tvShow, List<TvShowEpisode> episodes, boolean invert) {
        for (TvShowEpisode episode : episodes) {
            if (episode.isDummy() || !(invert ^ episode.isWatched() == (this.comboBox.getSelectedItem() == WatchedFlag.WATCHED))) continue;
            return true;
        }
        return false;
    }

    private static enum WatchedFlag {
        WATCHED(TmmResourceBundle.getString("metatag.watched")),
        NOT_WATCHED(TmmResourceBundle.getString("metatag.notwatched"));

        private final String title;

        private WatchedFlag(String title) {
            this.title = title;
        }

        public String toString() {
            return this.title;
        }
    }
}

