/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.filters;

import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.bus.EventBus;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.scraper.entities.MediaCertification;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.scraper.util.SetUtils;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.tvshows.filters.AbstractCheckComboBoxTvShowUIFilter;

public class TvShowCertificationFilter
extends AbstractCheckComboBoxTvShowUIFilter<MediaCertification> {
    public TvShowCertificationFilter() {
        this.checkComboBox.enableFilter((s, s2) -> s.toString().toLowerCase(Locale.ROOT).contains(s2.toLowerCase(Locale.ROOT)));
        this.buildAndInstallCertificationArray();
        EventBus.registerListener("tvShows-ui", event -> this.buildAndInstallCertificationArray());
    }

    @Override
    protected String parseTypeToString(MediaCertification type) throws Exception {
        return type.name();
    }

    @Override
    protected MediaCertification parseStringToType(String string) throws Exception {
        return MediaCertification.valueOf(string);
    }

    @Override
    protected boolean accept(TvShow tvShow, List<TvShowEpisode> episodes, boolean invert) {
        List selectedItems = this.checkComboBox.getSelectedItems();
        if (invert) {
            return !selectedItems.contains((Object)tvShow.getCertification());
        }
        return selectedItems.contains((Object)tvShow.getCertification());
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(TmmResourceBundle.getString("metatag.certification"));
    }

    @Override
    public String getId() {
        return "tvShowCertification";
    }

    private void buildAndInstallCertificationArray() {
        HashSet<MediaCertification> certificationsInTvShows = new HashSet<MediaCertification>(this.tvShowList.getCertification());
        if (!SetUtils.equals(this.oldValues, certificationsInTvShows)) {
            this.oldValues.clear();
            this.oldValues.addAll(certificationsInTvShows);
            List<MediaCertification> sortedCertifications = ListUtils.asSortedList(certificationsInTvShows);
            SwingUtilities.invokeLater(() -> this.setValues(sortedCertifications));
        }
    }
}

