/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.filters;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.bus.EventBus;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.scraper.util.SetUtils;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.tvshows.filters.AbstractCheckComboBoxTvShowUIFilter;

public class TvShowAudioTitleFilter
extends AbstractCheckComboBoxTvShowUIFilter<String> {
    public TvShowAudioTitleFilter() {
        this.checkComboBox.enableFilter((s, s2) -> s.toLowerCase(Locale.ROOT).contains(s2.toLowerCase(Locale.ROOT)));
        this.buildAndInstallAudioTitleArray();
        EventBus.registerListener("tvShows-ui", event -> this.buildAndInstallAudioTitleArray());
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(TmmResourceBundle.getString("metatag.audiotitle"));
    }

    @Override
    public String getId() {
        return "tvShowAudioTitle";
    }

    @Override
    protected String parseTypeToString(String type) throws Exception {
        return type;
    }

    @Override
    protected String parseStringToType(String string) throws Exception {
        return string;
    }

    @Override
    protected boolean accept(TvShow tvShow, List<TvShowEpisode> episodes, boolean invert) {
        List selectedItems = this.checkComboBox.getSelectedItems();
        for (TvShowEpisode episode : episodes) {
            List<MediaFile> mfs = episode.getMediaFiles(MediaFileType.VIDEO, MediaFileType.AUDIO);
            for (MediaFile mf : mfs) {
                if (!invert && selectedItems.isEmpty() && mf.getAudioTitleList().isEmpty()) {
                    return true;
                }
                if (invert && selectedItems.isEmpty() && !mf.getAudioTitleList().isEmpty()) {
                    return true;
                }
                if (invert != Collections.disjoint(selectedItems, mf.getAudioTitleList())) continue;
                return true;
            }
        }
        return false;
    }

    private void buildAndInstallAudioTitleArray() {
        HashSet<String> audioTitlesInEpisodes = new HashSet<String>(this.tvShowList.getAudioTitlesInEpisodes());
        if (!SetUtils.equals(this.oldValues, audioTitlesInEpisodes)) {
            this.oldValues.clear();
            this.oldValues.addAll(audioTitlesInEpisodes);
            List<String> sortedAudioTitles = ListUtils.asSortedList(audioTitlesInEpisodes);
            SwingUtilities.invokeLater(() -> this.setValues(sortedAudioTitles));
        }
    }
}

