/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.thirdparty.upnp;

import java.net.URI;
import org.jupnp.model.meta.DeviceDetails;
import org.jupnp.model.meta.DeviceIdentity;
import org.jupnp.model.meta.ManufacturerDetails;
import org.jupnp.model.meta.ModelDetails;
import org.jupnp.model.profile.DeviceDetailsProvider;
import org.jupnp.model.profile.RemoteClientInfo;
import org.jupnp.model.types.DLNACaps;
import org.jupnp.model.types.DLNADoc;
import org.jupnp.model.types.UDN;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.ReleaseInfo;
import org.tinymediamanager.thirdparty.NetworkUtil;
import org.tinymediamanager.thirdparty.upnp.Upnp;

public class TmmDeviceDetails
implements DeviceDetailsProvider {
    public static final Logger LOGGER = LoggerFactory.getLogger(TmmDeviceDetails.class);
    public static final DeviceIdentity IDENTITY = new DeviceIdentity(UDN.uniqueSystemIdentifier((String)"tinyMediaManager"));
    public static final DeviceDetails DEVICE_DETAILS = TmmDeviceDetails.createDeviceDetails();

    static DeviceDetails createDeviceDetails() {
        DeviceDetails details = null;
        try {
            details = new DeviceDetails(null, "tinyMediaManager", new ManufacturerDetails("tinyMediaManager", "https://www.tinymediamanager.org/"), new ModelDetails("tinyMediaManager", "tinyMediaManager - Media Server", ReleaseInfo.getVersion()), null, null, new URI("http://" + NetworkUtil.getMachineIPAddress() + ":" + Upnp.getInstance().getPort() + "/dev/" + IDENTITY.getUdn().getIdentifierString() + "/desc"), new DLNADoc[]{new DLNADoc("DMS", DLNADoc.Version.V1_5), new DLNADoc("M-DMS", DLNADoc.Version.V1_5)}, new DLNACaps(new String[0]), new DLNACaps(new String[]{"smi", "DCM10", "getMediaInfo.sec", "getCaptionInfo.sec", "av-upload", "image-upload", "audio-upload"}));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return details;
    }

    public DeviceDetails provide(RemoteClientInfo info) {
        return DEVICE_DETAILS;
    }
}

