/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.tmdb.services;

import java.util.Map;
import org.tinymediamanager.scraper.tmdb.entities.AlternativeTitles;
import org.tinymediamanager.scraper.tmdb.entities.AppendToResponse;
import org.tinymediamanager.scraper.tmdb.entities.Credits;
import org.tinymediamanager.scraper.tmdb.entities.ExternalIds;
import org.tinymediamanager.scraper.tmdb.entities.Images;
import org.tinymediamanager.scraper.tmdb.entities.Keywords;
import org.tinymediamanager.scraper.tmdb.entities.Movie;
import org.tinymediamanager.scraper.tmdb.entities.MovieResultsPage;
import org.tinymediamanager.scraper.tmdb.entities.RatingObject;
import org.tinymediamanager.scraper.tmdb.entities.ReleaseDatesResults;
import org.tinymediamanager.scraper.tmdb.entities.ReviewResultsPage;
import org.tinymediamanager.scraper.tmdb.entities.Status;
import org.tinymediamanager.scraper.tmdb.entities.Translations;
import org.tinymediamanager.scraper.tmdb.entities.Videos;
import org.tinymediamanager.scraper.tmdb.entities.WatchProviders;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.POST;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.QueryMap;

public interface MoviesService {
    @GET(value="movie/{movie_id}")
    public Call<Movie> summary(@Path(value="movie_id") int var1, @Query(value="language") String var2);

    @GET(value="movie/{movie_id}")
    public Call<Movie> summary(@Path(value="movie_id") int var1, @Query(value="language") String var2, @Query(value="append_to_response") AppendToResponse var3);

    @GET(value="movie/{movie_id}")
    public Call<Movie> summary(@Path(value="movie_id") int var1, @Query(value="language") String var2, @Query(value="append_to_response") AppendToResponse var3, @QueryMap Map<String, String> var4);

    @GET(value="movie/{movie_id}/alternative_titles")
    public Call<AlternativeTitles> alternativeTitles(@Path(value="movie_id") int var1, @Query(value="country") String var2);

    @GET(value="movie/{movie_id}/credits")
    public Call<Credits> credits(@Path(value="movie_id") int var1);

    @GET(value="movie/{movie_id}/external_ids")
    public Call<ExternalIds> externalIds(@Path(value="movie_id") int var1, @Query(value="language") String var2);

    @GET(value="movie/{movie_id}/images")
    public Call<Images> images(@Path(value="movie_id") int var1, @Query(value="language") String var2);

    @GET(value="movie/{movie_id}/keywords")
    public Call<Keywords> keywords(@Path(value="movie_id") int var1);

    @GET(value="movie/{movie_id}/similar")
    public Call<MovieResultsPage> similar(@Path(value="movie_id") int var1, @Query(value="page") Integer var2, @Query(value="language") String var3);

    @GET(value="movie/{movie_id}/recommendations")
    public Call<MovieResultsPage> recommendations(@Path(value="movie_id") int var1, @Query(value="page") Integer var2, @Query(value="language") String var3);

    @GET(value="movie/{movie_id}/release_dates")
    public Call<ReleaseDatesResults> releaseDates(@Path(value="movie_id") int var1);

    @GET(value="movie/{movie_id}/reviews")
    public Call<ReviewResultsPage> reviews(@Path(value="movie_id") int var1, @Query(value="page") Integer var2, @Query(value="language") String var3);

    @GET(value="movie/{movie_id}/translations")
    public Call<Translations> translations(@Path(value="movie_id") int var1);

    @GET(value="movie/{movie_id}/videos")
    public Call<Videos> videos(@Path(value="movie_id") int var1, @Query(value="language") String var2);

    @GET(value="movie/{movie_id}/watch/providers")
    public Call<WatchProviders> watchProviders(@Path(value="movie_id") int var1);

    @GET(value="movie/latest")
    public Call<Movie> latest();

    @GET(value="movie/now_playing")
    public Call<MovieResultsPage> nowPlaying(@Query(value="page") Integer var1, @Query(value="language") String var2, @Query(value="region") String var3);

    @GET(value="movie/popular")
    public Call<MovieResultsPage> popular(@Query(value="page") Integer var1, @Query(value="language") String var2, @Query(value="region") String var3);

    @GET(value="movie/top_rated")
    public Call<MovieResultsPage> topRated(@Query(value="page") Integer var1, @Query(value="language") String var2, @Query(value="region") String var3);

    @GET(value="movie/upcoming")
    public Call<MovieResultsPage> upcoming(@Query(value="page") Integer var1, @Query(value="language") String var2, @Query(value="region") String var3);

    @POST(value="movie/{movie_id}/rating")
    public Call<Status> addRating(@Path(value="movie_id") Integer var1, @Body RatingObject var2);

    @DELETE(value="movie/{movie_id}/rating")
    public Call<Status> deleteRating(@Path(value="movie_id") Integer var1);
}

