/*
 * Decompiled with CFR 0.152.
 */
package com.hdcookbook.grin.util;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class JsonIO {
    private static long LONG_MAX_MSD = 9000000000000000000L;

    private JsonIO() {
    }

    public static void writeJSON(Writer writer, Object object) throws IOException {
        if (object == null) {
            writer.write("null");
        } else if (object instanceof Number) {
            writer.write(object.toString());
        } else if (object instanceof Boolean) {
            if (Boolean.TRUE.equals(object)) {
                writer.write("true");
            } else {
                writer.write("false");
            }
        } else if (object instanceof String) {
            String string = (String)object;
            writer.write(34);
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c == '\"') {
                    writer.write(92);
                    writer.write(34);
                    continue;
                }
                if (c == '\\') {
                    writer.write("\\\\");
                    continue;
                }
                if (c == '\b') {
                    writer.write("\\b");
                    continue;
                }
                if (c == '\f') {
                    writer.write("\\f");
                    continue;
                }
                if (c == '\n') {
                    writer.write("\\n");
                    continue;
                }
                if (c == '\r') {
                    writer.write("\\r");
                    continue;
                }
                if (c == '\t') {
                    writer.write("\\t");
                    continue;
                }
                if (c < ' ' || c > '~') {
                    writer.write("\\u");
                    String string2 = Integer.toHexString(c);
                    for (int j = string2.length(); j < 4; ++j) {
                        writer.write(48);
                    }
                    writer.write(string2);
                    continue;
                }
                writer.write(c);
            }
            writer.write(34);
        } else if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            writer.write(91);
            for (int i = 0; i < objectArray.length; ++i) {
                if (i > 0) {
                    writer.write(44);
                }
                JsonIO.writeJSON(writer, objectArray[i]);
            }
            writer.write(93);
        } else if (object instanceof Map) {
            Map map = (Map)object;
            writer.write(123);
            boolean bl = true;
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                if (bl) {
                    bl = false;
                } else {
                    writer.write(44);
                }
                Map.Entry entry = iterator.next();
                JsonIO.writeJSON(writer, entry.getKey());
                writer.write(58);
                JsonIO.writeJSON(writer, entry.getValue());
            }
            writer.write(125);
        } else {
            throw new IOException("Invalid type " + object.getClass() + " for " + object);
        }
    }

    public static Object readJSON(Reader reader) throws IOException {
        int n;
        char c;
        if (!reader.markSupported()) {
            throw new IOException("Reader.markSupported must be true");
        }
        do {
            if ((n = reader.read()) != -1) continue;
            throw new IOException("Unexpected EOF");
        } while (JsonIO.skipWhitespace(c = (char)n, reader));
        if (c == '\"' || c == '\'') {
            return JsonIO.readString(reader, c);
        }
        if (c == '{') {
            return JsonIO.readHashMap(reader);
        }
        if (c == '[') {
            return JsonIO.readArray(reader);
        }
        if ((c = Character.toLowerCase(c)) == 't') {
            JsonIO.readConstant(reader, "rue");
            return Boolean.TRUE;
        }
        if (c == 'f') {
            JsonIO.readConstant(reader, "alse");
            return Boolean.FALSE;
        }
        if (c == 'n') {
            JsonIO.readConstant(reader, "ull");
            return null;
        }
        return JsonIO.readNumber(reader, c);
    }

    private static boolean skipWhitespace(int n, Reader reader) throws IOException {
        if (Character.isWhitespace((char)n)) {
            return true;
        }
        if (n == 47) {
            JsonIO.skipSlashComment(reader);
            return true;
        }
        if (n == 35) {
            JsonIO.skipToEOLN(reader);
            return true;
        }
        return false;
    }

    private static void skipSlashComment(Reader reader) throws IOException {
        int n = reader.read();
        if (n != 47) {
            if (n == 42) {
                boolean bl = false;
                while (true) {
                    if ((n = reader.read()) == -1) {
                        throw new IOException("Unexpected EOF");
                    }
                    if (bl && n == 47) {
                        return;
                    }
                    bl = n == 42;
                }
            }
            throw new IOException("Syntax error");
        }
        JsonIO.skipToEOLN(reader);
    }

    private static void skipToEOLN(Reader reader) throws IOException {
        int n;
        do {
            if ((n = reader.read()) != -1) continue;
            throw new IOException("Unexpected EOF");
        } while (n != 10 && n != 13);
    }

    private static String readString(Reader reader, char c) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        block10: while (true) {
            int n;
            if ((n = reader.read()) == -1) {
                throw new IOException("Unexpected EOF");
            }
            if (n == 92) {
                n = reader.read();
                switch (n) {
                    case -1: {
                        throw new IOException("Unexpected EOF");
                    }
                    case 98: {
                        stringBuffer.append('\b');
                        continue block10;
                    }
                    case 116: {
                        stringBuffer.append('\t');
                        continue block10;
                    }
                    case 110: {
                        stringBuffer.append('\n');
                        continue block10;
                    }
                    case 102: {
                        stringBuffer.append('\f');
                        continue block10;
                    }
                    case 114: {
                        stringBuffer.append('\r');
                        continue block10;
                    }
                    case 117: {
                        stringBuffer.append(JsonIO.parseHex(reader, 4));
                        continue block10;
                    }
                    case 120: {
                        stringBuffer.append(JsonIO.parseHex(reader, 2));
                        continue block10;
                    }
                }
                stringBuffer.append((char)n);
                continue;
            }
            if (n == c) {
                return stringBuffer.toString();
            }
            stringBuffer.append((char)n);
        }
    }

    private static char parseHex(Reader reader, int n) throws IOException {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 *= 16;
            int n3 = reader.read();
            if (n3 >= 48 && n3 <= 57) {
                n2 += n3 - 48;
                continue;
            }
            if (n3 >= 65 && n3 <= 70) {
                n2 += n3 - 65 + 10;
                continue;
            }
            if (n3 >= 97 && n3 <= 102) {
                n2 += n3 - 97 + 10;
                continue;
            }
            JsonIO.throwUnexpected(n3);
        }
        return (char)n2;
    }

    private static HashMap readHashMap(Reader reader) throws IOException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        while (true) {
            int n;
            if (JsonIO.skipWhitespace(n = reader.read(), reader)) {
                continue;
            }
            if (n == 125) {
                return hashMap;
            }
            if (n == 44) continue;
            if (n == 34 || n == 39) {
                String string = JsonIO.readString(reader, (char)n);
                while ((n = reader.read()) != 58) {
                    if (JsonIO.skipWhitespace(n, reader)) continue;
                    JsonIO.throwUnexpected(n);
                }
                Object object = JsonIO.readJSON(reader);
                hashMap.put(string, object);
                continue;
            }
            JsonIO.throwUnexpected(n);
        }
    }

    private static Object[] readArray(Reader reader) throws IOException {
        while (true) {
            reader.mark(1);
            int n = reader.read();
            if (n == -1) {
                JsonIO.throwUnexpected(n);
                continue;
            }
            if (n == 93) {
                return new Object[0];
            }
            if (!JsonIO.skipWhitespace(n, reader)) break;
        }
        reader.reset();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        block1: while (true) {
            arrayList.add(JsonIO.readJSON(reader));
            while (true) {
                int n;
                if ((n = reader.read()) == 44) continue block1;
                if (n == 93) {
                    return arrayList.toArray(new Object[arrayList.size()]);
                }
                if (JsonIO.skipWhitespace(n, reader)) continue;
                JsonIO.throwUnexpected(n);
            }
            break;
        }
    }

    private static void readConstant(Reader reader, String string) throws IOException {
        for (int i = 0; i < string.length(); ++i) {
            int n = reader.read();
            if (n == string.charAt(i)) continue;
            JsonIO.throwUnexpected(n);
        }
    }

    private static Number readNumber(Reader reader, char n) throws IOException {
        boolean bl = false;
        boolean bl2 = false;
        int n2 = 0;
        int n3 = n;
        if (n == 45) {
            bl = true;
            n3 = reader.read();
        }
        while (true) {
            if (n3 >= 48 && n3 <= 57) {
                bl2 = true;
                if (n2 <= -214748364) {
                    return JsonIO.readLong(reader, bl, n2, n3);
                }
                n2 *= 10;
                n2 -= n3 - 48;
                reader.mark(1);
                n3 = reader.read();
                continue;
            }
            if (n3 == 46) {
                return JsonIO.readDouble(reader, bl, n2, true);
            }
            if (n3 == 101 || n3 == 69) {
                double d = bl ? (double)n2 : -((double)n2);
                return JsonIO.readScientific(reader, d);
            }
            if (bl2) {
                reader.reset();
                if (bl) {
                    return new Integer(n2);
                }
                return new Integer(-n2);
            }
            JsonIO.throwUnexpected(n3);
        }
    }

    private static Number readLong(Reader reader, boolean bl, long l, int n) throws IOException {
        long l2 = bl ? Long.MIN_VALUE : -9223372036854775807L;
        l2 += LONG_MAX_MSD;
        l *= 10L;
        l -= (long)(n - 48);
        while (true) {
            reader.mark(1);
            n = reader.read();
            if (n >= 48 && n <= 57) {
                if (l < -922337203685477580L) {
                    reader.reset();
                    return JsonIO.readDouble(reader, bl, l, false);
                }
                int n2 = n - 48;
                if ((l *= 10L) + LONG_MAX_MSD - (long)n2 < l2) {
                    double d = l;
                    return JsonIO.readDouble(reader, bl, d -= (double)n2, false);
                }
                l -= (long)n2;
                continue;
            }
            if (n == 46) {
                return JsonIO.readDouble(reader, bl, l, true);
            }
            if (n != 101 && n != 69) break;
            double d = bl ? (double)l : -((double)l);
            JsonIO.readScientific(reader, d);
        }
        reader.reset();
        if (bl) {
            if (l >= Integer.MIN_VALUE) {
                return new Integer((int)l);
            }
            return new Long(l);
        }
        if (l >= -2147483647L) {
            return new Integer((int)(-l));
        }
        return new Long(-l);
    }

    private static Number readDouble(Reader reader, boolean bl, double d, boolean bl2) throws IOException {
        int n;
        while (!bl2) {
            reader.mark(1);
            int n2 = reader.read();
            if (n2 >= 48 && n2 <= 57) {
                d *= 10.0;
                d -= (double)(n2 - 48);
                continue;
            }
            if (n2 == 46) {
                bl2 = true;
                continue;
            }
            if (n2 == 101 || n2 == 69) {
                if (!bl) {
                    d = -d;
                }
                return JsonIO.readScientific(reader, d);
            }
            reader.reset();
            if (bl) {
                return new Double(d);
            }
            return new Double(-d);
        }
        double d2 = 1.0;
        while (true) {
            reader.mark(1);
            n = reader.read();
            if (n < 48 || n > 57) break;
            d -= (d2 /= 10.0) * (double)(n - 48);
        }
        if (n == 101 || n == 69) {
            if (!bl) {
                d = -d;
            }
            return JsonIO.readScientific(reader, d);
        }
        reader.reset();
        if (bl) {
            return new Double(d);
        }
        return new Double(-d);
    }

    private static Number readScientific(Reader reader, double d) throws IOException {
        boolean bl = false;
        int n = reader.read();
        if (n == 43) {
            n = reader.read();
        } else if (n == 45) {
            bl = true;
            n = reader.read();
        }
        if (n < 48 || n > 57) {
            JsonIO.throwUnexpected(n);
        }
        int n2 = n - 48;
        while (true) {
            reader.mark(1);
            n = reader.read();
            if (n < 48 || n > 57) break;
            n2 *= 10;
            n2 += n - 48;
        }
        reader.reset();
        if (bl) {
            return new Double(d / Math.pow(10.0, n2));
        }
        return new Double(d * Math.pow(10.0, n2));
    }

    private static void throwUnexpected(int n) throws IOException {
        Object object = n == -1 ? "EOF" : "" + (char)n;
        throw new IOException("Syntax error in JSON object:  " + (String)object + " unexpected.");
    }
}

