/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.filters;

import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.bus.EventBus;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.scraper.util.SetUtils;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.movies.filters.AbstractCheckComboBoxMovieUIFilter;

public class MovieSubtitleFormatFilter
extends AbstractCheckComboBoxMovieUIFilter<String> {
    public MovieSubtitleFormatFilter() {
        this.checkComboBox.enableFilter((s, s2) -> s.toLowerCase(Locale.ROOT).contains(s2.toLowerCase(Locale.ROOT)));
        this.buildAndInstallSubtitleFormatArray();
        EventBus.registerListener("movies-ui", event -> this.buildAndInstallSubtitleFormatArray());
    }

    @Override
    protected String parseTypeToString(String type) throws Exception {
        return type;
    }

    @Override
    protected String parseStringToType(String string) throws Exception {
        return string;
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(TmmResourceBundle.getString("metatag.subtitleformat"));
    }

    @Override
    public String getId() {
        return "movieSubtitleFormat";
    }

    @Override
    public boolean accept(Movie movie) {
        List selectedItems = this.checkComboBox.getSelectedItems();
        List<String> codecs = movie.getMediaInfoSubtitleCodecList();
        for (String sel : selectedItems) {
            if (!codecs.contains(sel)) continue;
            return true;
        }
        return false;
    }

    public void buildAndInstallSubtitleFormatArray() {
        HashSet<String> subtitleFormatsInMovies = new HashSet<String>(this.movieList.getSubtitleFormatsInMovies());
        if (!SetUtils.equals(this.oldValues, subtitleFormatsInMovies)) {
            this.oldValues.clear();
            this.oldValues.addAll(subtitleFormatsInMovies);
            List<String> sortedSubtitleFormats = ListUtils.asSortedList(subtitleFormatsInMovies);
            SwingUtilities.invokeLater(() -> this.setValues(sortedSubtitleFormats));
        }
    }
}

