/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.filters;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaSource;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.movies.filters.AbstractCheckComboBoxMovieUIFilter;

public class MovieMediaSourceFilter
extends AbstractCheckComboBoxMovieUIFilter<MediaSource> {
    public MovieMediaSourceFilter() {
        this.checkComboBox.enableFilter((s, s2) -> s.toString().toLowerCase(Locale.ROOT).contains(s2.toLowerCase(Locale.ROOT)));
        this.buildAndInstallMediaSourceArray();
        MediaSource.addListener(evt -> SwingUtilities.invokeLater(this::buildAndInstallMediaSourceArray));
    }

    @Override
    public String getId() {
        return "movieMediaSource";
    }

    @Override
    public boolean accept(Movie movie) {
        List selectedItems = this.checkComboBox.getSelectedItems();
        return selectedItems.contains(movie.getMediaSource());
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(TmmResourceBundle.getString("metatag.source"));
    }

    @Override
    protected String parseTypeToString(MediaSource type) throws Exception {
        return type.name();
    }

    @Override
    protected MediaSource parseStringToType(String string) throws Exception {
        return MediaSource.getMediaSource(string);
    }

    private void buildAndInstallMediaSourceArray() {
        ArrayList<MediaSource> mediaSources = new ArrayList<MediaSource>();
        for (MediaSource mediaSource : MediaSource.values()) {
            if (!StringUtils.isNotBlank((CharSequence)mediaSource.toString())) continue;
            mediaSources.add(mediaSource);
        }
        this.setValues(mediaSources);
    }
}

