/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.io.InterruptedIOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.imgscalr.Scalr;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.ImageUtils;
import org.tinymediamanager.core.TmmProperties;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.movie.MovieArtworkHelper;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.tvshow.TvShowArtworkHelper;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.entities.TvShowSeason;
import org.tinymediamanager.scraper.ArtworkSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaLanguages;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.http.Url;
import org.tinymediamanager.scraper.interfaces.IMediaArtworkProvider;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.scraper.util.MediaIdUtil;
import org.tinymediamanager.scraper.util.ParserUtils;
import org.tinymediamanager.ui.ArtworkDragAndDropListener;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.WrapLayout;
import org.tinymediamanager.ui.components.NoBorderScrollPane;
import org.tinymediamanager.ui.components.button.FlatButton;
import org.tinymediamanager.ui.components.button.SquareIconButton;
import org.tinymediamanager.ui.components.combobox.MediaScraperCheckComboBox;
import org.tinymediamanager.ui.components.combobox.TmmCheckComboBox;
import org.tinymediamanager.ui.components.label.ImageLabel;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.components.panel.CollapsiblePanel;
import org.tinymediamanager.ui.components.slider.RangeSlider;
import org.tinymediamanager.ui.components.textfield.EnhancedTextField;
import org.tinymediamanager.ui.dialogs.ImagePreviewDialog;
import org.tinymediamanager.ui.dialogs.TmmDialog;

public class ImageChooserDialog
extends TmmDialog {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImageChooserDialog.class);
    private static final String DIALOG_ID = "imageChooser";
    private final Map<String, Object> ids;
    private final MediaArtwork.MediaArtworkType type;
    private final MediaType mediaType;
    private final ImageLabel imageLabel;
    private final List<MediaScraper> artworkScrapers;
    private final List<JToggleButton> buttons = new ArrayList<JToggleButton>();
    private final List<JPanel> imagePanels = new ArrayList<JPanel>();
    private final List<ImageSize> imageSizes = new ArrayList<ImageSize>();
    private final List<MediaLanguages> imageLanguages = new ArrayList<MediaLanguages>();
    private final ActionListener filterListener;
    private ButtonGroup buttonGroup;
    private JProgressBar progressBar;
    private JLabel lblProgressAction;
    private JScrollPane scrollPane;
    private JPanel panelImages;
    private LockableViewPort viewport;
    private JTextField tfImageUrl;
    private String openFolderPath = null;
    private List<MediaArtwork> artwork;
    private List<String> extraThumbs = null;
    private List<String> extraFanarts = null;
    private DownloadTask task;
    private MediaScraperCheckComboBox cbScraper;
    private TmmCheckComboBox<MediaLanguages> cbLanguage;
    private RangeSlider widthSlider;
    private RangeSlider heightSlider;
    private JLabel lblMinWidth;
    private JLabel lblMaxWidth;
    private JLabel lblMinHeight;
    private JLabel lblMaxHeight;
    private JComboBox<SortOrder> cbSortOrder;
    private JLabel lblThumbs;
    private JButton btnMarkExtrathumbs;
    private JButton btnUnMarkExtrathumbs;
    private JLabel lblExtrathumbsSelected;
    private JLabel lblFanart;
    private JButton btnMarkExtrafanart;
    private JButton btnUnMarkExtrafanart;
    private JLabel lblExtrafanartSelected;
    private boolean persistFilters = false;
    private JButton btnClearWidthFilter;
    private JButton btnClearHeightFilter;

    public ImageChooserDialog(JDialog parent, Map<String, Object> ids, MediaArtwork.MediaArtworkType type, List<MediaScraper> artworkScrapers, ImageLabel imageLabel, MediaType mediaType) {
        super(parent, "", DIALOG_ID);
        this.imageLabel = imageLabel;
        this.type = type;
        this.mediaType = mediaType;
        this.ids = ids;
        this.artworkScrapers = artworkScrapers;
        this.artwork = null;
        switch (mediaType) {
            case MOVIE: 
            case MOVIE_SET: {
                this.persistFilters = MovieModuleManager.getInstance().getSettings().isStoreUiFilters();
                break;
            }
            case TV_SHOW: 
            case TV_EPISODE: {
                this.persistFilters = TvShowModuleManager.getInstance().getSettings().isStoreUiFilters();
            }
        }
        this.filterListener = e -> SwingUtilities.invokeLater(this::filterChanged);
        this.init();
        this.cbScraper.addActionListener(this.filterListener);
        this.cbLanguage.addActionListener(this.filterListener);
        this.cbLanguage.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                this.updateEntries();
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                this.updateEntries();
            }

            private void updateEntries() {
                ImageChooserDialog.this.updateLanguageCombobox();
            }
        });
        this.widthSlider.addChangeListener(e -> SwingUtilities.invokeLater(this::filterChanged));
        this.heightSlider.addChangeListener(e -> SwingUtilities.invokeLater(this::filterChanged));
        this.cbSortOrder.addActionListener(l -> SwingUtilities.invokeLater(() -> {
            this.imagePanels.sort(this.getImagePanelComparator());
            this.filterChanged();
        }));
    }

    private void init() {
        switch (this.type) {
            case BACKGROUND: {
                this.setTitle(TmmResourceBundle.getString("image.choose.fanart"));
                break;
            }
            case POSTER: {
                this.setTitle(TmmResourceBundle.getString("image.choose.poster"));
                break;
            }
            case BANNER: {
                this.setTitle(TmmResourceBundle.getString("image.choose.banner"));
                break;
            }
            case SEASON_POSTER: {
                TvShowSeason tvShowSeason;
                Object season = this.ids.get("tvShowSeason");
                if (season instanceof TvShowSeason) {
                    tvShowSeason = (TvShowSeason)season;
                    this.setTitle(TmmResourceBundle.getString("image.choose.season") + " - " + TmmResourceBundle.getString("metatag.season") + " " + tvShowSeason.getSeason());
                    break;
                }
                if (season instanceof Integer) {
                    this.setTitle(TmmResourceBundle.getString("image.choose.season") + " - " + TmmResourceBundle.getString("metatag.season") + " " + season);
                    break;
                }
                this.setTitle(TmmResourceBundle.getString("image.choose.season"));
                break;
            }
            case SEASON_FANART: {
                TvShowSeason tvShowSeason;
                Object season = this.ids.get("tvShowSeason");
                if (season instanceof TvShowSeason) {
                    tvShowSeason = (TvShowSeason)season;
                    this.setTitle(TmmResourceBundle.getString("image.choose.season.fanart") + " - " + TmmResourceBundle.getString("metatag.season") + " " + tvShowSeason.getSeason());
                    break;
                }
                if (season instanceof Integer) {
                    this.setTitle(TmmResourceBundle.getString("image.choose.season.fanart") + " - " + TmmResourceBundle.getString("metatag.season") + " " + season);
                    break;
                }
                this.setTitle(TmmResourceBundle.getString("image.choose.season.fanart"));
                break;
            }
            case SEASON_BANNER: {
                TvShowSeason tvShowSeason;
                Object season = this.ids.get("tvShowSeason");
                if (season instanceof TvShowSeason) {
                    tvShowSeason = (TvShowSeason)season;
                    this.setTitle(TmmResourceBundle.getString("image.choose.season.banner") + " - " + TmmResourceBundle.getString("metatag.season") + " " + tvShowSeason.getSeason());
                    break;
                }
                if (season instanceof Integer) {
                    this.setTitle(TmmResourceBundle.getString("image.choose.season.banner") + " - " + TmmResourceBundle.getString("metatag.season") + " " + season);
                    break;
                }
                this.setTitle(TmmResourceBundle.getString("image.choose.season.banner"));
                break;
            }
            case SEASON_THUMB: {
                TvShowSeason tvShowSeason;
                Object season = this.ids.get("tvShowSeason");
                if (season instanceof TvShowSeason) {
                    tvShowSeason = (TvShowSeason)season;
                    this.setTitle(TmmResourceBundle.getString("image.choose.season.thumb") + " - " + TmmResourceBundle.getString("metatag.season") + " " + tvShowSeason.getSeason());
                    break;
                }
                if (season instanceof Integer) {
                    this.setTitle(TmmResourceBundle.getString("image.choose.season.thumb") + " - " + TmmResourceBundle.getString("metatag.season") + " " + season);
                    break;
                }
                this.setTitle(TmmResourceBundle.getString("image.choose.season.thumb"));
                break;
            }
            case CLEARART: {
                this.setTitle(TmmResourceBundle.getString("image.choose.clearart"));
                break;
            }
            case DISC: {
                this.setTitle(TmmResourceBundle.getString("image.choose.disc"));
                break;
            }
            case CLEARLOGO: {
                this.setTitle(TmmResourceBundle.getString("image.choose.clearlogo"));
                break;
            }
            case CHARACTERART: {
                this.setTitle(TmmResourceBundle.getString("image.choose.characterart"));
                break;
            }
            case THUMB: {
                this.setTitle(TmmResourceBundle.getString("image.choose.thumb"));
                break;
            }
            case KEYART: {
                this.setTitle(TmmResourceBundle.getString("image.choose.keyart"));
            }
        }
        JPanel contentPanel = new JPanel();
        this.getContentPane().add((Component)contentPanel, "Center");
        contentPanel.setLayout((LayoutManager)new MigLayout("hidemode 3, insets n n 0 n", "[850lp,grow][]", "[][10lp!][500lp,grow][shrink 0][][]"));
        JPanel panelFilter = new JPanel();
        CollapsiblePanel collapsiblePanel = new CollapsiblePanel((JComponent)panelFilter, new TmmLabel(TmmResourceBundle.getString("movieextendedsearch.filterby")), true);
        contentPanel.add((Component)collapsiblePanel, "cell 0 0 2 1,grow, wmin 0");
        panelFilter.setLayout((LayoutManager)new MigLayout("insets 0", "[][25%:n][30lp!][][30lp:n,right][15%:25%][30lp:n,right][75lp:75lp,grow][grow][10lp!]", "[center][center]"));
        TmmLabel lblScraperT = new TmmLabel(TmmResourceBundle.getString("scraper.artwork"));
        panelFilter.add((Component)lblScraperT, "cell 0 0");
        this.cbScraper = new MediaScraperCheckComboBox(this.artworkScrapers);
        this.cbScraper.setFocusable(false);
        panelFilter.add((Component)this.cbScraper, "cell 1 0,growx,wmin 0");
        this.btnClearWidthFilter = new FlatButton(IconManager.DELETE);
        this.btnClearWidthFilter.addActionListener(actionEvent -> {
            this.widthSlider.setLowValue(this.widthSlider.getMinimum());
            this.widthSlider.setHighValue(this.widthSlider.getMaximum());
            this.filterChanged();
        });
        panelFilter.add((Component)this.btnClearWidthFilter, "cell 7 0");
        TmmLabel lblLanguageT = new TmmLabel(TmmResourceBundle.getString("metatag.language"));
        panelFilter.add((Component)lblLanguageT, "cell 0 1");
        this.cbLanguage = new TmmCheckComboBox();
        this.cbLanguage.setFocusable(false);
        this.cbLanguage.setSingleLineEditor();
        panelFilter.add(this.cbLanguage, "cell 1 1,growx,wmin 0");
        TmmLabel lblWidthT = new TmmLabel(TmmResourceBundle.getString("metatag.width"));
        panelFilter.add((Component)lblWidthT, "cell 3 0");
        this.lblMinWidth = new JLabel("");
        TmmFontHelper.changeFont((JComponent)this.lblMinWidth, 0.91667);
        panelFilter.add((Component)this.lblMinWidth, "cell 4 0");
        this.widthSlider = new RangeSlider(0, 4000);
        this.configureInitialSlider(this.widthSlider, true);
        panelFilter.add((Component)this.widthSlider, "cell 5 0,growx");
        this.lblMaxWidth = new JLabel("");
        TmmFontHelper.changeFont((JComponent)this.lblMaxWidth, 0.91667);
        panelFilter.add((Component)this.lblMaxWidth, "cell 6 0");
        TmmLabel lblHeightT = new TmmLabel(TmmResourceBundle.getString("metatag.height"));
        panelFilter.add((Component)lblHeightT, "cell 3 1");
        this.lblMinHeight = new JLabel("");
        TmmFontHelper.changeFont((JComponent)this.lblMinHeight, 0.91667);
        panelFilter.add((Component)this.lblMinHeight, "cell 4 1,alignx right");
        this.heightSlider = new RangeSlider(0, 4000);
        this.configureInitialSlider(this.heightSlider, false);
        panelFilter.add((Component)this.heightSlider, "cell 5 1,growx");
        this.lblMaxHeight = new JLabel("");
        TmmFontHelper.changeFont((JComponent)this.lblMaxHeight, 0.91667);
        panelFilter.add((Component)this.lblMaxHeight, "cell 6 1");
        JLabel lblSortByT = new JLabel(TmmResourceBundle.getString("imagechooser.sortby"));
        panelFilter.add((Component)lblSortByT, "flowx,cell 8 0,alignx trailing");
        this.cbSortOrder = new JComboBox<SortOrder>(SortOrder.values());
        panelFilter.add(this.cbSortOrder, "cell 8 0,alignx right");
        this.btnClearHeightFilter = new FlatButton(IconManager.DELETE);
        this.btnClearHeightFilter.addActionListener(actionEvent -> {
            this.heightSlider.setLowValue(this.heightSlider.getMinimum());
            this.heightSlider.setHighValue(this.heightSlider.getMaximum());
            this.filterChanged();
        });
        panelFilter.add((Component)this.btnClearHeightFilter, "cell 7 1");
        this.scrollPane = new NoBorderScrollPane();
        this.viewport = new LockableViewPort();
        this.scrollPane.setViewport(this.viewport);
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        contentPanel.add((Component)this.scrollPane, "cell 0 2 2 1,grow");
        this.panelImages = new JPanel();
        this.viewport.setView(this.panelImages);
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(16);
        this.panelImages.setLayout(new WrapLayout(0));
        JSeparator separator = new JSeparator();
        contentPanel.add((Component)separator, "cell 0 3 2 1,growx");
        this.tfImageUrl = new EnhancedTextField(TmmResourceBundle.getString("image.inserturl"));
        contentPanel.add((Component)this.tfImageUrl, "cell 0 4,growx");
        this.tfImageUrl.setColumns(10);
        JButton btnAddImage = new JButton(TmmResourceBundle.getString("image.downloadimage"));
        btnAddImage.addActionListener(e -> {
            if (StringUtils.isNotBlank((CharSequence)this.tfImageUrl.getText())) {
                this.downloadAndPreviewImage(this.tfImageUrl.getText());
            }
        });
        contentPanel.add((Component)btnAddImage, "cell 1 4");
        if (this.type == MediaArtwork.MediaArtworkType.BACKGROUND || this.type == MediaArtwork.MediaArtworkType.THUMB) {
            this.lblThumbs = new JLabel(TmmResourceBundle.getString("mediafiletype.extrathumb") + ":");
            contentPanel.add((Component)this.lblThumbs, "flowx,cell 0 5");
            this.lblThumbs.setVisible(false);
            this.btnMarkExtrathumbs = new SquareIconButton(IconManager.CHECK_ALL);
            contentPanel.add((Component)this.btnMarkExtrathumbs, "cell 0 5");
            this.btnMarkExtrathumbs.setVisible(false);
            this.btnMarkExtrathumbs.setToolTipText(TmmResourceBundle.getString("image.extrathumbs.markall"));
            this.btnMarkExtrathumbs.addActionListener(arg0 -> {
                for (JToggleButton button : this.buttons) {
                    Object patt19686$temp = button.getClientProperty("MediaArtworkExtrathumb");
                    if (!(patt19686$temp instanceof JCheckBox)) continue;
                    JCheckBox chkbx = (JCheckBox)patt19686$temp;
                    chkbx.setSelected(true);
                    this.updateExtrathumbSelectedCount();
                }
            });
            this.btnUnMarkExtrathumbs = new SquareIconButton(IconManager.CLEAR_ALL);
            contentPanel.add((Component)this.btnUnMarkExtrathumbs, "cell 0 5");
            this.btnUnMarkExtrathumbs.setVisible(false);
            this.btnUnMarkExtrathumbs.setToolTipText(TmmResourceBundle.getString("image.extrathumbs.unmarkall"));
            this.btnUnMarkExtrathumbs.addActionListener(arg0 -> {
                for (JToggleButton button : this.buttons) {
                    Object patt20303$temp = button.getClientProperty("MediaArtworkExtrathumb");
                    if (!(patt20303$temp instanceof JCheckBox)) continue;
                    JCheckBox chkbx = (JCheckBox)patt20303$temp;
                    chkbx.setSelected(false);
                    this.updateExtrathumbSelectedCount();
                }
            });
            this.lblExtrathumbsSelected = new JLabel("");
            contentPanel.add((Component)this.lblExtrathumbsSelected, "cell 0 5, gapx n 100lp");
        }
        if (this.type == MediaArtwork.MediaArtworkType.BACKGROUND) {
            this.lblFanart = new JLabel(TmmResourceBundle.getString("mediafiletype.extrafanart") + ":");
            contentPanel.add((Component)this.lblFanart, "flowx,cell 0 5");
            this.lblFanart.setVisible(false);
            this.btnMarkExtrafanart = new SquareIconButton(IconManager.CHECK_ALL);
            contentPanel.add((Component)this.btnMarkExtrafanart, "cell 0 5");
            this.btnMarkExtrafanart.setVisible(false);
            this.btnMarkExtrafanart.setToolTipText(TmmResourceBundle.getString("image.extrafanart.markall"));
            this.btnMarkExtrafanart.addActionListener(arg0 -> {
                for (JToggleButton button : this.buttons) {
                    Object patt21276$temp = button.getClientProperty("MediaArtworkExtrafanart");
                    if (!(patt21276$temp instanceof JCheckBox)) continue;
                    JCheckBox chkbx = (JCheckBox)patt21276$temp;
                    chkbx.setSelected(true);
                    this.updateExtraFanartSelectedCount();
                }
            });
            this.btnUnMarkExtrafanart = new SquareIconButton(IconManager.CLEAR_ALL);
            contentPanel.add((Component)this.btnUnMarkExtrafanart, "cell 0 5");
            this.btnUnMarkExtrafanart.setVisible(false);
            this.btnUnMarkExtrafanart.setToolTipText(TmmResourceBundle.getString("image.extrafanart.unmarkall"));
            this.btnUnMarkExtrafanart.addActionListener(arg0 -> {
                for (JToggleButton button : this.buttons) {
                    Object patt21895$temp = button.getClientProperty("MediaArtworkExtrafanart");
                    if (!(patt21895$temp instanceof JCheckBox)) continue;
                    JCheckBox chkbx = (JCheckBox)patt21895$temp;
                    chkbx.setSelected(false);
                    this.updateExtraFanartSelectedCount();
                }
            });
            this.lblExtrafanartSelected = new JLabel("");
            contentPanel.add((Component)this.lblExtrafanartSelected, "cell 0 5");
        }
        JPanel infoPanel = new JPanel();
        infoPanel.setLayout((LayoutManager)new MigLayout("", "[][grow]", "[]"));
        this.progressBar = new JProgressBar();
        infoPanel.add((Component)this.progressBar, "cell 0 0");
        this.lblProgressAction = new JLabel("");
        infoPanel.add((Component)this.lblProgressAction, "cell 1 0");
        this.setBottomInformationPanel(infoPanel);
        JButton cancelButton = new JButton(TmmResourceBundle.getString("Button.cancel"));
        CancelAction actionCancel = new CancelAction();
        cancelButton.setAction(actionCancel);
        cancelButton.setActionCommand("Cancel");
        this.addButton(cancelButton);
        JButton btnAddFile = new JButton(TmmResourceBundle.getString("Button.addfile"));
        LocalFileChooseAction actionLocalFile = new LocalFileChooseAction();
        btnAddFile.setAction(actionLocalFile);
        this.addButton(btnAddFile);
        JButton okButton = new JButton(TmmResourceBundle.getString("Button.ok"));
        OkAction actionOK = new OkAction();
        okButton.setAction(actionOK);
        okButton.setActionCommand("OK");
        this.addDefaultButton(okButton);
        new DropTarget(this, new ArtworkDragAndDropListener(this.imageLabel){

            @Override
            public void drop(DropTargetDropEvent dtde) {
                super.drop(dtde);
                if (ImageChooserDialog.this.task != null) {
                    ImageChooserDialog.this.task.cancel(true);
                }
                ImageChooserDialog.this.setVisible(false);
            }
        });
        if (this.persistFilters) {
            this.loadFilters();
        }
        this.filterChanged();
    }

    private void loadFilters() {
        String sortOrder;
        List<String> languages;
        List<String> scraperIds = ParserUtils.split(TmmProperties.getInstance().getProperty("imagechooser.scrapers." + this.mediaType.name() + "." + this.type.name()));
        if (!scraperIds.isEmpty()) {
            ArrayList<Object> selectedScrapers = new ArrayList<Object>();
            for (Object scraper : this.cbScraper.getItems()) {
                if (!scraperIds.contains(((MediaScraper)scraper).getId())) continue;
                selectedScrapers.add(scraper);
            }
            if (!selectedScrapers.isEmpty()) {
                this.cbScraper.setSelectedItems(selectedScrapers);
            }
        }
        if (!(languages = ParserUtils.split(TmmProperties.getInstance().getProperty("imagechooser.language." + this.mediaType.name() + "." + this.type.name()))).isEmpty()) {
            ArrayList<MediaLanguages> selectedLanguages = new ArrayList<MediaLanguages>();
            for (String lang : languages) {
                try {
                    MediaLanguages language = MediaLanguages.valueOf(lang);
                    selectedLanguages.add(language);
                }
                catch (Exception language) {}
            }
            if (!selectedLanguages.isEmpty()) {
                this.cbLanguage.setItems(selectedLanguages);
                this.cbLanguage.setSelectedItems(selectedLanguages);
            }
        }
        int minWidth = TmmProperties.getInstance().getPropertyAsInteger("imagechooser.minwidth." + this.mediaType.name() + "." + this.type.name());
        int maxWidth = TmmProperties.getInstance().getPropertyAsInteger("imagechooser.maxwidth." + this.mediaType.name() + "." + this.type.name());
        if (minWidth > 0 && maxWidth > 0 && maxWidth >= minWidth) {
            try {
                this.widthSlider.setLowValue(minWidth);
                this.widthSlider.setHighValue(maxWidth);
            }
            catch (Exception lang) {
                // empty catch block
            }
        }
        int minHeight = TmmProperties.getInstance().getPropertyAsInteger("imagechooser.minheight." + this.mediaType.name() + "." + this.type.name());
        int maxHeight = TmmProperties.getInstance().getPropertyAsInteger("imagechooser.maxheight." + this.mediaType.name() + "." + this.type.name());
        if (minHeight > 0 && maxHeight > 0 && maxHeight >= minHeight) {
            try {
                this.heightSlider.setLowValue(minHeight);
                this.heightSlider.setHighValue(maxHeight);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(sortOrder = TmmProperties.getInstance().getProperty("imagechooser.sortorder." + this.mediaType.name() + "." + this.type.name())))) {
            try {
                this.cbSortOrder.setSelectedItem((Object)SortOrder.valueOf(sortOrder));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void startScraping() {
        this.task = new DownloadTask(this.ids, this.artworkScrapers, this.artwork);
        this.task.execute();
    }

    private void updateExtrathumbSelectedCount() {
        int count = 0;
        for (JToggleButton btn : this.buttons) {
            JCheckBox checkBox;
            Object object = btn.getClientProperty("MediaArtworkExtrathumb");
            if (!(object instanceof JCheckBox) || !(checkBox = (JCheckBox)object).isSelected()) continue;
            ++count;
        }
        if (count > 0) {
            this.lblExtrathumbsSelected.setText(count + " " + TmmResourceBundle.getString("tmm.selected"));
        } else {
            this.lblExtrathumbsSelected.setText("");
        }
    }

    private void setArtwork(List<MediaArtwork> artwork) {
        this.artwork = artwork;
    }

    private void updateExtraFanartSelectedCount() {
        int count = 0;
        for (JToggleButton btn : this.buttons) {
            JCheckBox checkBox;
            Object object = btn.getClientProperty("MediaArtworkExtrafanart");
            if (!(object instanceof JCheckBox) || !(checkBox = (JCheckBox)object).isSelected()) continue;
            ++count;
        }
        if (count > 0) {
            this.lblExtrafanartSelected.setText(count + " " + TmmResourceBundle.getString("tmm.selected"));
        } else {
            this.lblExtrafanartSelected.setText("");
        }
    }

    public void bindExtraThumbs(List<String> extraThumbs) {
        if (this.type != MediaArtwork.MediaArtworkType.BACKGROUND && this.type != MediaArtwork.MediaArtworkType.THUMB) {
            return;
        }
        this.extraThumbs = extraThumbs;
        if (extraThumbs != null) {
            this.lblThumbs.setVisible(true);
            this.btnMarkExtrathumbs.setVisible(true);
            this.btnUnMarkExtrathumbs.setVisible(true);
        } else {
            this.lblThumbs.setVisible(false);
            this.btnMarkExtrathumbs.setVisible(false);
            this.btnUnMarkExtrathumbs.setVisible(false);
        }
    }

    public void bindExtraFanarts(List<String> extraFanarts) {
        if (this.type != MediaArtwork.MediaArtworkType.BACKGROUND) {
            return;
        }
        this.extraFanarts = extraFanarts;
        if (extraFanarts != null) {
            this.lblFanart.setVisible(true);
            this.btnMarkExtrafanart.setVisible(true);
            this.btnUnMarkExtrafanart.setVisible(true);
        } else {
            this.lblFanart.setVisible(false);
            this.btnMarkExtrafanart.setVisible(false);
            this.btnUnMarkExtrafanart.setVisible(false);
        }
    }

    public void setOpenFolderPath(String openFolderPath) {
        this.openFolderPath = openFolderPath;
    }

    private void startProgressBar(String description) {
        this.lblProgressAction.setText(description);
        this.progressBar.setVisible(true);
        this.progressBar.setIndeterminate(true);
    }

    private void stopProgressBar() {
        this.lblProgressAction.setText("");
        this.progressBar.setVisible(false);
        this.progressBar.setIndeterminate(false);
    }

    private void addImage(byte[] imageData, MediaArtwork artwork) throws Exception {
        BufferedImage originalImage = ImageUtils.createImage(imageData);
        artwork.addImageSize(originalImage.getWidth(), originalImage.getHeight(), artwork.getPreviewUrl(), 0);
        Point size = null;
        GridBagLayout gbl = new GridBagLayout();
        switch (this.type) {
            case BACKGROUND: 
            case CLEARART: 
            case DISC: 
            case CHARACTERART: 
            case THUMB: {
                size = ImageUtils.calculateSize(300, 150, originalImage.getWidth(), originalImage.getHeight(), true);
                break;
            }
            case BANNER: 
            case CLEARLOGO: 
            case LOGO: {
                size = ImageUtils.calculateSize(300, 100, originalImage.getWidth(), originalImage.getHeight(), true);
                break;
            }
            default: {
                size = ImageUtils.calculateSize(150, 250, originalImage.getWidth(), originalImage.getHeight(), true);
            }
        }
        gbl.columnWeights = new double[]{Double.MIN_VALUE};
        gbl.rowWeights = new double[]{Double.MIN_VALUE};
        JPanel imagePanel = new JPanel();
        imagePanel.setLayout(gbl);
        int row = 0;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = row;
        gbc.gridwidth = 4;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        final JToggleButton button = new JToggleButton();
        button.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() >= 2 && e.getButton() == 1) {
                    button.setSelected(true);
                    new OkAction().actionPerformed(new ActionEvent(e.getSource(), e.getID(), "OK"));
                }
            }
        });
        button.setBackground(Color.white);
        button.setMargin(new Insets(10, 10, 10, 10));
        if (artwork.isAnimated()) {
            button.setText("<html><img width=\"" + size.x + "\" height=\"" + size.y + "\" src='" + artwork.getPreviewUrl() + "'/></html>");
            button.setBorder(BorderFactory.createLineBorder(Color.GREEN, 3));
        } else {
            ImageIcon imageIcon = new ImageIcon(Scalr.resize((BufferedImage)originalImage, (Scalr.Method)Scalr.Method.QUALITY, (Scalr.Mode)Scalr.Mode.AUTOMATIC, (int)size.x, (int)size.y, (BufferedImageOp[])new BufferedImageOp[]{Scalr.OP_ANTIALIAS}));
            button.setIcon(imageIcon);
        }
        button.putClientProperty("MediaArtwork", artwork);
        this.buttons.add(button);
        imagePanel.add((Component)button, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = ++row;
        gbc.gridwidth = 3;
        gbc.anchor = 25;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 5, 0, 5);
        JComboBox<Object> cb = !artwork.getImageSizes().isEmpty() ? new JComboBox<Object>(artwork.getImageSizes().toArray()) : new JComboBox<String>(new String[]{originalImage.getWidth() + "x" + originalImage.getHeight()});
        button.putClientProperty("MediaArtworkSize", cb);
        imagePanel.add(cb, gbc);
        originalImage.flush();
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = row;
        gbc.insets = new Insets(0, 5, 0, 5);
        FlatButton btnShowOriginalImage = new FlatButton(IconManager.LINK);
        btnShowOriginalImage.setToolTipText(TmmResourceBundle.getString("image.showoriginal"));
        btnShowOriginalImage.addActionListener(e -> {
            ImagePreviewDialog dialog = new ImagePreviewDialog(artwork.getOriginalUrl());
            String path = StringUtils.isNotBlank((CharSequence)this.openFolderPath) ? this.openFolderPath : TmmProperties.getInstance().getProperty("imageChooser.path");
            dialog.setOpenFolderPath(path);
            dialog.setVisible(true);
        });
        imagePanel.add((Component)btnShowOriginalImage, gbc);
        if (this.extraFanarts != null || this.extraThumbs != null) {
            JCheckBox chkbx;
            int x = 0;
            int y = ++row;
            if (this.extraFanarts != null) {
                gbc = new GridBagConstraints();
                gbc.gridx = x;
                gbc.gridy = y;
                gbc.anchor = 25;
                gbc.insets = new Insets(0, 5, 0, 5);
                chkbx = new JCheckBox("Extrafanart");
                button.putClientProperty("MediaArtworkExtrafanart", chkbx);
                chkbx.addActionListener(l -> this.updateExtraFanartSelectedCount());
                imagePanel.add((Component)chkbx, gbc);
                x += 2;
            }
            if (this.extraThumbs != null) {
                gbc = new GridBagConstraints();
                gbc.gridx = x;
                gbc.gridy = y;
                gbc.anchor = 25;
                gbc.insets = new Insets(0, 5, 0, 5);
                chkbx = new JCheckBox("Extrathumb");
                button.putClientProperty("MediaArtworkExtrathumb", chkbx);
                chkbx.addActionListener(l -> this.updateExtrathumbSelectedCount());
                imagePanel.add((Component)chkbx, gbc);
            }
        }
        imagePanel.putClientProperty("MediaArtwork", artwork);
        this.imagePanels.add(imagePanel);
        this.imagePanels.sort(this.getImagePanelComparator());
        SwingUtilities.invokeLater(() -> {
            artwork.getImageSizes().forEach(sizeAndUrl -> {
                ImageSize imageSize = new ImageSize(sizeAndUrl.getWidth(), sizeAndUrl.getHeight());
                if (!this.imageSizes.contains(imageSize)) {
                    this.imageSizes.add(imageSize);
                }
            });
            MediaLanguages mediaLanguage = "-".equals(artwork.getLanguage()) ? MediaLanguages.none : MediaLanguages.get(artwork.getLanguage());
            if (!this.imageLanguages.contains((Object)mediaLanguage)) {
                this.imageLanguages.add(mediaLanguage);
            }
            this.updateSizeSlider();
            this.updateLanguageCombobox();
            this.filterChanged();
        });
    }

    private void configureInitialSlider(RangeSlider slider, boolean isWidth) {
        slider.setMaximum(this.getSuggestedMax(isWidth));
        this.configureSliderTicks(slider, isWidth);
        slider.setHighValue(slider.getMaximum());
        slider.addPropertyChangeListener("maximum", evt -> this.configureSliderTicks(slider, isWidth));
    }

    @NotNull
    private Comparator<JPanel> getImagePanelComparator() {
        return (o1, o2) -> {
            MediaArtwork artwork1;
            Object obj2;
            block16: {
                block15: {
                    Object obj1 = o1.getClientProperty("MediaArtwork");
                    obj2 = o2.getClientProperty("MediaArtwork");
                    if (!(obj1 instanceof MediaArtwork)) break block15;
                    artwork1 = (MediaArtwork)obj1;
                    if (obj2 instanceof MediaArtwork) break block16;
                }
                return 0;
            }
            MediaArtwork artwork2 = (MediaArtwork)obj2;
            int result = 0;
            if (this.cbSortOrder.getSelectedItem() == SortOrder.SCORE) {
                int score1 = 0;
                int score2 = 0;
                if (this.mediaType == MediaType.MOVIE || this.mediaType == MediaType.MOVIE_SET) {
                    score1 = MovieArtworkHelper.getMatchingScoreAccordingPreferences(artwork1);
                    score2 = MovieArtworkHelper.getMatchingScoreAccordingPreferences(artwork2);
                } else if (this.mediaType == MediaType.TV_SHOW || this.mediaType == MediaType.TV_EPISODE) {
                    score1 = TvShowArtworkHelper.getMatchingScoreAccordingPreferences(artwork1);
                    score2 = TvShowArtworkHelper.getMatchingScoreAccordingPreferences(artwork2);
                }
                result = Integer.compare(score2, score1);
                if (result == 0) {
                    result = Integer.compare(artwork2.getLikes(), artwork1.getLikes());
                }
                if (result == 0) {
                    result = artwork1.getBiggestArtwork() == null || artwork2.getBiggestArtwork() == null ? 0 : artwork2.getBiggestArtwork().compareTo(artwork1.getBiggestArtwork());
                }
            } else if (this.cbSortOrder.getSelectedItem() == SortOrder.SIZE) {
                if (artwork1.getBiggestArtwork() == null || artwork2.getBiggestArtwork() == null) {
                    return 0;
                }
                result = artwork2.getBiggestArtwork().compareTo(artwork1.getBiggestArtwork());
                if (result == 0) {
                    result = Integer.compare(artwork2.getLikes(), artwork1.getLikes());
                }
                if (result == 0) {
                    result = MovieArtworkHelper.getMatchingScoreAccordingPreferences(artwork2) - MovieArtworkHelper.getMatchingScoreAccordingPreferences(artwork1);
                }
            }
            return result;
        };
    }

    private void updateSizeSlider() {
        int maxWidth = 0;
        for (ImageSize imageSize : this.imageSizes) {
            if (imageSize.width <= maxWidth) continue;
            maxWidth = imageSize.width;
        }
        int suggestedWidthMax = this.getSuggestedMax(true);
        int targetWidthMax = Math.max(suggestedWidthMax, maxWidth);
        if (this.widthSlider.getMaximum() != targetWidthMax) {
            this.widthSlider.setMaximum(targetWidthMax);
            this.widthSlider.setHighValue(targetWidthMax);
        }
        int maxHeight = 0;
        for (ImageSize imageSize : this.imageSizes) {
            if (imageSize.height <= maxHeight) continue;
            maxHeight = imageSize.height;
        }
        int suggestedHeightMax = this.getSuggestedMax(false);
        int targetHeightMax = Math.max(suggestedHeightMax, maxHeight);
        if (this.heightSlider.getMaximum() != targetHeightMax) {
            this.heightSlider.setMaximum(targetHeightMax);
            this.heightSlider.setHighValue(targetHeightMax);
        }
        this.configureSliderTicks(this.widthSlider, true);
        this.configureSliderTicks(this.heightSlider, false);
    }

    private void updateLanguageCombobox() {
        if (this.cbLanguage.isPopupVisible()) {
            return;
        }
        List<MediaLanguages> allItems = this.cbLanguage.getItems();
        if (allItems.size() == this.imageLanguages.size()) {
            return;
        }
        this.cbLanguage.removeActionListener(this.filterListener);
        List<MediaLanguages> selectedItems = this.cbLanguage.getSelectedItems();
        for (MediaLanguages mediaLanguages : this.imageLanguages) {
            if (allItems.contains((Object)mediaLanguages)) continue;
            allItems.add(mediaLanguages);
        }
        ArrayList<MediaLanguages> newValues = new ArrayList<MediaLanguages>();
        newValues.add(MediaLanguages.none);
        for (MediaLanguages mediaLanguages : MediaLanguages.valuesSorted()) {
            if (!allItems.contains((Object)mediaLanguages)) continue;
            newValues.add(mediaLanguages);
        }
        this.cbLanguage.setItems(newValues);
        this.cbLanguage.setSelectedItems(selectedItems);
        this.cbLanguage.addActionListener(this.filterListener);
    }

    private void filterChanged() {
        this.lblMinWidth.setText(String.valueOf(this.widthSlider.getLowValue()));
        this.lblMaxWidth.setText(String.valueOf(this.widthSlider.getHighValue()));
        this.lblMinHeight.setText(String.valueOf(this.heightSlider.getLowValue()));
        this.lblMaxHeight.setText(String.valueOf(this.heightSlider.getHighValue()));
        this.panelImages.removeAll();
        ButtonModel selectedButton = null;
        if (this.buttonGroup != null) {
            selectedButton = this.buttonGroup.getSelection();
        }
        this.buttonGroup = new NoneSelectedButtonGroup();
        for (JPanel panel : this.imagePanels) {
            Object obj = panel.getClientProperty("MediaArtwork");
            if (!(obj instanceof MediaArtwork)) continue;
            MediaArtwork mediaArtwork = (MediaArtwork)obj;
            if (this.cbScraper.getSelectedItems().isEmpty() && this.widthSlider.isUnchanged() && this.heightSlider.isUnchanged() && this.cbLanguage.getSelectedItems().isEmpty()) {
                this.panelImages.add(panel);
                for (Component component : panel.getComponents()) {
                    if (component instanceof JCheckBox || !(component instanceof JToggleButton)) continue;
                    JToggleButton button = (JToggleButton)component;
                    this.buttonGroup.add(button);
                    this.updateResolutionCombobox(button, false);
                }
                continue;
            }
            boolean scraperMatch = true;
            boolean sizeMatch = true;
            boolean languageMatch = true;
            if (!this.cbScraper.getSelectedItems().isEmpty()) {
                scraperMatch = false;
                for (MediaScraper scraper : this.cbScraper.getSelectedItems()) {
                    if (!scraper.getId().equals(mediaArtwork.getProviderId())) continue;
                    scraperMatch = true;
                    break;
                }
            }
            if (!this.widthSlider.isUnchanged() || !this.heightSlider.isUnchanged()) {
                sizeMatch = false;
                for (MediaArtwork.ImageSizeAndUrl imageSizeAndUrl : mediaArtwork.getImageSizes()) {
                    if (!this.widthSlider.contains(imageSizeAndUrl.getWidth()) || !this.heightSlider.contains(imageSizeAndUrl.getHeight())) continue;
                    sizeMatch = true;
                    break;
                }
            }
            if (!this.cbLanguage.getSelectedItems().isEmpty()) {
                languageMatch = false;
                ArrayList<String> arrayList = new ArrayList<String>();
                for (MediaLanguages mediaLanguages : this.cbLanguage.getSelectedItems()) {
                    if (mediaLanguages == MediaLanguages.none) {
                        arrayList.add("-");
                        arrayList.add("");
                        continue;
                    }
                    arrayList.add(mediaLanguages.getLanguage().toLowerCase(Locale.ROOT));
                }
                if (arrayList.contains(mediaArtwork.getLanguage())) {
                    languageMatch = true;
                }
            }
            if (!scraperMatch || !sizeMatch || !languageMatch) continue;
            this.panelImages.add(panel);
            for (Component child3 : panel.getComponents()) {
                if (child3 instanceof JCheckBox || !(child3 instanceof JToggleButton)) continue;
                JToggleButton button = (JToggleButton)child3;
                this.updateResolutionCombobox(button, !this.widthSlider.isUnchanged() || !this.heightSlider.isUnchanged());
            }
        }
        if (selectedButton != null) {
            this.buttonGroup.setSelected(selectedButton, true);
        }
        this.viewport.setLocked(true);
        this.panelImages.revalidate();
        this.scrollPane.revalidate();
        this.getContentPane().revalidate();
        this.getContentPane().repaint();
        this.viewport.setLocked(false);
    }

    private void updateResolutionCombobox(JToggleButton button, boolean filterBySizeRange) {
        Object comboboxProperty = button.getClientProperty("MediaArtworkSize");
        Object artworkProperty = button.getClientProperty("MediaArtwork");
        if (!(comboboxProperty instanceof JComboBox) || !(artworkProperty instanceof MediaArtwork)) {
            return;
        }
        JComboBox cb = (JComboBox)comboboxProperty;
        MediaArtwork artwork = (MediaArtwork)artworkProperty;
        cb.removeAllItems();
        if (artwork.getImageSizes().isEmpty()) {
            return;
        }
        for (MediaArtwork.ImageSizeAndUrl sizeAndUrl : artwork.getImageSizes()) {
            if (!filterBySizeRange) {
                cb.addItem(sizeAndUrl);
                continue;
            }
            if (!this.widthSlider.contains(sizeAndUrl.getWidth()) || !this.heightSlider.contains(sizeAndUrl.getHeight())) continue;
            cb.addItem(sizeAndUrl);
        }
        if (cb.getItemCount() > 0) {
            cb.setSelectedIndex(0);
        }
    }

    private void downloadAndPreviewImage(String url) {
        Runnable task = () -> {
            try {
                MediaArtwork art;
                switch (this.type) {
                    case BANNER: {
                        art = new MediaArtwork("", MediaArtwork.MediaArtworkType.BANNER);
                        break;
                    }
                    case CLEARART: {
                        art = new MediaArtwork("", MediaArtwork.MediaArtworkType.CLEARART);
                        break;
                    }
                    case DISC: {
                        art = new MediaArtwork("", MediaArtwork.MediaArtworkType.DISC);
                        break;
                    }
                    case BACKGROUND: {
                        art = new MediaArtwork("", MediaArtwork.MediaArtworkType.BACKGROUND);
                        break;
                    }
                    case CLEARLOGO: 
                    case LOGO: {
                        art = new MediaArtwork("", MediaArtwork.MediaArtworkType.CLEARLOGO);
                        break;
                    }
                    case CHARACTERART: {
                        art = new MediaArtwork("", MediaArtwork.MediaArtworkType.CHARACTERART);
                        break;
                    }
                    case POSTER: {
                        art = new MediaArtwork("", MediaArtwork.MediaArtworkType.POSTER);
                        break;
                    }
                    case SEASON_POSTER: {
                        art = new MediaArtwork("", MediaArtwork.MediaArtworkType.SEASON_POSTER);
                        break;
                    }
                    case SEASON_FANART: {
                        art = new MediaArtwork("", MediaArtwork.MediaArtworkType.SEASON_FANART);
                        break;
                    }
                    case SEASON_BANNER: {
                        art = new MediaArtwork("", MediaArtwork.MediaArtworkType.SEASON_BANNER);
                        break;
                    }
                    case SEASON_THUMB: {
                        art = new MediaArtwork("", MediaArtwork.MediaArtworkType.SEASON_THUMB);
                        break;
                    }
                    case THUMB: {
                        art = new MediaArtwork("", MediaArtwork.MediaArtworkType.THUMB);
                        break;
                    }
                    case KEYART: {
                        art = new MediaArtwork("", MediaArtwork.MediaArtworkType.KEYART);
                        break;
                    }
                    default: {
                        return;
                    }
                }
                art.setPreviewUrl(url);
                art.setOriginalUrl(url);
                Url previewUrl = new Url(art.getPreviewUrl());
                byte[] artworkBytes = previewUrl.getBytesWithRetry(5);
                if (artworkBytes.length > 0) {
                    SwingUtilities.invokeLater(() -> {
                        try {
                            this.addImage(artworkBytes, art);
                        }
                        catch (Exception e) {
                            LOGGER.debug("Could not add image '{}' - '{}'", (Object)art.getPreviewUrl(), (Object)e.getMessage());
                        }
                    });
                    this.tfImageUrl.setText("");
                } else {
                    JOptionPane.showMessageDialog(this, TmmResourceBundle.getString("message.errorloadimage"));
                }
            }
            catch (Exception e) {
                LOGGER.error("Could not download manually entered image url '{}' - '{}'", (Object)this.tfImageUrl.getText(), (Object)e.getMessage());
            }
        };
        task.run();
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible && this.task == null) {
            this.startScraping();
        }
        super.setVisible(visible);
    }

    private void persistFilters() {
        List<MediaScraper> selectedScrapers = this.cbScraper.getSelectedItems();
        ArrayList<String> scraperIds = new ArrayList<String>();
        for (MediaScraper scraper : selectedScrapers) {
            scraperIds.add(scraper.getId());
        }
        TmmProperties.getInstance().putProperty("imagechooser.scrapers." + this.mediaType.name() + "." + this.type.name(), String.join((CharSequence)",", scraperIds));
        List<MediaLanguages> selectedLanguages = this.cbLanguage.getSelectedItems();
        ArrayList<String> languages = new ArrayList<String>();
        for (MediaLanguages lang : selectedLanguages) {
            languages.add(lang.name());
        }
        TmmProperties.getInstance().putProperty("imagechooser.language." + this.mediaType.name() + "." + this.type.name(), String.join((CharSequence)",", languages));
        TmmProperties.getInstance().putProperty("imagechooser.minwidth." + this.mediaType.name() + "." + this.type.name(), String.valueOf(this.widthSlider.getLowValue()));
        TmmProperties.getInstance().putProperty("imagechooser.maxwidth." + this.mediaType.name() + "." + this.type.name(), String.valueOf(this.widthSlider.getHighValue()));
        TmmProperties.getInstance().putProperty("imagechooser.minheight." + this.mediaType.name() + "." + this.type.name(), String.valueOf(this.heightSlider.getLowValue()));
        TmmProperties.getInstance().putProperty("imagechooser.maxheight." + this.mediaType.name() + "." + this.type.name(), String.valueOf(this.heightSlider.getHighValue()));
        TmmProperties.getInstance().putProperty("imagechooser.sortorder." + this.mediaType.name() + "." + this.type.name(), ((SortOrder)((Object)this.cbSortOrder.getSelectedItem())).name());
    }

    public static String chooseImage(JDialog parent, Map<String, Object> ids, MediaArtwork.MediaArtworkType type, List<MediaScraper> artworkScrapers, MediaType mediaType, String defaultPath) {
        return ImageChooserDialog.chooseImage(parent, ids, type, artworkScrapers, null, null, mediaType, defaultPath);
    }

    public static String chooseImage(JDialog parent, Map<String, Object> ids, MediaArtwork.MediaArtworkType type, List<MediaScraper> artworkScrapers, List<String> extraThumbs, List<String> extraFanarts, MediaType mediaType, String defaultPath) {
        if (ids.isEmpty()) {
            return "";
        }
        ImageLabel lblImage = new ImageLabel();
        ImageChooserDialog dialog = new ImageChooserDialog(parent, ids, type, artworkScrapers, lblImage, mediaType);
        dialog.bindExtraThumbs(extraThumbs);
        dialog.bindExtraFanarts(extraFanarts);
        dialog.setOpenFolderPath(defaultPath);
        dialog.setLocationRelativeTo(MainWindow.getInstance());
        dialog.startScraping();
        dialog.setVisible(true);
        return lblImage.getImageUrl();
    }

    public static String chooseImage(JDialog parent, Map<String, Object> ids, MediaArtwork.MediaArtworkType type, List<MediaScraper> artworkScrapers, List<String> extraThumbs, List<String> extraFanarts, List<MediaArtwork> artwork, MediaType mediaType, String defaultPath) {
        if (ids.isEmpty() || ListUtils.isEmpty(artwork)) {
            return "";
        }
        List<MediaArtwork> filteredArtwork = artwork.stream().filter(mediaArtwork -> mediaArtwork.getType() == type).toList();
        ImageLabel lblImage = new ImageLabel();
        ImageChooserDialog dialog = new ImageChooserDialog(parent, ids, type, artworkScrapers, lblImage, mediaType);
        dialog.setArtwork(filteredArtwork);
        dialog.bindExtraThumbs(extraThumbs);
        dialog.bindExtraFanarts(extraFanarts);
        dialog.setOpenFolderPath(defaultPath);
        dialog.setLocationRelativeTo(MainWindow.getInstance());
        dialog.startScraping();
        dialog.setVisible(true);
        return lblImage.getImageUrl();
    }

    private void configureSliderTicks(RangeSlider slider, boolean isWidth) {
        int majorSpacing;
        slider.setPaintTicks(true);
        slider.setPaintLabels(true);
        slider.setSnapToTicks(true);
        int[] majors = this.getWellKnownSizes(isWidth);
        Hashtable<Integer, JLabel> table = new Hashtable<Integer, JLabel>();
        int min = slider.getMinimum();
        int max = slider.getMaximum();
        ArrayList<Integer> majorsInRange = new ArrayList<Integer>();
        for (int v : majors) {
            if (v < min || v > max || majorsInRange.contains(v)) continue;
            majorsInRange.add(v);
        }
        ArrayList<Integer> filteredMajors = new ArrayList<Integer>();
        if (majorsInRange.size() <= 6) {
            filteredMajors.addAll(majorsInRange);
        } else {
            double minSeparation = 0.18;
            double lastNorm = -1.0;
            Iterator iterator = majorsInRange.iterator();
            while (iterator.hasNext()) {
                int v = (Integer)iterator.next();
                double norm = (double)(v - min) / Math.max(1.0, (double)(max - min));
                if (!(lastNorm < 0.0) && !(norm - lastNorm >= minSeparation)) continue;
                filteredMajors.add(v);
                lastNorm = norm;
            }
            if (!majorsInRange.isEmpty()) {
                double normPrev;
                int last = (Integer)majorsInRange.get(majorsInRange.size() - 1);
                double normLast = (double)(last - min) / Math.max(1.0, (double)(max - min));
                double d = normPrev = filteredMajors.isEmpty() ? -1.0 : (double)((Integer)filteredMajors.get(filteredMajors.size() - 1) - min) / Math.max(1.0, (double)(max - min));
                if ((filteredMajors.isEmpty() || normLast - normPrev >= minSeparation) && !filteredMajors.contains(last)) {
                    filteredMajors.add(last);
                }
            }
        }
        Iterator minSeparation = filteredMajors.iterator();
        while (minSeparation.hasNext()) {
            int v = (Integer)minSeparation.next();
            table.put(v, new JLabel(String.valueOf(v)));
        }
        int range = Math.max(1, max - min);
        if (majors.length >= 2) {
            int step = Math.abs(majors[1] - majors[0]);
            majorSpacing = Math.max(50, step);
        } else {
            majorSpacing = Math.max(100, range / 5);
        }
        int maxMajorTicks = 12;
        majorSpacing = Math.max(majorSpacing, (int)Math.ceil((double)range / (double)maxMajorTicks));
        int minorSpacing = majorSpacing > 0 ? Math.max(10, majorSpacing / 5) : Math.max(20, range / 20);
        slider.setMajorTickSpacing(majorSpacing);
        slider.setMinorTickSpacing(minorSpacing);
        slider.setLabelTable(table);
    }

    private int[] getWellKnownSizes(boolean isWidth) {
        int[] nArray;
        if (isWidth) {
            int[] nArray2 = new int[4];
            nArray2[0] = 640;
            nArray2[1] = 1280;
            nArray2[2] = 1920;
            nArray = nArray2;
            nArray2[3] = 3840;
        } else {
            int[] nArray3 = new int[4];
            nArray3[0] = 360;
            nArray3[1] = 720;
            nArray3[2] = 1080;
            nArray = nArray3;
            nArray3[3] = 2160;
        }
        int[] fallback = nArray;
        switch (this.type) {
            case POSTER: 
            case SEASON_POSTER: 
            case KEYART: {
                int[] nArray4;
                if (isWidth) {
                    int[] nArray5 = new int[3];
                    nArray5[0] = 500;
                    nArray5[1] = 1000;
                    nArray4 = nArray5;
                    nArray5[2] = 2000;
                } else {
                    int[] nArray6 = new int[3];
                    nArray6[0] = 750;
                    nArray6[1] = 1500;
                    nArray4 = nArray6;
                    nArray6[2] = 3000;
                }
                return nArray4;
            }
            case BACKGROUND: 
            case SEASON_FANART: {
                int[] nArray7;
                if (isWidth) {
                    int[] nArray8 = new int[3];
                    nArray8[0] = 1280;
                    nArray8[1] = 1920;
                    nArray7 = nArray8;
                    nArray8[2] = 3840;
                } else {
                    int[] nArray9 = new int[3];
                    nArray9[0] = 720;
                    nArray9[1] = 1080;
                    nArray7 = nArray9;
                    nArray9[2] = 2160;
                }
                return nArray7;
            }
            case SEASON_THUMB: 
            case THUMB: {
                int[] nArray10;
                if (isWidth) {
                    int[] nArray11 = new int[3];
                    nArray11[0] = 320;
                    nArray11[1] = 640;
                    nArray10 = nArray11;
                    nArray11[2] = 1280;
                } else {
                    int[] nArray12 = new int[3];
                    nArray12[0] = 180;
                    nArray12[1] = 360;
                    nArray10 = nArray12;
                    nArray12[2] = 720;
                }
                return nArray10;
            }
            case BANNER: 
            case SEASON_BANNER: {
                int[] nArray13;
                if (isWidth) {
                    int[] nArray14 = new int[2];
                    nArray14[0] = 1000;
                    nArray13 = nArray14;
                    nArray14[1] = 1920;
                } else {
                    int[] nArray15 = new int[2];
                    nArray15[0] = 185;
                    nArray13 = nArray15;
                    nArray15[1] = 360;
                }
                return nArray13;
            }
            case CLEARLOGO: 
            case LOGO: {
                int[] nArray16;
                if (isWidth) {
                    int[] nArray17 = new int[1];
                    nArray16 = nArray17;
                    nArray17[0] = 800;
                } else {
                    int[] nArray18 = new int[1];
                    nArray16 = nArray18;
                    nArray18[0] = 310;
                }
                return nArray16;
            }
            case CLEARART: 
            case DISC: 
            case CHARACTERART: {
                int[] nArray19;
                if (isWidth) {
                    int[] nArray20 = new int[3];
                    nArray20[0] = 1000;
                    nArray20[1] = 1500;
                    nArray19 = nArray20;
                    nArray20[2] = 2000;
                } else {
                    int[] nArray21 = new int[3];
                    nArray21[0] = 1000;
                    nArray21[1] = 1500;
                    nArray19 = nArray21;
                    nArray21[2] = 2000;
                }
                return nArray19;
            }
        }
        return fallback;
    }

    private int getSuggestedMax(boolean isWidth) {
        int[] known = this.getWellKnownSizes(isWidth);
        int knownMax = 0;
        for (int v : known) {
            if (v <= knownMax) continue;
            knownMax = v;
        }
        if (knownMax >= 3840) {
            return 4000;
        }
        if (knownMax >= 3000) {
            return 3100;
        }
        return knownMax + 100;
    }

    static enum SortOrder {
        SCORE(TmmResourceBundle.getString("imagechooser.sortby.score")),
        SIZE(TmmResourceBundle.getString("imagechooser.sortby.size"));

        private final String displayName;

        private SortOrder(String displayName) {
            this.displayName = displayName;
        }

        public String toString() {
            return this.displayName;
        }
    }

    private static final class LockableViewPort
    extends JViewport {
        private boolean locked = false;

        private LockableViewPort() {
        }

        @Override
        public void setViewPosition(Point p) {
            if (this.locked) {
                return;
            }
            super.setViewPosition(p);
        }

        public boolean isLocked() {
            return this.locked;
        }

        public void setLocked(boolean locked) {
            this.locked = locked;
        }
    }

    private class CancelAction
    extends AbstractAction {
        public CancelAction() {
            this.putValue("Name", TmmResourceBundle.getString("Button.cancel"));
            this.putValue("ShortDescription", TmmResourceBundle.getString("Button.cancel"));
            this.putValue("SmallIcon", IconManager.CANCEL_INV);
            this.putValue("SwingLargeIconKey", IconManager.CANCEL_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ImageChooserDialog.this.task.cancel(true);
            ImageChooserDialog.this.setVisible(false);
        }
    }

    private class LocalFileChooseAction
    extends AbstractAction {
        public LocalFileChooseAction() {
            this.putValue("Name", TmmResourceBundle.getString("image.choose.file"));
            this.putValue("ShortDescription", TmmResourceBundle.getString("image.choose.file"));
            this.putValue("SmallIcon", IconManager.FILE_OPEN_INV);
            this.putValue("SwingLargeIconKey", IconManager.FILE_OPEN_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String path = StringUtils.isNotBlank((CharSequence)ImageChooserDialog.this.openFolderPath) ? ImageChooserDialog.this.openFolderPath : TmmProperties.getInstance().getProperty("imageChooser.path");
            Path file = TmmUIHelper.selectFile(TmmResourceBundle.getString("image.choose"), path, new FileNameExtensionFilter("Image files", "jpg", "jpeg", "png", "bmp", "gif", "tbn", "webp"));
            if (file != null && Utils.isRegularFile(file)) {
                ImageChooserDialog.this.imageLabel.clearImage();
                ImageChooserDialog.this.imageLabel.setImageUrl(file.toAbsolutePath().toUri().toString());
                ImageChooserDialog.this.task.cancel(true);
                TmmProperties.getInstance().putProperty("imageChooser.path", file.getParent().toString());
                ImageChooserDialog.this.setVisible(false);
            }
        }
    }

    private class OkAction
    extends AbstractAction {
        public OkAction() {
            this.putValue("Name", TmmResourceBundle.getString("Button.ok"));
            this.putValue("ShortDescription", TmmResourceBundle.getString("image.seteselected"));
            this.putValue("SmallIcon", IconManager.APPLY_INV);
            this.putValue("SwingLargeIconKey", IconManager.APPLY_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MediaArtwork artwork = null;
            MediaArtwork.ImageSizeAndUrl resolution = null;
            List<String> selectedExtraThumbs = this.getSelectedExtraThumbs();
            List<String> selectedExtraFanarts = this.getSelectedExtrafanarts();
            for (JToggleButton button : ImageChooserDialog.this.buttons) {
                JComboBox cb;
                Object clientProperty;
                if (!button.isSelected() || !((clientProperty = button.getClientProperty("MediaArtwork")) instanceof MediaArtwork)) continue;
                artwork = (MediaArtwork)clientProperty;
                clientProperty = button.getClientProperty("MediaArtworkSize");
                if (!(clientProperty instanceof JComboBox) || !((cb = (JComboBox)clientProperty).getSelectedItem() instanceof MediaArtwork.ImageSizeAndUrl)) break;
                resolution = (MediaArtwork.ImageSizeAndUrl)cb.getSelectedItem();
                break;
            }
            if (artwork == null && selectedExtraFanarts.isEmpty() && selectedExtraThumbs.isEmpty()) {
                JOptionPane.showMessageDialog(ImageChooserDialog.this, TmmResourceBundle.getString("image.noneselected"));
                return;
            }
            if (artwork != null) {
                ImageChooserDialog.this.imageLabel.clearImage();
                if (resolution != null) {
                    ImageChooserDialog.this.imageLabel.setImageUrl(resolution.getUrl());
                } else {
                    ImageChooserDialog.this.imageLabel.setImageUrl(artwork.getOriginalUrl());
                }
            }
            if (ImageChooserDialog.this.extraThumbs != null) {
                ImageChooserDialog.this.extraThumbs.clear();
                ImageChooserDialog.this.extraThumbs.addAll(selectedExtraThumbs);
            }
            if (ImageChooserDialog.this.extraFanarts != null) {
                ImageChooserDialog.this.extraFanarts.clear();
                ImageChooserDialog.this.extraFanarts.addAll(selectedExtraFanarts);
            }
            ImageChooserDialog.this.task.cancel(true);
            if (ImageChooserDialog.this.persistFilters) {
                ImageChooserDialog.this.persistFilters();
            }
            ImageChooserDialog.this.setVisible(false);
        }

        private List<String> getSelectedExtraThumbs() {
            ArrayList<String> selectedExtraThumbs = new ArrayList<String>();
            for (JToggleButton button : ImageChooserDialog.this.buttons) {
                JCheckBox chkbx;
                if (!(button.getClientProperty("MediaArtworkExtrathumb") instanceof JCheckBox) || !(button.getClientProperty("MediaArtwork") instanceof MediaArtwork) || !(button.getClientProperty("MediaArtworkSize") instanceof JComboBox) || !(chkbx = (JCheckBox)button.getClientProperty("MediaArtworkExtrathumb")).isSelected()) continue;
                MediaArtwork artwork = (MediaArtwork)button.getClientProperty("MediaArtwork");
                JComboBox cb = (JComboBox)button.getClientProperty("MediaArtworkSize");
                Object object = cb.getSelectedItem();
                if (object instanceof MediaArtwork.ImageSizeAndUrl) {
                    MediaArtwork.ImageSizeAndUrl size = (MediaArtwork.ImageSizeAndUrl)object;
                    selectedExtraThumbs.add(size.getUrl());
                    continue;
                }
                if (!(cb.getSelectedItem() instanceof String)) continue;
                selectedExtraThumbs.add(artwork.getOriginalUrl());
            }
            return selectedExtraThumbs;
        }

        private List<String> getSelectedExtrafanarts() {
            ArrayList<String> selectedExtrafanarts = new ArrayList<String>();
            for (JToggleButton button : ImageChooserDialog.this.buttons) {
                JCheckBox chkbx;
                if (!(button.getClientProperty("MediaArtworkExtrafanart") instanceof JCheckBox) || !(button.getClientProperty("MediaArtwork") instanceof MediaArtwork) || !(button.getClientProperty("MediaArtworkSize") instanceof JComboBox) || !(chkbx = (JCheckBox)button.getClientProperty("MediaArtworkExtrafanart")).isSelected()) continue;
                MediaArtwork artwork = (MediaArtwork)button.getClientProperty("MediaArtwork");
                JComboBox cb = (JComboBox)button.getClientProperty("MediaArtworkSize");
                Object object = cb.getSelectedItem();
                if (object instanceof MediaArtwork.ImageSizeAndUrl) {
                    MediaArtwork.ImageSizeAndUrl size = (MediaArtwork.ImageSizeAndUrl)object;
                    selectedExtrafanarts.add(size.getUrl());
                    continue;
                }
                if (!(cb.getSelectedItem() instanceof String)) continue;
                selectedExtrafanarts.add(artwork.getOriginalUrl());
            }
            return selectedExtrafanarts;
        }
    }

    private class DownloadTask
    extends SwingWorker<Void, DownloadChunk> {
        private final Map<String, Object> ids;
        private final List<MediaScraper> artworkScrapers;
        private final List<MediaArtwork> prescrapedArtwork;
        private boolean imagesFound = false;
        private ExecutorCompletionService<DownloadChunk> service;

        public DownloadTask(Map<String, Object> ids, List<MediaScraper> artworkScrapers, List<MediaArtwork> artwork) {
            this.ids = ids;
            this.artworkScrapers = artworkScrapers;
            this.prescrapedArtwork = artwork;
        }

        @Override
        public Void doInBackground() {
            if (this.ids.isEmpty()) {
                JOptionPane.showMessageDialog(ImageChooserDialog.this, TmmResourceBundle.getString("image.download.noid"));
                return null;
            }
            SwingUtilities.invokeLater(() -> ImageChooserDialog.this.startProgressBar(TmmResourceBundle.getString("image.download.progress")));
            if (ListUtils.isEmpty(this.artworkScrapers) && ListUtils.isEmpty(this.prescrapedArtwork)) {
                return null;
            }
            ThreadPoolExecutor pool = new ThreadPoolExecutor(5, 10, 1L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
            pool.allowCoreThreadTimeOut(true);
            this.service = new ExecutorCompletionService(pool);
            if (ListUtils.isEmpty(this.prescrapedArtwork)) {
                for (MediaScraper scraper : this.artworkScrapers) {
                    try {
                        IMediaArtworkProvider artworkProvider = (IMediaArtworkProvider)scraper.getMediaProvider();
                        ArtworkSearchAndScrapeOptions options = new ArtworkSearchAndScrapeOptions(ImageChooserDialog.this.mediaType);
                        if (ImageChooserDialog.this.mediaType == MediaType.MOVIE || ImageChooserDialog.this.mediaType == MediaType.MOVIE_SET) {
                            options.setLanguage(MovieModuleManager.getInstance().getSettings().getDefaultImageScraperLanguage());
                            options.setFanartSize(MovieModuleManager.getInstance().getSettings().getImageFanartSize());
                            options.setPosterSize(MovieModuleManager.getInstance().getSettings().getImagePosterSize());
                        } else {
                            if (ImageChooserDialog.this.mediaType != MediaType.TV_SHOW && ImageChooserDialog.this.mediaType != MediaType.TV_EPISODE) continue;
                            options.setLanguage(TvShowModuleManager.getInstance().getSettings().getScraperLanguage());
                            options.setFanartSize(TvShowModuleManager.getInstance().getSettings().getImageFanartSize());
                            options.setPosterSize(TvShowModuleManager.getInstance().getSettings().getImagePosterSize());
                            options.setThumbSize(TvShowModuleManager.getInstance().getSettings().getImageThumbSize());
                        }
                        switch (ImageChooserDialog.this.type) {
                            case POSTER: {
                                options.setArtworkType(MediaArtwork.MediaArtworkType.POSTER);
                                break;
                            }
                            case BACKGROUND: {
                                options.setArtworkType(MediaArtwork.MediaArtworkType.BACKGROUND);
                                break;
                            }
                            case BANNER: {
                                options.setArtworkType(MediaArtwork.MediaArtworkType.BANNER);
                                break;
                            }
                            case SEASON_POSTER: {
                                options.setArtworkType(MediaArtwork.MediaArtworkType.SEASON_POSTER);
                                break;
                            }
                            case SEASON_FANART: {
                                options.setArtworkType(MediaArtwork.MediaArtworkType.SEASON_FANART);
                                break;
                            }
                            case SEASON_BANNER: {
                                options.setArtworkType(MediaArtwork.MediaArtworkType.SEASON_BANNER);
                                break;
                            }
                            case SEASON_THUMB: {
                                options.setArtworkType(MediaArtwork.MediaArtworkType.SEASON_THUMB);
                                break;
                            }
                            case CLEARART: {
                                options.setArtworkType(MediaArtwork.MediaArtworkType.CLEARART);
                                break;
                            }
                            case DISC: {
                                options.setArtworkType(MediaArtwork.MediaArtworkType.DISC);
                                break;
                            }
                            case CLEARLOGO: 
                            case LOGO: {
                                options.setArtworkType(MediaArtwork.MediaArtworkType.CLEARLOGO);
                                break;
                            }
                            case CHARACTERART: {
                                options.setArtworkType(MediaArtwork.MediaArtworkType.CHARACTERART);
                                break;
                            }
                            case KEYART: {
                                options.setArtworkType(MediaArtwork.MediaArtworkType.KEYART);
                                break;
                            }
                            case THUMB: {
                                options.setArtworkType(MediaArtwork.MediaArtworkType.THUMB);
                            }
                        }
                        options.setIds(this.ids);
                        List<MediaArtwork> artwork = artworkProvider.getArtwork(options);
                        if (artwork == null || artwork.isEmpty()) continue;
                        this.processImages(artwork);
                        if (!this.isCancelled()) continue;
                        return null;
                    }
                    catch (MissingIdException e) {
                        LOGGER.debug("could not fetch artwork: {}", (Object[])e.getIds());
                    }
                    catch (ScrapeException e) {
                        LOGGER.error("getArtwork", (Throwable)e);
                    }
                    catch (Exception e) {
                        if (e instanceof InterruptedException || e instanceof InterruptedIOException) {
                            pool.getQueue().clear();
                            pool.shutdownNow();
                            return null;
                        }
                        LOGGER.error("Could not process artwork downloading - '{}'", (Object)e.getMessage());
                    }
                }
            } else {
                this.processImages(this.prescrapedArtwork);
            }
            pool.shutdown();
            while (true) {
                try {
                    while (true) {
                        Future<DownloadChunk> future;
                        if ((future = this.service.poll(1L, TimeUnit.SECONDS)) != null) {
                            DownloadChunk dc = future.get();
                            if (dc.imageData.length <= 0) continue;
                            this.publish(dc);
                            this.imagesFound = true;
                            continue;
                        }
                        if (pool.isTerminated()) break;
                    }
                }
                catch (InterruptedException e) {
                    return null;
                }
                catch (ExecutionException e) {
                    LOGGER.error("ThreadPool imageChooser: Error getting result! - '{}'", (Object)e.getMessage());
                    continue;
                }
                break;
            }
            return null;
        }

        private void processImages(List<MediaArtwork> artwork) {
            int season = MediaIdUtil.getIdAsIntOrDefault(this.ids, "tvShowSeason", -1);
            for (MediaArtwork art : artwork) {
                if (this.isCancelled()) {
                    return;
                }
                if (art.getPreviewUrl().isEmpty() || season > -1 && season != art.getSeason()) continue;
                Callable<DownloadChunk> callable = () -> {
                    Url url = new Url(art.getPreviewUrl());
                    DownloadChunk chunk = new DownloadChunk();
                    chunk.artwork = art;
                    try {
                        chunk.imageData = url.getBytesWithRetry(5);
                    }
                    catch (Exception e) {
                        LOGGER.debug("Could not add image '{}' - '{}'", (Object)art.getPreviewUrl(), (Object)e.getMessage());
                    }
                    return chunk;
                };
                this.service.submit(callable);
            }
        }

        @Override
        protected void process(List<DownloadChunk> chunks) {
            for (DownloadChunk chunk : chunks) {
                try {
                    ImageChooserDialog.this.addImage(chunk.imageData, chunk.artwork);
                }
                catch (Exception e) {
                    LOGGER.debug("Could not add image '{}' - '{}'", (Object)chunk.artwork.getPreviewUrl(), (Object)e.getMessage());
                }
            }
        }

        @Override
        public void done() {
            if (!this.imagesFound) {
                JLabel lblNothingFound = new JLabel(TmmResourceBundle.getString("image.download.nothingfound"));
                TmmFontHelper.changeFont((JComponent)lblNothingFound, 1.33);
                ImageChooserDialog.this.panelImages.add(lblNothingFound);
                ImageChooserDialog.this.panelImages.validate();
                ImageChooserDialog.this.panelImages.getParent().validate();
            }
            SwingUtilities.invokeLater(ImageChooserDialog.this::stopProgressBar);
        }
    }

    private record ImageSize(int width, int height) implements Comparable<ImageSize>
    {
        @Override
        public int compareTo(ImageSize o) {
            if (this.width == o.width && this.height == o.height) {
                return 0;
            }
            if (this.width < o.width || this.width == o.width && this.height < o.height) {
                return -1;
            }
            return 1;
        }

        @Override
        @NotNull
        public String toString() {
            return this.width + "x" + this.height;
        }
    }

    private static class NoneSelectedButtonGroup
    extends ButtonGroup {
        private NoneSelectedButtonGroup() {
        }

        @Override
        public void setSelected(ButtonModel model, boolean selected) {
            if (selected) {
                super.setSelected(model, selected);
            } else {
                this.clearSelection();
            }
        }
    }

    private static class DownloadChunk {
        private byte[] imageData;
        private MediaArtwork artwork;

        private DownloadChunk() {
        }
    }
}

