/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.components.tree;

import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.tinymediamanager.core.AbstractModelObject;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.ui.components.tree.ITmmTreeFilter;
import org.tinymediamanager.ui.components.tree.TmmTreeNode;

public abstract class TmmTreeDataProvider<E extends TmmTreeNode>
extends AbstractModelObject {
    public static final String NODE_INSERTED = "nodeInserted";
    public static final String NODE_CHANGED = "nodeChanged";
    public static final String NODE_REMOVED = "nodeRemoved";
    public static final String NODE_STRUCTURE_CHANGED = "nodeStructureChanged";
    protected final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    protected final Map<Object, TmmTreeNode> nodeMap = new HashMap<Object, TmmTreeNode>();
    protected final Set<ITmmTreeFilter<E>> treeFilters = new HashSet<ITmmTreeFilter<E>>();
    private boolean filtersActive = true;
    protected Comparator<E> treeComparator = null;

    public Set<ITmmTreeFilter<E>> getTreeFilters() {
        return this.treeFilters;
    }

    public void setTreeFilters(Set<ITmmTreeFilter<E>> treeFilters) {
        this.treeFilters.clear();
        if (treeFilters != null) {
            this.treeFilters.addAll(treeFilters);
        }
    }

    public boolean isFiltersActive() {
        return this.filtersActive;
    }

    public void setFiltersActive(boolean filtersActive) {
        this.filtersActive = filtersActive;
    }

    public Comparator<E> getTreeComparator() {
        return this.treeComparator;
    }

    public void setTreeComparator(Comparator<E> treeComparator) {
        this.treeComparator = treeComparator;
    }

    protected TmmTreeNode getNodeFromCache(MediaEntity mediaEntity) {
        return this.getNodeFromCache(mediaEntity.getDbId());
    }

    protected TmmTreeNode getNodeFromCache(Object obj) {
        this.readWriteLock.readLock().lock();
        try {
            TmmTreeNode tmmTreeNode = this.nodeMap.get(obj);
            return tmmTreeNode;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    protected void putNodeToCache(MediaEntity mediaEntity, TmmTreeNode node) {
        this.putNodeToCache(mediaEntity.getDbId(), node);
    }

    protected void putNodeToCache(Object obj, TmmTreeNode node) {
        this.readWriteLock.writeLock().lock();
        try {
            this.nodeMap.put(obj, node);
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    protected TmmTreeNode removeNodeFromCache(MediaEntity mediaEntity) {
        return this.removeNodeFromCache(mediaEntity.getDbId());
    }

    protected TmmTreeNode removeNodeFromCache(Object obj) {
        this.readWriteLock.writeLock().lock();
        try {
            TmmTreeNode tmmTreeNode = this.nodeMap.remove(obj);
            return tmmTreeNode;
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    public abstract E getRoot();

    public abstract E getParent(E var1);

    public abstract List<E> getChildren(E var1);

    public abstract boolean isLeaf(E var1);
}

