/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.components.panel;

import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import net.miginfocom.swing.MigLayout;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.components.button.FlatButton;
import org.tinymediamanager.ui.components.label.TmmLabel;

public class CollapsiblePanel
extends JPanel {
    private final JPanel panelTop;
    private final JButton btnToggle;
    private final JComponent content;
    private boolean isCollapsed;

    public CollapsiblePanel(JComponent content, String title) {
        this(content, title, true);
    }

    public CollapsiblePanel(JComponent content, JLabel lblTitle) {
        this(content, lblTitle, true);
    }

    public CollapsiblePanel(JComponent content, String title, boolean collapseButtonAtLeft) {
        this(content, title, collapseButtonAtLeft, false);
    }

    public CollapsiblePanel(JComponent content, JLabel lblTitle, boolean collapseButtonAtLeft) {
        this(content, lblTitle, collapseButtonAtLeft, false);
    }

    public CollapsiblePanel(JComponent content, String title, boolean collapseButtonAtLeft, boolean isCollapsed) {
        this(content, new TmmLabel(title), collapseButtonAtLeft, isCollapsed);
    }

    public CollapsiblePanel(JComponent content, JLabel lblTitle, boolean collapseButtonAtLeft, boolean isCollapsed) {
        super((LayoutManager)new MigLayout("insets 0, fillx", "[grow, fill]", "[][]"));
        this.content = content;
        this.setBackground(content.getBackground());
        this.panelTop = new JPanel((LayoutManager)new MigLayout("insets 0", "[grow][]", "[]"));
        this.btnToggle = new FlatButton(IconManager.COLLAPSED);
        if (collapseButtonAtLeft) {
            this.panelTop.add((Component)this.btnToggle, "cell 0 0, aligny center");
        } else {
            this.panelTop.add((Component)this.btnToggle, "cell 1 0, aligny center");
        }
        if (lblTitle != null) {
            this.panelTop.add((Component)lblTitle, "cell 0 0, wmin 0");
        }
        this.panelTop.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, UIManager.getColor("Label.foreground")));
        this.add((Component)this.panelTop, "cell 0 0, growx");
        this.btnToggle.addActionListener(e -> this.setCollapsed(!this.isCollapsed));
        this.setCollapsed(isCollapsed);
    }

    public void addExtraTitleComponent(JComponent component) {
        if (component != null) {
            this.panelTop.add((Component)component, "cell 0 0");
        }
    }

    protected void setCollapsed(boolean collapse) {
        if (collapse) {
            this.remove(this.content);
        } else {
            this.add((Component)this.content, "cell 0 1, grow, pushx, wmin 0");
        }
        this.isCollapsed = collapse;
        Icon icon = this.getIcon();
        if (icon != null) {
            this.btnToggle.setIcon(icon);
        }
        this.revalidate();
        this.repaint();
    }

    private Icon getIcon() {
        if (this.isCollapsed) {
            return IconManager.EXPANDED;
        }
        return IconManager.COLLAPSED;
    }

    public boolean isCollapsed() {
        return this.isCollapsed;
    }

    public void expand() {
        if (this.isCollapsed) {
            this.setCollapsed(false);
        }
    }

    public void collapse() {
        if (!this.isCollapsed) {
            this.setCollapsed(true);
        }
    }
}

