/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.opensubtitles_com;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.LongBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.tinymediamanager.core.FeatureNotEnabledException;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.scraper.MediaProviderInfo;
import org.tinymediamanager.scraper.SubtitleSearchAndScrapeOptions;
import org.tinymediamanager.scraper.SubtitleSearchResult;
import org.tinymediamanager.scraper.entities.MediaLanguages;
import org.tinymediamanager.scraper.exceptions.HttpException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.interfaces.IMediaProvider;
import org.tinymediamanager.scraper.opensubtitles_com.OpenSubtitlesComController;
import org.tinymediamanager.scraper.opensubtitles_com.model.DownloadRequest;
import org.tinymediamanager.scraper.opensubtitles_com.model.DownloadResponse;
import org.tinymediamanager.scraper.opensubtitles_com.model.SearchResponse;
import org.tinymediamanager.scraper.opensubtitles_com.model.SearchResult;
import org.tinymediamanager.scraper.opensubtitles_com.model.SubtitleFile;
import org.tinymediamanager.scraper.util.CacheMap;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.scraper.util.MediaIdUtil;
import org.tinymediamanager.scraper.util.MetadataUtil;
import retrofit2.Response;

abstract class OpenSubtitlesComSubtitleProvider
implements IMediaProvider {
    public static final String ID = "opensubtitles2";
    private static final int HASH_CHUNK_SIZE = 65536;
    private static final CacheMap<DownloadRequest, DownloadResponse> DOWNLOAD_CACHE = new CacheMap(21600L, 60L);
    private final MediaProviderInfo providerInfo = this.createMediaProviderInfo();
    protected OpenSubtitlesComController controller = null;

    protected OpenSubtitlesComSubtitleProvider() {
    }

    protected abstract String getSubId();

    protected abstract Logger getLogger();

    private MediaProviderInfo createMediaProviderInfo() {
        MediaProviderInfo info = new MediaProviderInfo(ID, this.getSubId(), "OpenSubtitles.com", "<html><h3>OpenSubtitles.com</h3><br />A subtitle scraper for OpenSubtitles.com</html>", OpenSubtitlesComSubtitleProvider.class.getResource("/org/tinymediamanager/scraper/opensubtitles_com.svg"));
        info.getConfig().addText("username", "scraper.opensubtitles.username.nomail", "");
        info.getConfig().addText("password", "", true);
        info.getConfig().addBoolean("trustedSources", false);
        info.getConfig().addBoolean("aiTranslated", false);
        info.getConfig().addBoolean("machineTranslated", false);
        info.getConfig().addSelect("subtitleFormat", new String[]{"srt", "sub"}, "srt");
        info.getConfig().load();
        return info;
    }

    @Override
    public MediaProviderInfo getProviderInfo() {
        return this.providerInfo;
    }

    @Override
    public boolean isActive() {
        return this.isFeatureEnabled() && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.getUserName(), this.getPassword()}) && this.isApiKeyAvailable(null);
    }

    private synchronized void initAPI() throws ScrapeException {
        if (this.controller == null) {
            if (!this.isActive()) {
                throw new ScrapeException(new FeatureNotEnabledException(this));
            }
            this.controller = new OpenSubtitlesComController();
        }
        try {
            this.controller.setApiKey(this.getApiKey());
            this.controller.setUsername(this.getUserName());
            this.controller.setPassword(this.getPassword());
            this.controller.authenticate();
        }
        catch (Exception e) {
            throw new ScrapeException(e);
        }
    }

    private String getUserName() {
        return this.providerInfo.getConfig().getValue("username");
    }

    private String getPassword() {
        return this.providerInfo.getConfig().getValue("password");
    }

    public List<SubtitleSearchResult> search(SubtitleSearchAndScrapeOptions options) throws ScrapeException {
        this.initAPI();
        ArrayList<SubtitleSearchResult> results = new ArrayList<SubtitleSearchResult>();
        TreeMap<String, String> query = new TreeMap<String, String>();
        MediaFile mediaFile = options.getMediaFile();
        if (mediaFile != null && mediaFile.exists() && mediaFile.getFilesize() > 0L) {
            File file = mediaFile.getFile().toFile();
            long fileSize = file.length();
            String hash = this.computeOpenSubtitlesHash(file);
            query.put("moviehash", hash);
            this.getLogger().debug("moviebytesize: {}; moviehash: {}", (Object)fileSize, (Object)hash);
        }
        if (MediaIdUtil.isValidImdbId(options.getImdbId())) {
            this.getLogger().debug("searching subtitle for imdb id '{}'", (Object)options.getImdbId());
            query.put("imdb_id", String.valueOf(OpenSubtitlesComSubtitleProvider.formatImdbId(options.getImdbId())));
        } else if (options.getTmdbId() > 0) {
            this.getLogger().debug("searching subtitle for tmdb id '{}'", (Object)options.getTmdbId());
            query.put("tmdb_id", String.valueOf(options.getTmdbId()));
        } else if (options.getIds().get("tvShowIds") instanceof Map) {
            Map tvShowIds = (Map)options.getIds().get("tvShowIds");
            String tvShowImdbId = String.valueOf(tvShowIds.get("imdb"));
            int tvShowTmdbId = MetadataUtil.parseInt(String.valueOf(tvShowIds.get("tmdb")), 0);
            if (MediaIdUtil.isValidImdbId(tvShowImdbId)) {
                this.getLogger().debug("searching subtitle for TV show imdb id '{}'", (Object)tvShowImdbId);
                query.put("parent_imdb_id", String.valueOf(OpenSubtitlesComSubtitleProvider.formatImdbId(tvShowImdbId)));
            } else if (tvShowTmdbId > 0) {
                this.getLogger().debug("searching subtitle for TV show tmdb id '{}'", (Object)tvShowTmdbId);
                query.put("parent_tmdb_id", String.valueOf(tvShowTmdbId));
            }
            if (options.getEpisode() > -1) {
                query.put("episode_number", String.valueOf(options.getEpisode()));
            }
            if (options.getSeason() > -1) {
                query.put("season_number", String.valueOf(options.getSeason()));
            }
        }
        if (query.isEmpty()) {
            this.getLogger().debug("nothing to search for");
            return Collections.emptyList();
        }
        String language = switch (options.getLanguage()) {
            case MediaLanguages.pt -> "pt-PT";
            case MediaLanguages.pt_BR -> "pt-BR";
            case MediaLanguages.zh_CN -> "zh-CN";
            case MediaLanguages.zh_TW -> "zh-TW";
            default -> options.getLanguage().getLanguage().toLowerCase(Locale.ROOT);
        };
        query.put("languages", language);
        if (this.getProviderInfo().getConfig().getValueAsBool("aiTranslated")) {
            query.put("ai_translated", "include");
        } else {
            query.put("ai_translated", "exclude");
        }
        if (this.getProviderInfo().getConfig().getValueAsBool("trustedSources")) {
            query.put("trusted_sources", "only");
        } else {
            query.put("trusted_sources", "include");
        }
        if (this.getProviderInfo().getConfig().getValueAsBool("machineTranslated")) {
            query.put("machine_translated", "include");
        } else {
            query.put("machine_translated", "exclude");
        }
        this.getLogger().debug("searching subtitle");
        try {
            Response response = this.controller.getService().search(query).execute();
            if (response.isSuccessful() && response.body() != null) {
                for (SearchResult result : ListUtils.nullSafe(((SearchResponse)response.body()).data)) {
                    if (result.attributes == null || ListUtils.isEmpty(result.attributes.files) || !language.equals(result.attributes.language)) continue;
                    SubtitleSearchResult subtitleSearchResult = this.prepareSearchResult(result, options);
                    if (subtitleSearchResult == null) {
                        this.getLogger().debug("Could not detect any valid subtitle file to download");
                        continue;
                    }
                    results.add(subtitleSearchResult);
                }
            }
            this.getLogger().debug("found {} results", (Object)results.size());
        }
        catch (Exception e) {
            this.getLogger().error("Could not search subtitle - {}", (Object)e.getMessage());
        }
        Collections.sort(results);
        Collections.reverse(results);
        return results;
    }

    private SubtitleSearchResult prepareSearchResult(SearchResult result, SubtitleSearchAndScrapeOptions options) {
        MediaFile mediaFile = options.getMediaFile();
        SubtitleSearchResult subtitleSearchResult = new SubtitleSearchResult(this.providerInfo.getId());
        subtitleSearchResult.setId(result.id);
        subtitleSearchResult.setLanguage(result.attributes.language);
        subtitleSearchResult.setHearingImpaired(result.attributes.hearingImpaired);
        subtitleSearchResult.setAiTranslated(result.attributes.aiTranslated);
        subtitleSearchResult.setMachineTranslated(result.attributes.machineTranslated);
        if (result.attributes.featureDetails != null) {
            subtitleSearchResult.setTitle(result.attributes.featureDetails.title);
        }
        subtitleSearchResult.setStackCount(result.attributes.files.size());
        subtitleSearchResult.setReleaseName(result.attributes.release);
        subtitleSearchResult.setRating(result.attributes.ratings);
        SubtitleFile subtitleFile = null;
        if (result.attributes.files.size() == 1) {
            subtitleFile = result.attributes.files.get(0);
        } else if (mediaFile != null) {
            for (SubtitleFile sf : result.attributes.files) {
                if (sf.cdNumber != options.getMediaFile().getStacking()) continue;
                subtitleFile = sf;
                break;
            }
        }
        if (subtitleFile == null) {
            return null;
        }
        float score = 1.0f;
        if (!this.compareIds(result, options)) {
            score = (float)((double)score - 0.5);
        }
        if (!subtitleFile.moviehashMatch) {
            score = (float)((double)score - 0.1);
            if (mediaFile != null && mediaFile.getFrameRate() != (double)result.attributes.fps) {
                score = (float)((double)score - 0.1);
            }
        }
        subtitleSearchResult.setScore(score);
        SubtitleFile finalSubtitleFile = subtitleFile;
        subtitleSearchResult.setUrl(() -> this.download(finalSubtitleFile, options.getMediaFile().getFrameRate()));
        return subtitleSearchResult;
    }

    private boolean compareIds(SearchResult result, SubtitleSearchAndScrapeOptions options) {
        if (result.attributes.featureDetails == null) {
            return false;
        }
        int imdbIdFromResult = result.attributes.featureDetails.imdbId;
        int imdbIdFromOptions = MetadataUtil.unboxInteger(OpenSubtitlesComSubtitleProvider.formatImdbId(options.getImdbId()), 0);
        if (imdbIdFromResult > 0 && imdbIdFromOptions > 0 && imdbIdFromResult != imdbIdFromOptions) {
            return false;
        }
        int tmdbIdFromResult = result.attributes.featureDetails.tmdbId;
        int tmdbIdFromOptions = options.getTmdbId();
        if (tmdbIdFromResult > 0 && tmdbIdFromOptions > 0 && tmdbIdFromResult != tmdbIdFromOptions) {
            return false;
        }
        if (options.getIds().get("tvShowIds") instanceof Map) {
            Map tvShowIds = (Map)options.getIds().get("tvShowIds");
            int parentImdbIdFromResult = result.attributes.featureDetails.parentImdbId;
            int parentIdFromOptions = MetadataUtil.unboxInteger(OpenSubtitlesComSubtitleProvider.formatImdbId(String.valueOf(tvShowIds.get("imdb"))), 0);
            if (parentImdbIdFromResult > 0 && parentIdFromOptions > 0 && parentImdbIdFromResult != parentIdFromOptions) {
                return false;
            }
            int parentTmdbIdFromResult = result.attributes.featureDetails.parentTmdbId;
            int parentTmdbIdFromOptions = MetadataUtil.parseInt(String.valueOf(tvShowIds.get("tmdb")), 0);
            if (parentTmdbIdFromResult > 0 && parentTmdbIdFromOptions > 0 && parentTmdbIdFromResult != parentTmdbIdFromOptions) {
                return false;
            }
            int seasonFromResult = result.attributes.featureDetails.seasonNumber;
            int seasonFromOptions = options.getSeason();
            if (seasonFromResult > -1 && seasonFromOptions > -1 && seasonFromResult != seasonFromOptions) {
                return false;
            }
            int episodeFromResult = result.attributes.featureDetails.episodeNumber;
            int episodeFromOptions = options.getEpisode();
            if (episodeFromResult > -1 && episodeFromOptions > -1 && episodeFromResult != episodeFromOptions) {
                return false;
            }
        }
        return true;
    }

    private String download(SubtitleFile file, double frameRate) throws ScrapeException {
        DownloadResponse downloadResponse;
        DownloadRequest request = new DownloadRequest();
        request.file_id = file.fileId;
        request.sub_format = this.getProviderInfo().getConfig().getValue("subtitleFormat");
        if (frameRate != 0.0) {
            request.in_fps = file.fps;
            request.out_fps = frameRate;
        }
        if ((downloadResponse = DOWNLOAD_CACHE.get(request)) != null) {
            return downloadResponse.link;
        }
        try {
            this.initAPI();
            Response response = this.controller.getService().download(request).execute();
            if (response.isSuccessful() && response.body() != null) {
                DOWNLOAD_CACHE.put(request, (DownloadResponse)response.body());
                return ((DownloadResponse)response.body()).link;
            }
            if (response.code() == 406 && response.errorBody() != null) {
                Gson gson = new Gson();
                Type type = new TypeToken<DownloadResponse>(){}.getType();
                DownloadResponse errorResponse = (DownloadResponse)gson.fromJson(response.errorBody().charStream(), type);
                throw new HttpException(response.code(), errorResponse.message);
            }
            throw new HttpException(response.code(), response.message());
        }
        catch (Exception e) {
            this.getLogger().error("Could not retrieve download url - '{}'", (Object)e.getMessage());
            throw new ScrapeException(e);
        }
    }

    static Integer formatImdbId(String imdbId) {
        if (!MediaIdUtil.isValidImdbId(imdbId)) {
            return null;
        }
        try {
            return Integer.parseInt(imdbId.replace("tt", ""));
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private String computeOpenSubtitlesHash(File file) {
        long size = file.length();
        long chunkSizeForFile = Math.min(65536L, size);
        try (FileInputStream is = new FileInputStream(file);){
            String string;
            block13: {
                FileChannel fileChannel = is.getChannel();
                try {
                    ByteBuffer buf = ByteBuffer.allocate((int)chunkSizeForFile);
                    fileChannel.read(buf);
                    long head = OpenSubtitlesComSubtitleProvider.computeOpenSubtitlesHashForChunk(buf);
                    fileChannel.read(buf, Math.max(size - 65536L, 0L));
                    long tail = OpenSubtitlesComSubtitleProvider.computeOpenSubtitlesHashForChunk(buf);
                    string = String.format("%016x", size + head + tail).toLowerCase(Locale.ROOT);
                    if (fileChannel == null) break block13;
                }
                catch (Throwable throwable) {
                    if (fileChannel != null) {
                        try {
                            fileChannel.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                fileChannel.close();
            }
            return string;
        }
        catch (Exception e) {
            this.getLogger().error("Error computing OpenSubtitles hash", (Throwable)e);
            return "";
        }
    }

    private static long computeOpenSubtitlesHashForChunk(ByteBuffer buffer) {
        buffer.rewind();
        LongBuffer longBuffer = buffer.order(ByteOrder.LITTLE_ENDIAN).asLongBuffer();
        long hash = 0L;
        while (longBuffer.hasRemaining()) {
            hash += longBuffer.get();
        }
        return hash;
    }
}

