/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.library.bluray.clipinf;

import jakarta.xml.bind.annotation.adapters.XmlAdapter;

public class HexStringByteAdapter
extends XmlAdapter<String, Byte> {
    public Byte unmarshal(String string) throws Exception {
        if (string.startsWith("0x") || string.startsWith("0X")) {
            return (byte)Integer.parseInt(string.substring(2), 16);
        }
        return (byte)Short.parseShort(string);
    }

    public String marshal(Byte by) throws Exception {
        String string = Integer.toHexString(by.byteValue());
        int n = string.length();
        if (n > 2) {
            string = string.substring(n - 2, n);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("0x");
        int n2 = 2 - string.length();
        for (int i = 0; i < n2; ++i) {
            stringBuilder.append('0');
        }
        stringBuilder.append(string);
        return stringBuilder.toString();
    }
}

