/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.mediainfo;

import java.util.Locale;

public enum MediaInfo3D {
    MONO(""),
    LEFT_RIGHT("Side by Side (left eye first)"),
    RIGHT_LEFT("Side by Side (right eye first)"),
    BOTTOM_TOP("Top-Bottom (right eye first)"),
    TOP_BOTTOM("Top-Bottom (left eye first)"),
    CHECKERBOARD_RL("Checkboard (right eye first)"),
    CHECKERBOARD_LR("Checkboard (left eye first)"),
    ROW_INTERLEAVED_RL("Row Interleaved (right eye first)"),
    ROW_INTERLEAVED_LR("Row Interleaved (left eye first)"),
    COL_INTERLEAVED_RL("Column Interleaved (right eye first)"),
    COL_INTERLEAVED_LR("Column Interleaved (left eye first)"),
    ANAGLYPH_CYAN_RED("Anaglyph (cyan/red)"),
    ANAGLYPH_GREEN_MAGENTA("Anaglyph (green/magenta)"),
    ANAGLYPH_YELLOW_BLUE("Anaglyph (yellow/blue)"),
    BLOCK_LR("Both Eyes laced in one block (left eye first)"),
    BLOCK_RL("Both Eyes laced in one block (right eye first)");

    private final String desc;

    private MediaInfo3D(String desc) {
        this.desc = desc;
    }

    public String toString() {
        return this.desc;
    }

    public String getId() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public static MediaInfo3D get3DFrom(String value) {
        if (value == null || value.isBlank()) {
            return MONO;
        }
        for (MediaInfo3D val : MediaInfo3D.values()) {
            if (val.toString().equalsIgnoreCase(value)) {
                return val;
            }
            if (!val.name().equalsIgnoreCase(value)) continue;
            return val;
        }
        return MONO;
    }
}

