/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.filters;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaGenres;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.tvshows.filters.AbstractCheckComboBoxTvShowUIFilter;

public class TvShowGenreFilter
extends AbstractCheckComboBoxTvShowUIFilter<MediaGenres> {
    public TvShowGenreFilter() {
        this.checkComboBox.enableFilter((s, s2) -> s.toString().toLowerCase(Locale.ROOT).contains(s2.toLowerCase(Locale.ROOT)));
        this.buildAndInstallMediaGenres();
        MediaGenres.addListener(evt -> SwingUtilities.invokeLater(this::buildAndInstallMediaGenres));
    }

    @Override
    public String getId() {
        return "tvShowGenre";
    }

    @Override
    protected boolean accept(TvShow tvShow, List<TvShowEpisode> episodes, boolean invert) {
        List selectedItems = this.checkComboBox.getSelectedItems();
        if (!invert && selectedItems.isEmpty() && tvShow.getGenres().isEmpty()) {
            return true;
        }
        if (invert && selectedItems.isEmpty() && !tvShow.getGenres().isEmpty()) {
            return true;
        }
        return invert == Collections.disjoint(selectedItems, tvShow.getGenres());
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(TmmResourceBundle.getString("metatag.genre"));
    }

    private void buildAndInstallMediaGenres() {
        this.setValues(MediaGenres.values());
    }

    @Override
    protected String parseTypeToString(MediaGenres type) throws Exception {
        return type.name();
    }

    @Override
    protected MediaGenres parseStringToType(String string) throws Exception {
        return MediaGenres.getGenre(string);
    }
}

