/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.filters;

import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.bus.EventBus;
import org.tinymediamanager.core.entities.MediaGenres;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.movies.filters.AbstractCheckComboBoxMovieUIFilter;

public class MovieGenreFilter
extends AbstractCheckComboBoxMovieUIFilter<MediaGenres> {
    private final Comparator<MediaGenres> comparator;
    private final MovieList movieList;
    private final Set<MediaGenres> oldGenres;

    public MovieGenreFilter() {
        this.checkComboBox.enableFilter((s, s2) -> s.toString().toLowerCase(Locale.ROOT).contains(s2.toLowerCase(Locale.ROOT)));
        this.movieList = MovieModuleManager.getInstance().getMovieList();
        this.comparator = new MediaGenres.MediaGenresComparator();
        this.oldGenres = new HashSet<MediaGenres>();
        this.buildAndInstallMediaGenres();
        EventBus.registerListener(EventBus.TOPIC_MOVIES, event -> {
            if (event.sender() instanceof Movie && event.eventType().equals("save")) {
                this.buildAndInstallMediaGenres();
            }
        });
    }

    @Override
    public String getId() {
        return "movieGenre";
    }

    @Override
    public boolean accept(Movie movie) {
        List selectedItems = this.checkComboBox.getSelectedItems();
        if (selectedItems.isEmpty() && movie.getGenres().isEmpty()) {
            return true;
        }
        for (MediaGenres genre : movie.getGenres()) {
            if (!selectedItems.contains(genre)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(TmmResourceBundle.getString("movieextendedsearch.genre"));
    }

    private void buildAndInstallMediaGenres() {
        boolean dirty = false;
        HashSet<MediaGenres> genres = new HashSet<MediaGenres>(this.movieList.getUsedGenres());
        if (this.oldGenres.size() != genres.size()) {
            dirty = true;
        } else if (!this.oldGenres.containsAll(genres) || !genres.containsAll(this.oldGenres)) {
            dirty = true;
        }
        if (dirty) {
            this.oldGenres.clear();
            this.oldGenres.addAll(genres);
            SwingUtilities.invokeLater(() -> this.setValues(ListUtils.asSortedList(genres, this.comparator)));
        }
    }

    @Override
    protected String parseTypeToString(MediaGenres type) throws Exception {
        return type.name();
    }

    @Override
    protected MediaGenres parseStringToType(String string) throws Exception {
        return MediaGenres.getGenre(string);
    }
}

