/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.filters;

import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.bus.EventBus;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.components.table.TmmTableFormat;
import org.tinymediamanager.ui.movies.filters.AbstractCheckComboBoxMovieUIFilter;

public class MovieTagFilter
extends AbstractCheckComboBoxMovieUIFilter<String> {
    private final Comparator<String> comparator;
    private final MovieList movieList;
    private final Set<String> oldTags;

    public MovieTagFilter() {
        this.checkComboBox.enableFilter((s, s2) -> s.toLowerCase(Locale.ROOT).contains(s2.toLowerCase(Locale.ROOT)));
        this.comparator = new TmmTableFormat.StringComparator();
        this.movieList = MovieModuleManager.getInstance().getMovieList();
        this.oldTags = new HashSet<String>();
        this.buildAndInstallTagsArray();
        EventBus.registerListener(EventBus.TOPIC_MOVIES, event -> {
            if (event.sender() instanceof Movie && event.eventType().equals("save")) {
                this.buildAndInstallTagsArray();
            }
        });
    }

    @Override
    public String getId() {
        return "movieTag";
    }

    @Override
    public boolean accept(Movie movie) {
        List tags = this.checkComboBox.getSelectedItems();
        if (tags.isEmpty() && movie.getTags().isEmpty()) {
            return true;
        }
        for (String tag : movie.getTags()) {
            if (!tags.contains(tag)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(TmmResourceBundle.getString("movieextendedsearch.tag"));
    }

    private void buildAndInstallTagsArray() {
        boolean dirty = false;
        HashSet<String> tags = new HashSet<String>(this.movieList.getTagsInMovies());
        if (this.oldTags.size() != tags.size()) {
            dirty = true;
        } else if (!this.oldTags.containsAll(tags) || !tags.containsAll(this.oldTags)) {
            dirty = true;
        }
        if (dirty) {
            this.oldTags.clear();
            this.oldTags.addAll(tags);
            SwingUtilities.invokeLater(() -> this.setValues(ListUtils.asSortedList(tags, this.comparator)));
        }
    }

    @Override
    protected String parseTypeToString(String type) throws Exception {
        return type;
    }

    @Override
    protected String parseStringToType(String string) throws Exception {
        return string;
    }
}

