/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.loopfs.udf.descriptor;

import com.github.stephenc.javaisotools.loopfs.udf.UDFFileSystem;
import com.github.stephenc.javaisotools.loopfs.udf.UDFUtil;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.FileEntryDescriptor;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.FileIdentifierDescriptor;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.element.ExtentAD;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.element.ICBTag;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.element.LongAD;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.element.RegId;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.element.Timestamp;
import com.github.stephenc.javaisotools.loopfs.udf.exceptions.InvalidDescriptor;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;

public class ExtendedFileEntryDescriptor
extends FileEntryDescriptor {
    public BigInteger objectSize;
    public Timestamp creatiDT;
    public LongAD streamDirICB;
    public final int MINIMUM_LENGTH = 512;

    public ExtendedFileEntryDescriptor() {
    }

    public ExtendedFileEntryDescriptor(byte[] byArray) throws InvalidDescriptor {
        this.deserialize(byArray);
        this.verifyTagIdentifier();
    }

    @Override
    public int getExpectedTagIdentifier() {
        return 266;
    }

    @Override
    public void deserialize(byte[] byArray) throws InvalidDescriptor {
        if (byArray.length < 512) {
            throw new InvalidDescriptor("File entry descriptor too short");
        }
        this.deserializeTag(byArray);
        this.icbTag = new ICBTag(this.getBytes(byArray, 20));
        this.uid = this.getUInt32(byArray);
        this.gid = this.getUInt32(byArray);
        this.permissions = this.getUInt32(byArray);
        this.fileLinks = this.getUInt16(byArray);
        this.recordFormat = this.getUInt8(byArray);
        this.recordDisplayAttrs = this.getUInt8(byArray);
        this.recordLength = this.getUInt32(byArray);
        this.infoLength = this.getUInt64(byArray);
        this.objectSize = this.getUInt64(byArray);
        this.lbRecorded = this.getUInt64(byArray);
        this.accessDT = new Timestamp(this.getBytes(byArray, 12));
        this.modifiDT = new Timestamp(this.getBytes(byArray, 12));
        this.creatiDT = new Timestamp(this.getBytes(byArray, 12));
        this.attributeDT = new Timestamp(this.getBytes(byArray, 12));
        this.checkpoint = this.getUInt32(byArray);
        this.getUInt32(byArray);
        this.extAttrICB = new LongAD(this.getBytes(byArray, 16));
        this.streamDirICB = new LongAD(this.getBytes(byArray, 16));
        this.implIdentifier = new RegId(this.getBytes(byArray, 32));
        this.uniqueId = this.getUInt64(byArray);
        this.extAttrLength = this.getUInt32(byArray);
        this.allocDescriptorLength = this.getUInt32(byArray);
        Integer n = 2048 - this.currentPos;
        if (this.extAttrLength > (long)n.intValue()) {
            throw new InvalidDescriptor("Extended attributes too long");
        }
        this.extendedAttributes = this.getBytes(byArray, this.extAttrLength.intValue());
        Integer n2 = 2048 - this.currentPos;
        if (this.allocDescriptorLength > (long)n2.intValue()) {
            throw new InvalidDescriptor("Allocation descriptors too long");
        }
        int n3 = 0;
        this.allocDescriptors = new ArrayList();
        while ((long)n3 < this.allocDescriptorLength) {
            ExtentAD extentAD = new ExtentAD(this.getBytes(byArray, 8));
            n3 += 8;
            if (extentAD.length <= 0L) continue;
            this.allocDescriptors.add(extentAD);
        }
    }

    @Override
    public void loadChildren(UDFFileSystem uDFFileSystem) throws IOException {
        int n = 2048;
        block2: for (ExtentAD extentAD : this.allocDescriptors) {
            int n2 = extentAD.length.intValue();
            if (n2 == 0) continue;
            byte[] byArray = new byte[n2];
            long l = uDFFileSystem.getFSDloc() + extentAD.location;
            int n3 = uDFFileSystem.readBytes(l * (long)n, byArray, 0, n2);
            if ((long)n3 != extentAD.length) {
                throw new IOException("Failed to read " + extentAD.length + " bytes at the beginning of sector " + l + ". Actually read " + n3 + " bytes.");
            }
            int n4 = 0;
            byte[] byArray2 = byArray;
            boolean bl = true;
            boolean bl2 = false;
            while (true) {
                FileIdentifierDescriptor fileIdentifierDescriptor;
                try {
                    fileIdentifierDescriptor = new FileIdentifierDescriptor(byArray2);
                }
                catch (InvalidDescriptor invalidDescriptor) {
                    throw new IOException(invalidDescriptor.getMessage());
                }
                if ((n4 += fileIdentifierDescriptor.getConsumption().intValue()) >= n2) {
                    bl2 = true;
                } else {
                    byArray2 = UDFUtil.getRemainingBytes(byArray, n4);
                }
                if (bl) {
                    bl = false;
                    continue;
                }
                this.fids.add(fileIdentifierDescriptor);
                if (bl2 || byArray2.length <= 40 || UDFUtil.getUInt16(byArray2, 0) != 257) continue block2;
            }
        }
    }
}

