/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.loopfs.iso9660.rrip;

import com.github.stephenc.javaisotools.loopfs.iso9660.Util;
import com.github.stephenc.javaisotools.loopfs.iso9660.susp.exceptions.InvalidSuspField;
import java.util.ArrayList;
import java.util.List;

class RripSLComponent {
    private int flags = 0;
    private int length = 0;
    private String text = null;

    public RripSLComponent(int n, int n2, String string) {
        this.flags = n;
        this.length = n2;
        this.text = string;
    }

    public boolean isNormalLink() {
        return (this.flags & 0xFFFFFFFE) == 0;
    }

    public boolean linksToCurrentDir() {
        return (this.flags & 0xFFFFFFFE) == 2;
    }

    public boolean linksToParentDir() {
        return (this.flags & 0xFFFFFFFE) == 4;
    }

    public boolean linksToRootDir() {
        return (this.flags & 0xFFFFFFFE) == 8;
    }

    public int getLength() {
        return this.length;
    }

    public String getText() {
        return this.text;
    }

    public static List<RripSLComponent> fromComponentArea(byte[] byArray) throws InvalidSuspField {
        int n = 0;
        ArrayList<RripSLComponent> arrayList = new ArrayList<RripSLComponent>();
        byte[] byArray2 = byArray;
        while (byArray.length - n >= 2) {
            RripSLComponent rripSLComponent = RripSLComponent.fromByte(byArray2);
            arrayList.add(rripSLComponent);
            byArray2 = Util.getBytes(byArray, n += rripSLComponent.length + 2, byArray.length - n);
        }
        if (byArray.length - n != 0) {
            throw new InvalidSuspField("SLComponent field has redundant bytes");
        }
        return arrayList;
    }

    public static RripSLComponent fromByte(byte[] byArray) throws InvalidSuspField {
        int n = Util.getUInt8(byArray, 1);
        int n2 = Util.getUInt8(byArray, 2);
        String string = Util.getString(byArray, 3, n2);
        return new RripSLComponent(n, n2, string);
    }
}

