/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.support.model.item;

import java.net.URI;
import java.util.Arrays;
import java.util.List;
import org.jupnp.support.model.DIDLObject;
import org.jupnp.support.model.Person;
import org.jupnp.support.model.Res;
import org.jupnp.support.model.container.Container;
import org.jupnp.support.model.item.Item;

public class AudioItem
extends Item {
    public static final DIDLObject.Class CLASS = new DIDLObject.Class("object.item.audioItem");

    public AudioItem() {
        this.setClazz(CLASS);
    }

    public AudioItem(Item other) {
        super(other);
    }

    public AudioItem(String id, Container parent, String title, String creator, Res ... resource) {
        this(id, parent.getId(), title, creator, resource);
    }

    public AudioItem(String id, String parentID, String title, String creator, Res ... resource) {
        super(id, parentID, title, creator, CLASS);
        if (resource != null) {
            this.getResources().addAll(Arrays.asList(resource));
        }
    }

    public String getFirstGenre() {
        return (String)this.getFirstPropertyValue(DIDLObject.Property.UPNP.GENRE.class);
    }

    public String[] getGenres() {
        List list = this.getPropertyValues(DIDLObject.Property.UPNP.GENRE.class);
        return list.toArray(new String[list.size()]);
    }

    public AudioItem setGenres(String[] genres) {
        this.removeProperties(DIDLObject.Property.UPNP.GENRE.class);
        for (String genre : genres) {
            this.addProperty(new DIDLObject.Property.UPNP.GENRE(genre));
        }
        return this;
    }

    public String getDescription() {
        return (String)this.getFirstPropertyValue(DIDLObject.Property.DC.DESCRIPTION.class);
    }

    public AudioItem setDescription(String description) {
        this.replaceFirstProperty(new DIDLObject.Property.DC.DESCRIPTION(description));
        return this;
    }

    public String getLongDescription() {
        return (String)this.getFirstPropertyValue(DIDLObject.Property.UPNP.LONG_DESCRIPTION.class);
    }

    public AudioItem setLongDescription(String description) {
        this.replaceFirstProperty(new DIDLObject.Property.UPNP.LONG_DESCRIPTION(description));
        return this;
    }

    public Person getFirstPublisher() {
        return (Person)this.getFirstPropertyValue(DIDLObject.Property.DC.PUBLISHER.class);
    }

    public Person[] getPublishers() {
        List list = this.getPropertyValues(DIDLObject.Property.DC.PUBLISHER.class);
        return list.toArray(new Person[list.size()]);
    }

    public AudioItem setPublishers(Person[] publishers) {
        this.removeProperties(DIDLObject.Property.DC.PUBLISHER.class);
        for (Person publisher : publishers) {
            this.addProperty(new DIDLObject.Property.DC.PUBLISHER(publisher));
        }
        return this;
    }

    public URI getFirstRelation() {
        return (URI)this.getFirstPropertyValue(DIDLObject.Property.DC.RELATION.class);
    }

    public URI[] getRelations() {
        List list = this.getPropertyValues(DIDLObject.Property.DC.RELATION.class);
        return list.toArray(new URI[list.size()]);
    }

    public AudioItem setRelations(URI[] relations) {
        this.removeProperties(DIDLObject.Property.DC.RELATION.class);
        for (URI relation : relations) {
            this.addProperty(new DIDLObject.Property.DC.RELATION(relation));
        }
        return this;
    }

    public String getLanguage() {
        return (String)this.getFirstPropertyValue(DIDLObject.Property.DC.LANGUAGE.class);
    }

    public AudioItem setLanguage(String language) {
        this.replaceFirstProperty(new DIDLObject.Property.DC.LANGUAGE(language));
        return this;
    }

    public String getFirstRights() {
        return (String)this.getFirstPropertyValue(DIDLObject.Property.DC.RIGHTS.class);
    }

    public String[] getRights() {
        List list = this.getPropertyValues(DIDLObject.Property.DC.RIGHTS.class);
        return list.toArray(new String[list.size()]);
    }

    public AudioItem setRights(String[] rights) {
        this.removeProperties(DIDLObject.Property.DC.RIGHTS.class);
        for (String right : rights) {
            this.addProperty(new DIDLObject.Property.DC.RIGHTS(right));
        }
        return this;
    }
}

