/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.settings;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.tinymediamanager.addon.YtDlpAddon;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.TrailerQuality;
import org.tinymediamanager.core.TrailerSources;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieSettings;
import org.tinymediamanager.core.movie.filenaming.MovieTrailerNaming;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.components.button.DocsButton;
import org.tinymediamanager.ui.components.button.JHintCheckBox;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.components.panel.CollapsiblePanel;

class MovieTrailerOptionsSettingsPanel
extends JPanel {
    private final MovieSettings settings = MovieModuleManager.getInstance().getSettings();
    private final ItemListener checkBoxListener;
    private final ButtonGroup trailerFilenameButtonGroup = new ButtonGroup();
    private JComboBox<TrailerSources> cbTrailerSource;
    private JComboBox<TrailerQuality> cbTrailerQuality;
    private JCheckBox checkBox;
    private JCheckBox chckbxAutomaticTrailerDownload;
    private JRadioButton rbTrailerFilename1;
    private JRadioButton rbTrailerFilename2;
    private JRadioButton rbTrailerFilename3;
    private JRadioButton rbTrailerFilename4;
    private JLabel lblAutomaticTrailerDownloadHint;
    private JCheckBox chckbxTrailerDiscKodiStyle;
    private JCheckBox chckbxYtDlp;

    MovieTrailerOptionsSettingsPanel() {
        this.checkBoxListener = e -> this.checkChanges();
        this.settings.addPropertyChangeListener(evt -> {
            if ("preset".equals(evt.getPropertyName())) {
                this.buildCheckBoxes();
            }
        });
        this.initComponents();
        this.initDataBindings();
        this.buildCheckBoxes();
        this.chckbxYtDlp.setEnabled(new YtDlpAddon().isAvailable());
    }

    private void buildCheckBoxes() {
        this.clearSelection(this.rbTrailerFilename1, this.rbTrailerFilename2, this.rbTrailerFilename3, this.rbTrailerFilename4);
        List<MovieTrailerNaming> movieTrailerFilenames = this.settings.getTrailerFilenames();
        if (movieTrailerFilenames.contains(MovieTrailerNaming.FILENAME_TRAILER)) {
            this.rbTrailerFilename1.setSelected(true);
        } else if (movieTrailerFilenames.contains(MovieTrailerNaming.MOVIE_TRAILER)) {
            this.rbTrailerFilename2.setSelected(true);
        } else if (movieTrailerFilenames.contains(MovieTrailerNaming.TRAILERS_FILENAME_TRAILER)) {
            this.rbTrailerFilename3.setSelected(true);
        } else if (movieTrailerFilenames.contains(MovieTrailerNaming.TRAILER)) {
            this.rbTrailerFilename4.setSelected(true);
        }
        this.rbTrailerFilename1.addItemListener(this.checkBoxListener);
        this.rbTrailerFilename2.addItemListener(this.checkBoxListener);
        this.rbTrailerFilename3.addItemListener(this.checkBoxListener);
        this.rbTrailerFilename4.addItemListener(this.checkBoxListener);
    }

    private void clearSelection(JToggleButton ... toggleButtons) {
        for (JToggleButton button : toggleButtons) {
            button.removeItemListener(this.checkBoxListener);
            button.setSelected(false);
        }
    }

    private void checkChanges() {
        this.settings.clearTrailerFilenames();
        if (this.rbTrailerFilename1.isSelected()) {
            this.settings.addTrailerFilename(MovieTrailerNaming.FILENAME_TRAILER);
        }
        if (this.rbTrailerFilename2.isSelected()) {
            this.settings.addTrailerFilename(MovieTrailerNaming.MOVIE_TRAILER);
        }
        if (this.rbTrailerFilename3.isSelected()) {
            this.settings.addTrailerFilename(MovieTrailerNaming.TRAILERS_FILENAME_TRAILER);
        }
        if (this.rbTrailerFilename4.isSelected()) {
            this.settings.addTrailerFilename(MovieTrailerNaming.TRAILER);
        }
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("hidemode 0", "[grow]", "[]"));
        JPanel panelOptions = new JPanel();
        panelOptions.setLayout((LayoutManager)new MigLayout("hidemode 1, insets 0", "[20lp!][16lp!][grow]", "[][][][][][][][]"));
        TmmLabel lblOptionsT = new TmmLabel(TmmResourceBundle.getString("Settings.advancedoptions"), 1.16667);
        CollapsiblePanel collapsiblePanel = new CollapsiblePanel((JComponent)panelOptions, lblOptionsT, true);
        collapsiblePanel.addExtraTitleComponent(new DocsButton("/movies/settings#advanced-options-2"));
        this.add((Component)collapsiblePanel, "cell 0 0,growx, wmin 0");
        this.chckbxYtDlp = new JHintCheckBox(TmmResourceBundle.getString("Settings.trailer.ytdlp"));
        this.chckbxYtDlp.setToolTipText(TmmResourceBundle.getString("Settings.trailer.ytdlp.desc"));
        panelOptions.add((Component)this.chckbxYtDlp, "cell 1 0 2 1");
        this.checkBox = new JCheckBox(TmmResourceBundle.getString("Settings.trailer.preferred"));
        panelOptions.add((Component)this.checkBox, "cell 1 1 2 1");
        JLabel lblTrailerSource = new JLabel(TmmResourceBundle.getString("Settings.trailer.source"));
        panelOptions.add((Component)lblTrailerSource, "cell 2 2");
        this.cbTrailerSource = new JComboBox();
        this.cbTrailerSource.setModel(new DefaultComboBoxModel<TrailerSources>(TrailerSources.values()));
        panelOptions.add(this.cbTrailerSource, "cell 2 2");
        JLabel lblTrailerQuality = new JLabel(TmmResourceBundle.getString("Settings.trailer.quality"));
        panelOptions.add((Component)lblTrailerQuality, "cell 2 3");
        this.cbTrailerQuality = new JComboBox();
        this.cbTrailerQuality.setModel(new DefaultComboBoxModel<TrailerQuality>(TrailerQuality.values()));
        panelOptions.add(this.cbTrailerQuality, "cell 2 3");
        this.chckbxAutomaticTrailerDownload = new JCheckBox(TmmResourceBundle.getString("Settings.trailer.automaticdownload"));
        panelOptions.add((Component)this.chckbxAutomaticTrailerDownload, "cell 2 4");
        this.lblAutomaticTrailerDownloadHint = new JLabel(TmmResourceBundle.getString("Settings.trailer.automaticdownload.hint"));
        panelOptions.add((Component)this.lblAutomaticTrailerDownloadHint, "cell 2 5");
        TmmFontHelper.changeFont((JComponent)this.lblAutomaticTrailerDownloadHint, 0.83333);
        JPanel panelTrailerFilenames = new JPanel();
        panelOptions.add((Component)panelTrailerFilenames, "cell 1 6 2 1");
        panelTrailerFilenames.setLayout((LayoutManager)new MigLayout("insets 0", "[][]", "[][][]"));
        JLabel lblTrailerFileNaming = new JLabel(TmmResourceBundle.getString("Settings.trailerFileNaming"));
        panelTrailerFilenames.add((Component)lblTrailerFileNaming, "cell 0 0");
        this.rbTrailerFilename1 = new JRadioButton(TmmResourceBundle.getString("Settings.moviefilename") + "-trailer." + TmmResourceBundle.getString("Settings.artwork.extension"));
        this.trailerFilenameButtonGroup.add(this.rbTrailerFilename1);
        panelTrailerFilenames.add((Component)this.rbTrailerFilename1, "cell 1 0");
        this.rbTrailerFilename2 = new JRadioButton("movie-trailer." + TmmResourceBundle.getString("Settings.artwork.extension"));
        this.trailerFilenameButtonGroup.add(this.rbTrailerFilename2);
        panelTrailerFilenames.add((Component)this.rbTrailerFilename2, "cell 1 1");
        this.rbTrailerFilename3 = new JRadioButton("trailers/" + TmmResourceBundle.getString("Settings.moviefilename") + "-trailer." + TmmResourceBundle.getString("Settings.artwork.extension"));
        this.trailerFilenameButtonGroup.add(this.rbTrailerFilename3);
        panelTrailerFilenames.add((Component)this.rbTrailerFilename3, "cell 1 2");
        this.rbTrailerFilename4 = new JRadioButton("trailer." + TmmResourceBundle.getString("Settings.artwork.extension"));
        this.trailerFilenameButtonGroup.add(this.rbTrailerFilename4);
        panelTrailerFilenames.add((Component)this.rbTrailerFilename4, "cell 1 3");
        this.chckbxTrailerDiscKodiStyle = new JCheckBox(TmmResourceBundle.getString("Settings.trailerDiscFolder"));
        panelOptions.add((Component)this.chckbxTrailerDiscKodiStyle, "cell 2 7");
    }

    protected void initDataBindings() {
        BeanProperty movieSettingsBeanProperty = BeanProperty.create((String)"trailerSource");
        BeanProperty jComboBoxBeanProperty = BeanProperty.create((String)"selectedItem");
        AutoBinding autoBinding_1 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)movieSettingsBeanProperty, this.cbTrailerSource, (Property)jComboBoxBeanProperty);
        autoBinding_1.bind();
        BeanProperty movieSettingsBeanProperty_1 = BeanProperty.create((String)"trailerQuality");
        BeanProperty jComboBoxBeanProperty_1 = BeanProperty.create((String)"selectedItem");
        AutoBinding autoBinding_2 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)movieSettingsBeanProperty_1, this.cbTrailerQuality, (Property)jComboBoxBeanProperty_1);
        autoBinding_2.bind();
        BeanProperty movieSettingsBeanProperty_2 = BeanProperty.create((String)"useTrailerPreference");
        BeanProperty jCheckBoxBeanProperty = BeanProperty.create((String)"selected");
        AutoBinding autoBinding_3 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)movieSettingsBeanProperty_2, (Object)this.checkBox, (Property)jCheckBoxBeanProperty);
        autoBinding_3.bind();
        BeanProperty movieSettingsBeanProperty_3 = BeanProperty.create((String)"automaticTrailerDownload");
        AutoBinding autoBinding_4 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)movieSettingsBeanProperty_3, (Object)this.chckbxAutomaticTrailerDownload, (Property)jCheckBoxBeanProperty);
        autoBinding_4.bind();
        BeanProperty jCheckBoxBeanProperty_1 = BeanProperty.create((String)"enabled");
        AutoBinding autoBinding_5 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.checkBox, (Property)jCheckBoxBeanProperty, (Object)this.chckbxAutomaticTrailerDownload, (Property)jCheckBoxBeanProperty_1);
        autoBinding_5.bind();
        BeanProperty jLabelBeanProperty = BeanProperty.create((String)"enabled");
        AutoBinding autoBinding_6 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.checkBox, (Property)jCheckBoxBeanProperty, (Object)this.lblAutomaticTrailerDownloadHint, (Property)jLabelBeanProperty);
        autoBinding_6.bind();
        BeanProperty movieSettingsBeanProperty_4 = BeanProperty.create((String)"trailerDiscFolderInside");
        AutoBinding autoBinding_7 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)movieSettingsBeanProperty_4, (Object)this.chckbxTrailerDiscKodiStyle, (Property)jCheckBoxBeanProperty);
        autoBinding_7.bind();
        BeanProperty movieSettingsBeanProperty_5 = BeanProperty.create((String)"useYtDlp");
        AutoBinding autoBinding_8 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)movieSettingsBeanProperty_5, (Object)this.chckbxYtDlp, (Property)jCheckBoxBeanProperty);
        autoBinding_8.bind();
    }
}

