/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.library.bluray.playlist;

import jakarta.xml.bind.annotation.XmlElement;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class UOMaskTable {
    private boolean chapterSearchMask;
    private boolean timeSearchMask;
    private boolean skipToNextPointMask;
    private boolean skipBackToPreviousPointMask;
    private boolean stopMask;
    private boolean pauseOnMask;
    private boolean stillOffMask;
    private boolean forwardPlayMask;
    private boolean backwardPlayMask;
    private boolean resumeMask;
    private boolean moveUpSelectedButtonMask;
    private boolean moveDownSelectedButtonMask;
    private boolean moveLeftSelectedButtonMask;
    private boolean moveRightSelectedButtonMask;
    private boolean selectButtonMask;
    private boolean activateButtonMask;
    private boolean selectButtonAndActivateMask;
    private boolean primaryAudioStreamNumberChangeMask;
    private boolean angleNumberChangeMask;
    private boolean popupOnMask;
    private boolean popupOffMask;
    private boolean pgTextSTEnableDisableMask;
    private boolean pgTextSTStreamNumberChangeMask;
    private boolean secondaryVideoEnableDisableMask;
    private boolean secondaryVideoStreamNumberChangeMask;
    private boolean secondaryAudioEnableDisableMask;
    private boolean secondaryAudioStreamNumberChangeMask;
    private boolean pipPGTextSTStreamNumberChangeMask;
    private static HashMap<String, Field> MASKS = new HashMap();

    private static void register(String string) {
        try {
            Field field = UOMaskTable.class.getDeclaredField(string);
            MASKS.put(string, field);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new IllegalArgumentException("Field " + string + "not found.");
        }
    }

    public void readObject(DataInputStream dataInputStream) throws IOException {
        byte[] byArray = new byte[8];
        dataInputStream.read(byArray);
        int n = 0;
        byte by = byArray[n++];
        this.setChapterSearchMask((by & 0x20) != 0);
        this.setTimeSearchMask((by & 0x10) != 0);
        this.setSkipToNextPointMask((by & 8) != 0);
        this.setSkipBackToPreviousPointMask((by & 4) != 0);
        this.setStopMask((by & 1) != 0);
        by = byArray[n++];
        this.setPauseOnMask((by & 0x80) != 0);
        this.setStillOffMask((by & 0x20) != 0);
        this.setForwardPlayMask((by & 0x10) != 0);
        this.setBackwardPlayMask((by & 8) != 0);
        this.setResumeMask((by & 4) != 0);
        this.setMoveUpSelectedButtonMask((by & 2) != 0);
        this.setMoveDownSelectedButtonMask((by & 1) != 0);
        by = byArray[n++];
        this.setMoveLeftSelectedButtonMask((by & 0x80) != 0);
        this.setMoveRightSelectedButtonMask((by & 0x40) != 0);
        this.setSelectButtonMask((by & 0x20) != 0);
        this.setActivateButtonMask((by & 0x10) != 0);
        this.setSelectButtonAndActivateMask((by & 8) != 0);
        this.setPrimaryAudioStreamNumberChangeMask((by & 4) != 0);
        this.setAngleNumberChangeMask((by & 1) != 0);
        by = byArray[n++];
        this.setPopupOnMask((by & 0x80) != 0);
        this.setPopupOffMask((by & 0x40) != 0);
        this.setPGTextSTEnableDisableMask((by & 0x20) != 0);
        this.setPGTextSTStreamNumberChangeMask((by & 0x10) != 0);
        this.setSecondaryVideoEnableDisableMask((by & 8) != 0);
        this.setSecondaryVideoStreamNumberChangeMask((by & 4) != 0);
        this.setSecondaryAudioEnableDisableMask((by & 2) != 0);
        this.setSecondaryAudioStreamNumberChangeMask((by & 1) != 0);
        by = byArray[n++];
        this.setPipPGTextSTStreamNumberChangeMask((by & 0x40) != 0);
    }

    public void writeObject(DataOutputStream dataOutputStream) throws IOException {
        byte[] byArray = new byte[8];
        int n = 0;
        int n2 = 0;
        n2 = this.getChapterSearchMask() ? n2 | 0x20 : n2;
        n2 = this.getTimeSearchMask() ? n2 | 0x10 : n2;
        n2 = this.getSkipToNextPointMask() ? n2 | 8 : n2;
        n2 = this.getSkipBackToPreviousPointMask() ? n2 | 4 : n2;
        n2 = this.getStopMask() ? n2 | 1 : n2;
        byArray[n++] = (byte)n2;
        n2 = 0;
        n2 = this.getPauseOnMask() ? n2 | 0x80 : n2;
        n2 = this.getStillOffMask() ? n2 | 0x20 : n2;
        n2 = this.getForwardPlayMask() ? n2 | 0x10 : n2;
        n2 = this.getBackwardPlayMask() ? n2 | 8 : n2;
        n2 = this.getResumeMask() ? n2 | 4 : n2;
        n2 = this.getMoveUpSelectedButtonMask() ? n2 | 2 : n2;
        n2 = this.getMoveDownSelectedButtonMask() ? n2 | 1 : n2;
        byArray[n++] = (byte)n2;
        n2 = 0;
        n2 = this.getMoveLeftSelectedButtonMask() ? n2 | 0x80 : n2;
        n2 = this.getMoveRightSelectedButtonMask() ? n2 | 0x40 : n2;
        n2 = this.getSelectButtonMask() ? n2 | 0x20 : n2;
        n2 = this.getActivateButtonMask() ? n2 | 0x10 : n2;
        n2 = this.getSelectButtonAndActivateMask() ? n2 | 8 : n2;
        n2 = this.getPrimaryAudioStreamNumberChangeMask() ? n2 | 4 : n2;
        n2 = this.getAngleNumberChangeMask() ? n2 | 1 : n2;
        byArray[n++] = (byte)n2;
        n2 = 0;
        n2 = this.getPopupOnMask() ? n2 | 0x80 : n2;
        n2 = this.getPopupOffMask() ? n2 | 0x40 : n2;
        n2 = this.getPGTextSTEnableDisableMask() ? n2 | 0x20 : n2;
        n2 = this.getPGTextSTStreamNumberChangeMask() ? n2 | 0x10 : n2;
        n2 = this.getSecondaryVideoEnableDisableMask() ? n2 | 8 : n2;
        n2 = this.getSecondaryVideoStreamNumberChangeMask() ? n2 | 4 : n2;
        n2 = this.getSecondaryAudioEnableDisableMask() ? n2 | 2 : n2;
        n2 = this.getSecondaryAudioStreamNumberChangeMask() ? n2 | 1 : n2;
        byArray[n++] = (byte)n2;
        n2 = 0;
        n2 = this.getPipPGTextSTStreamNumberChangeMask() ? n2 | 0x40 : n2;
        byArray[n++] = (byte)n2;
        dataOutputStream.write(byArray);
    }

    public void setMasks(String[] stringArray) {
        for (String string : stringArray) {
            Field field = MASKS.get(string);
            if (field == null) {
                throw new IllegalArgumentException("Unexpected Mask identifier " + string);
            }
            try {
                field.setBoolean(this, true);
            }
            catch (Exception exception) {
                throw new RuntimeException("Unexpected exception " + exception);
            }
        }
    }

    @XmlElement(name="UOMask")
    public String[] getMasks() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator<String> iterator = MASKS.keySet().iterator();
        while (iterator.hasNext()) {
            try {
                String string = iterator.next();
                boolean bl = MASKS.get(string).getBoolean(this);
                if (!bl) continue;
                arrayList.add(string);
            }
            catch (Exception exception) {
                throw new RuntimeException("Unexpected exception " + exception);
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private boolean getChapterSearchMask() {
        return this.chapterSearchMask;
    }

    private void setChapterSearchMask(boolean bl) {
        this.chapterSearchMask = bl;
    }

    private boolean getTimeSearchMask() {
        return this.timeSearchMask;
    }

    private void setTimeSearchMask(boolean bl) {
        this.timeSearchMask = bl;
    }

    private boolean getSkipToNextPointMask() {
        return this.skipToNextPointMask;
    }

    private void setSkipToNextPointMask(boolean bl) {
        this.skipToNextPointMask = bl;
    }

    private boolean getSkipBackToPreviousPointMask() {
        return this.skipBackToPreviousPointMask;
    }

    private void setSkipBackToPreviousPointMask(boolean bl) {
        this.skipBackToPreviousPointMask = bl;
    }

    private boolean getStopMask() {
        return this.stopMask;
    }

    private void setStopMask(boolean bl) {
        this.stopMask = bl;
    }

    private boolean getPauseOnMask() {
        return this.pauseOnMask;
    }

    private void setPauseOnMask(boolean bl) {
        this.pauseOnMask = bl;
    }

    private boolean getStillOffMask() {
        return this.stillOffMask;
    }

    private void setStillOffMask(boolean bl) {
        this.stillOffMask = bl;
    }

    private boolean getForwardPlayMask() {
        return this.forwardPlayMask;
    }

    private void setForwardPlayMask(boolean bl) {
        this.forwardPlayMask = bl;
    }

    private boolean getBackwardPlayMask() {
        return this.backwardPlayMask;
    }

    private void setBackwardPlayMask(boolean bl) {
        this.backwardPlayMask = bl;
    }

    private boolean getResumeMask() {
        return this.resumeMask;
    }

    private void setResumeMask(boolean bl) {
        this.resumeMask = bl;
    }

    private boolean getMoveUpSelectedButtonMask() {
        return this.moveUpSelectedButtonMask;
    }

    private void setMoveUpSelectedButtonMask(boolean bl) {
        this.moveUpSelectedButtonMask = bl;
    }

    private boolean getMoveDownSelectedButtonMask() {
        return this.moveDownSelectedButtonMask;
    }

    private void setMoveDownSelectedButtonMask(boolean bl) {
        this.moveDownSelectedButtonMask = bl;
    }

    private boolean getMoveLeftSelectedButtonMask() {
        return this.moveLeftSelectedButtonMask;
    }

    private void setMoveLeftSelectedButtonMask(boolean bl) {
        this.moveLeftSelectedButtonMask = bl;
    }

    private boolean getMoveRightSelectedButtonMask() {
        return this.moveRightSelectedButtonMask;
    }

    private void setMoveRightSelectedButtonMask(boolean bl) {
        this.moveRightSelectedButtonMask = bl;
    }

    private boolean getSelectButtonMask() {
        return this.selectButtonMask;
    }

    private void setSelectButtonMask(boolean bl) {
        this.selectButtonMask = bl;
    }

    private boolean getActivateButtonMask() {
        return this.activateButtonMask;
    }

    private void setActivateButtonMask(boolean bl) {
        this.activateButtonMask = bl;
    }

    private boolean getSelectButtonAndActivateMask() {
        return this.selectButtonAndActivateMask;
    }

    private void setSelectButtonAndActivateMask(boolean bl) {
        this.selectButtonAndActivateMask = bl;
    }

    private boolean getPrimaryAudioStreamNumberChangeMask() {
        return this.primaryAudioStreamNumberChangeMask;
    }

    private void setPrimaryAudioStreamNumberChangeMask(boolean bl) {
        this.primaryAudioStreamNumberChangeMask = bl;
    }

    private boolean getAngleNumberChangeMask() {
        return this.angleNumberChangeMask;
    }

    private void setAngleNumberChangeMask(boolean bl) {
        this.angleNumberChangeMask = bl;
    }

    private boolean getPopupOnMask() {
        return this.popupOnMask;
    }

    private void setPopupOnMask(boolean bl) {
        this.popupOnMask = bl;
    }

    private boolean getPopupOffMask() {
        return this.popupOffMask;
    }

    private void setPopupOffMask(boolean bl) {
        this.popupOffMask = bl;
    }

    private boolean getPGTextSTEnableDisableMask() {
        return this.pgTextSTEnableDisableMask;
    }

    private void setPGTextSTEnableDisableMask(boolean bl) {
        this.pgTextSTEnableDisableMask = bl;
    }

    private boolean getPGTextSTStreamNumberChangeMask() {
        return this.pgTextSTStreamNumberChangeMask;
    }

    private void setPGTextSTStreamNumberChangeMask(boolean bl) {
        this.pgTextSTStreamNumberChangeMask = bl;
    }

    private boolean getSecondaryVideoEnableDisableMask() {
        return this.secondaryVideoEnableDisableMask;
    }

    private void setSecondaryVideoEnableDisableMask(boolean bl) {
        this.secondaryVideoEnableDisableMask = bl;
    }

    private boolean getSecondaryVideoStreamNumberChangeMask() {
        return this.secondaryVideoStreamNumberChangeMask;
    }

    private void setSecondaryVideoStreamNumberChangeMask(boolean bl) {
        this.secondaryVideoStreamNumberChangeMask = bl;
    }

    private boolean getSecondaryAudioEnableDisableMask() {
        return this.secondaryAudioEnableDisableMask;
    }

    private void setSecondaryAudioEnableDisableMask(boolean bl) {
        this.secondaryAudioEnableDisableMask = bl;
    }

    private boolean getSecondaryAudioStreamNumberChangeMask() {
        return this.secondaryAudioStreamNumberChangeMask;
    }

    private void setSecondaryAudioStreamNumberChangeMask(boolean bl) {
        this.secondaryAudioStreamNumberChangeMask = bl;
    }

    private boolean getPipPGTextSTStreamNumberChangeMask() {
        return this.pipPGTextSTStreamNumberChangeMask;
    }

    private void setPipPGTextSTStreamNumberChangeMask(boolean bl) {
        this.pipPGTextSTStreamNumberChangeMask = bl;
    }

    static {
        UOMaskTable.register("chapterSearchMask");
        UOMaskTable.register("timeSearchMask");
        UOMaskTable.register("skipToNextPointMask");
        UOMaskTable.register("skipBackToPreviousPointMask");
        UOMaskTable.register("stopMask");
        UOMaskTable.register("pauseOnMask");
        UOMaskTable.register("stillOffMask");
        UOMaskTable.register("forwardPlayMask");
        UOMaskTable.register("backwardPlayMask");
        UOMaskTable.register("resumeMask");
        UOMaskTable.register("moveUpSelectedButtonMask");
        UOMaskTable.register("moveDownSelectedButtonMask");
        UOMaskTable.register("moveLeftSelectedButtonMask");
        UOMaskTable.register("moveRightSelectedButtonMask");
        UOMaskTable.register("selectButtonMask");
        UOMaskTable.register("activateButtonMask");
        UOMaskTable.register("selectButtonAndActivateMask");
        UOMaskTable.register("primaryAudioStreamNumberChangeMask");
        UOMaskTable.register("angleNumberChangeMask");
        UOMaskTable.register("popupOnMask");
        UOMaskTable.register("popupOffMask");
        UOMaskTable.register("pgTextSTEnableDisableMask");
        UOMaskTable.register("pgTextSTStreamNumberChangeMask");
        UOMaskTable.register("secondaryVideoEnableDisableMask");
        UOMaskTable.register("secondaryVideoStreamNumberChangeMask");
        UOMaskTable.register("secondaryAudioEnableDisableMask");
        UOMaskTable.register("secondaryAudioStreamNumberChangeMask");
        UOMaskTable.register("pipPGTextSTStreamNumberChangeMask");
    }
}

