/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.jmte;

import com.floreysoft.jmte.NamedRenderer;
import com.floreysoft.jmte.RenderFormatInfo;
import java.io.FileReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.Globals;
import org.tinymediamanager.scraper.util.CacheMap;

public class NamedReplacementRenderer
implements NamedRenderer {
    private static final Logger LOGGER = LoggerFactory.getLogger(NamedReplacementRenderer.class);
    private static final CacheMap<String, List<String[]>> CACHE = new CacheMap(60L, 5L);

    public String render(Object object, String filename, Locale locale, Map<String, Object> map) {
        Object csv;
        if (object == null || StringUtils.isBlank((CharSequence)filename)) {
            return null;
        }
        String result = object.toString();
        List<String[]> csvContents = CACHE.get(filename.strip());
        if (csvContents == null && Files.exists((Path)(csv = Paths.get(Globals.DATA_FOLDER, filename.strip())), new LinkOption[0])) {
            ArrayList<String[]> tokens = new ArrayList<String[]>();
            try (FileReader in = new FileReader(csv.toFile());){
                CSVParser records = CSVFormat.DEFAULT.parse((Reader)in);
                for (CSVRecord record : records) {
                    if (record.size() != 2) continue;
                    tokens.add(new String[]{record.get(0), record.get(1)});
                }
                CACHE.put(filename.strip(), tokens);
                csvContents = tokens;
            }
            catch (Exception e) {
                LOGGER.warn("Could not read replacement CSV '{}' - '{}'", (Object)filename, (Object)e.getMessage());
            }
        }
        if (csvContents != null) {
            for (String[] csvLine : csvContents) {
                if (csvLine.length != 2) continue;
                result = result.replace(csvLine[0], csvLine[1]);
            }
        } else {
            String[] rep = filename.split(",", -1);
            if (rep.length < 2) {
                return result;
            }
            if (rep.length == 2) {
                result = result.replace(rep[0], rep[1]);
            } else if (rep[0].isEmpty()) {
                result = result.replace(",", rep[2]);
            }
        }
        return result;
    }

    public String getName() {
        return "replace";
    }

    public RenderFormatInfo getFormatInfo() {
        return null;
    }

    public Class<?>[] getSupportedClasses() {
        return new Class[]{String.class};
    }
}

