/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.loopfs.udf.descriptor.element;

import com.github.stephenc.javaisotools.loopfs.udf.UDFUtil;
import com.github.stephenc.javaisotools.loopfs.udf.exceptions.InvalidExtentAD;

public class ExtentAD {
    public Long length;
    public Long location;
    public static final int LENGTH = 8;

    public ExtentAD(byte[] byArray) throws InvalidExtentAD {
        this.deserialize(byArray);
    }

    private void deserialize(byte[] byArray) throws InvalidExtentAD {
        if (byArray.length < 8) {
            throw new InvalidExtentAD("extent allocation descriptor too short");
        }
        this.length = ExtentAD.calculateLength(byArray, 0);
        this.location = UDFUtil.getUInt32(byArray, 4);
    }

    private static long calculateLength(byte[] byArray, int n) {
        long l = byArray[n] & 0xFF;
        long l2 = byArray[n + 1] & 0xFF;
        long l3 = byArray[n + 2] & 0xFF;
        long l4 = byArray[n + 3] & 0x3F;
        return l4 << 24 | l3 << 16 | l2 << 8 | l;
    }

    public String toString() {
        return "ExtentAD [length=" + this.length + ", location=" + this.location + "]";
    }
}

