/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.moviesets.dialogs;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.ObservableElementList;
import ca.odell.glazedlists.swing.GlazedListsSwing;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.ScraperMetadataConfig;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieSetScraperMetadataConfig;
import org.tinymediamanager.core.movie.MovieSetSearchAndScrapeOptions;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.entities.MovieSet;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.ScraperType;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.interfaces.IMovieSetMetadataProvider;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.TmmUILayoutStore;
import org.tinymediamanager.ui.components.NoBorderScrollPane;
import org.tinymediamanager.ui.components.combobox.ScraperMetadataConfigCheckComboBox;
import org.tinymediamanager.ui.components.label.ImageLabel;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.components.table.TmmTable;
import org.tinymediamanager.ui.components.table.TmmTableFormat;
import org.tinymediamanager.ui.components.table.TmmTableModel;
import org.tinymediamanager.ui.components.textfield.ReadOnlyTextPane;
import org.tinymediamanager.ui.dialogs.ImageChooserDialog;
import org.tinymediamanager.ui.dialogs.TmmDialog;
import org.tinymediamanager.ui.moviesets.MovieSetChooserModel;
import org.tinymediamanager.ui.renderer.IntegerTableCellRenderer;

public class MovieSetChooserDialog
extends TmmDialog
implements ActionListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieSetChooserDialog.class);
    private final MovieSet movieSetToScrape;
    private final EventList<MovieSetChooserModel> searchResultEventList;
    private final EventList<MovieSetChooserModel.MovieInSet> movieInSetEventList;
    private MovieSetChooserModel selectedResult = null;
    private final JLabel lblProgressAction;
    private final JProgressBar progressBar;
    private final JTextField tfMovieSetName;
    private final TmmTable tableMovieSets;
    private final JLabel lblMovieSetName;
    private final ImageLabel lblMovieSetPoster;
    private final TmmTable tableMovies;
    private final JCheckBox cbAssignMovies;
    private final JButton btnOk;
    private final JTextPane tpPlot;
    private final ScraperMetadataConfigCheckComboBox<MovieSetScraperMetadataConfig> cbScraperConfig;
    private boolean continueQueue = true;

    public MovieSetChooserDialog(MovieSet movieSet, boolean inQueue) {
        super(TmmResourceBundle.getString("movieset.search"), "movieSetChooser");
        this.setMinimumSize(new Dimension(1000, 650));
        this.movieSetToScrape = movieSet;
        this.searchResultEventList = new ObservableElementList((EventList)GlazedListsSwing.swingThreadProxyList((EventList)GlazedLists.threadSafeList((EventList)new BasicEventList())), GlazedLists.beanConnector(MovieSetChooserModel.class));
        this.movieInSetEventList = new ObservableElementList((EventList)GlazedListsSwing.swingThreadProxyList((EventList)GlazedLists.threadSafeList((EventList)new BasicEventList())), GlazedLists.beanConnector(MovieSetChooserModel.MovieInSet.class));
        JPanel panelHeader = new JPanel();
        panelHeader.setLayout((LayoutManager)new MigLayout("", "[grow][]", "[]"));
        SearchAction searchAction = new SearchAction();
        this.tfMovieSetName = new JTextField();
        this.tfMovieSetName.addActionListener(searchAction);
        panelHeader.add((Component)this.tfMovieSetName, "cell 0 0,growx");
        this.tfMovieSetName.setColumns(10);
        JButton btnSearch = new JButton(searchAction);
        panelHeader.add((Component)btnSearch, "cell 1 0");
        this.setTopInformationPanel(panelHeader);
        JPanel panelContent = new JPanel();
        this.getContentPane().add((Component)panelContent, "Center");
        panelContent.setLayout((LayoutManager)new MigLayout("", "[950lp,grow]", "[500,grow][][][]"));
        JSplitPane splitPane = new JSplitPane();
        splitPane.setName(this.getName() + ".splitPane");
        TmmUILayoutStore.getInstance().install(splitPane);
        panelContent.add((Component)splitPane, "cell 0 0,grow");
        JPanel panelResults = new JPanel();
        panelResults.setLayout((LayoutManager)new MigLayout("", "[300lp:400lp,grow]", "[300lp,grow]"));
        JScrollPane panelSearchResults = new JScrollPane();
        panelResults.add((Component)panelSearchResults, "cell 0 0,grow");
        splitPane.setLeftComponent(panelResults);
        this.tableMovieSets = new TmmTable((TableModel)((Object)new TmmTableModel<MovieSetChooserModel>(this.searchResultEventList, new SearchResultTableFormat())));
        this.tableMovieSets.configureScrollPane(panelSearchResults);
        this.tableMovieSets.setSelectionMode(0);
        JPanel panelSearchDetail = new JPanel();
        splitPane.setRightComponent(panelSearchDetail);
        panelSearchDetail.setLayout((LayoutManager)new MigLayout("", "[150lp:15%:20%,grow][15lp!][500lp:600lp,grow 3]", "[][15lp!][100lp:25%:40%,grow][100lp:25%:40%,grow][]"));
        this.lblMovieSetName = new JLabel("");
        TmmFontHelper.changeFont(this.lblMovieSetName, 1.166, 1);
        panelSearchDetail.add((Component)this.lblMovieSetName, "cell 2 0,growx");
        this.lblMovieSetPoster = new ImageLabel();
        this.lblMovieSetPoster.setDesiredAspectRatio(0.6666667f);
        panelSearchDetail.add((Component)this.lblMovieSetPoster, "cell 0 0 1 3,grow");
        JScrollPane scrollPane = new NoBorderScrollPane();
        panelSearchDetail.add((Component)scrollPane, "cell 2 2,grow");
        this.tpPlot = new ReadOnlyTextPane();
        scrollPane.setViewportView(this.tpPlot);
        scrollPane = new JScrollPane();
        panelSearchDetail.add((Component)scrollPane, "cell 0 3 3 1,grow");
        this.tableMovies = new TmmTable((TableModel)((Object)new TmmTableModel<MovieSetChooserModel.MovieInSet>(this.movieInSetEventList, new MovieInSetTableFormat())));
        this.tableMovies.configureScrollPane(scrollPane);
        scrollPane.setViewportView(this.tableMovies);
        this.cbAssignMovies = new JCheckBox(TmmResourceBundle.getString("movieset.movie.assign"));
        this.cbAssignMovies.setSelected(true);
        panelSearchDetail.add((Component)this.cbAssignMovies, "cell 0 4 3 1,growx,aligny top");
        JSeparator separator = new JSeparator();
        panelContent.add((Component)separator, "cell 0 1,growx");
        TmmLabel lblScrapeFollowingItems = new TmmLabel(TmmResourceBundle.getString("chooser.scrape"));
        panelContent.add((Component)lblScrapeFollowingItems, "cell 0 2");
        this.cbScraperConfig = new ScraperMetadataConfigCheckComboBox((ScraperMetadataConfig[])MovieSetScraperMetadataConfig.values());
        this.cbScraperConfig.enableFilter((movieScraperMetadataConfig, s) -> movieScraperMetadataConfig.getDescription().toLowerCase(Locale.ROOT).startsWith(s.toLowerCase(Locale.ROOT)));
        panelContent.add(this.cbScraperConfig, "cell 0 3,growx, wmin 0");
        JPanel infoPanel = new JPanel();
        infoPanel.setLayout((LayoutManager)new MigLayout("hidemode 3", "[][grow]", "[]"));
        this.progressBar = new JProgressBar();
        infoPanel.add((Component)this.progressBar, "cell 0 0");
        this.lblProgressAction = new JLabel("");
        infoPanel.add((Component)this.lblProgressAction, "cell 1 0");
        this.setBottomInformationPanel(infoPanel);
        if (inQueue) {
            JButton btnAbort = new JButton(TmmResourceBundle.getString("Button.abortqueue"));
            btnAbort.setActionCommand("Abort");
            btnAbort.setToolTipText(TmmResourceBundle.getString("Button.abortqueue"));
            btnAbort.setIcon(IconManager.STOP_INV);
            btnAbort.addActionListener(this);
            this.addButton(btnAbort);
        }
        JButton btnCancel = new JButton(TmmResourceBundle.getString("Button.cancel"));
        btnCancel.setActionCommand("Cancel");
        btnCancel.setToolTipText(TmmResourceBundle.getString("Button.cancel"));
        btnCancel.setIcon(IconManager.CANCEL_INV);
        btnCancel.addActionListener(this);
        this.addButton(btnCancel);
        this.btnOk = new JButton(TmmResourceBundle.getString("Button.ok"));
        this.btnOk.setActionCommand("Save");
        this.btnOk.setToolTipText(TmmResourceBundle.getString("Button.ok"));
        this.btnOk.setIcon(IconManager.APPLY_INV);
        this.btnOk.addActionListener(this);
        this.getRootPane().registerKeyboardAction(this, "Save", KeyStroke.getKeyStroke(10, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx()), 2);
        this.addButton(this.btnOk);
        this.tableMovies.adjustColumnPreferredWidths(5);
        PropertyChangeListener listener = evt -> {
            int row;
            String property = evt.getPropertyName();
            if ("scraped".equals(property) && (row = this.tableMovieSets.convertRowIndexToModel(this.tableMovieSets.getSelectedRow())) > -1) {
                this.setData((MovieSetChooserModel)this.searchResultEventList.get(row));
            }
        };
        ListSelectionModel rowSM = this.tableMovieSets.getSelectionModel();
        rowSM.addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                return;
            }
            int index = this.tableMovieSets.convertRowIndexToModel(this.tableMovieSets.getSelectedRow());
            if (this.selectedResult != null) {
                this.selectedResult.removePropertyChangeListener(listener);
            }
            if (index > -1 && index < this.searchResultEventList.size()) {
                MovieSetChooserModel model = (MovieSetChooserModel)this.searchResultEventList.get(index);
                this.setData(model);
                this.selectedResult = model;
                this.selectedResult.addPropertyChangeListener(listener);
            } else {
                this.selectedResult = null;
            }
            ListSelectionModel lsm = (ListSelectionModel)e.getSource();
            if (!lsm.isSelectionEmpty()) {
                int selectedRow = lsm.getMinSelectionIndex();
                selectedRow = this.tableMovieSets.convertRowIndexToModel(selectedRow);
                try {
                    MovieSetChooserModel model = (MovieSetChooserModel)this.searchResultEventList.get(selectedRow);
                    if (model != MovieSetChooserModel.EMPTY_RESULT && !model.isScraped()) {
                        ScrapeTask task = new ScrapeTask(model);
                        task.execute();
                    }
                }
                catch (Exception ex) {
                    LOGGER.debug("scraping", (Throwable)ex);
                }
            }
        });
        this.tableMovieSets.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() >= 2 && !e.isConsumed() && e.getButton() == 1) {
                    MovieSetChooserDialog.this.actionPerformed(new ActionEvent(MovieSetChooserDialog.this.btnOk, 1001, "Save"));
                }
            }
        });
        this.cbScraperConfig.setSelectedItems((MovieSetScraperMetadataConfig[])MovieSetScraperMetadataConfig.values());
        this.tfMovieSetName.setText(movieSet.getTitle());
        this.searchMovieSet();
    }

    private void setData(MovieSetChooserModel model) {
        this.movieInSetEventList.addAll(model.getMovies());
        if (!model.getPosterUrl().equals(this.lblMovieSetPoster.getImageUrl())) {
            this.lblMovieSetPoster.setImageUrl(model.getPosterUrl());
        }
        this.lblMovieSetName.setText(model.getName());
        this.tpPlot.setText(model.getOverview());
        this.movieInSetEventList.clear();
        this.movieInSetEventList.addAll(model.getMovies());
    }

    private void searchMovieSet() {
        SearchTask task = new SearchTask(this.tfMovieSetName.getText());
        task.execute();
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        int row;
        if ("Cancel".equals(arg0.getActionCommand())) {
            this.setVisible(false);
        }
        if ("Save".equals(arg0.getActionCommand()) && (row = this.tableMovieSets.getSelectedRow()) >= 0) {
            MovieSetChooserModel model = (MovieSetChooserModel)this.searchResultEventList.get(row);
            if (model != MovieSetChooserModel.EMPTY_RESULT) {
                if (!model.isScraped()) {
                    MessageManager.getInstance().pushMessage(new Message(Message.MessageLevel.ERROR, "MovieSetChooser", "message.scrape.threadcrashed"));
                    return;
                }
                MediaMetadata md = model.getMetadata();
                List<MovieSetScraperMetadataConfig> scraperConfig = this.cbScraperConfig.getSelectedItems();
                this.movieSetToScrape.setMetadata(md, scraperConfig);
                this.movieSetToScrape.setDummyMovies(model.getMovieSetMovies());
                if (this.cbAssignMovies.isSelected()) {
                    this.movieSetToScrape.removeAllMovies();
                    for (int i = 0; i < model.getMovies().size(); ++i) {
                        MovieSetChooserModel.MovieInSet movieInSet = model.getMovies().get(i);
                        Movie movie = movieInSet.getMovie();
                        if (movie == null) continue;
                        if (movie.getMovieSet() != null) {
                            MovieSet mSet = movie.getMovieSet();
                            mSet.removeMovie(movie, true);
                        }
                        movie.setMovieSet(this.movieSetToScrape);
                        movie.writeNFO();
                        movie.saveToDb();
                        this.movieSetToScrape.insertMovie(movie);
                    }
                    this.movieSetToScrape.saveToDb();
                }
                if (ScraperMetadataConfig.containsAnyArtwork(scraperConfig)) {
                    if (!MovieModuleManager.getInstance().getSettings().isScrapeBestImageMovieSet()) {
                        if (scraperConfig.contains(MovieSetScraperMetadataConfig.POSTER)) {
                            this.chooseArtwork(MediaFileType.POSTER);
                        }
                        if (scraperConfig.contains(MovieSetScraperMetadataConfig.FANART)) {
                            this.chooseArtwork(MediaFileType.FANART);
                        }
                        if (scraperConfig.contains(MovieSetScraperMetadataConfig.BANNER)) {
                            this.chooseArtwork(MediaFileType.BANNER);
                        }
                        if (scraperConfig.contains(MovieSetScraperMetadataConfig.CLEARLOGO)) {
                            this.chooseArtwork(MediaFileType.CLEARLOGO);
                        }
                        if (scraperConfig.contains(MovieSetScraperMetadataConfig.CLEARART)) {
                            this.chooseArtwork(MediaFileType.CLEARART);
                        }
                        if (scraperConfig.contains(MovieSetScraperMetadataConfig.DISCART)) {
                            this.chooseArtwork(MediaFileType.DISC);
                        }
                        if (scraperConfig.contains(MovieSetScraperMetadataConfig.THUMB)) {
                            this.chooseArtwork(MediaFileType.THUMB);
                        }
                        this.movieSetToScrape.writeNFO();
                    } else {
                        model.startArtworkScrapeTask(this.movieSetToScrape, scraperConfig);
                    }
                }
            }
            this.setVisible(false);
        }
        if ("Abort".equals(arg0.getActionCommand())) {
            this.continueQueue = false;
            this.setVisible(false);
        }
    }

    private void chooseArtwork(MediaFileType mediaFileType) {
        MediaArtwork.MediaArtworkType imageType;
        switch (mediaFileType) {
            case POSTER: {
                if (MovieModuleManager.getInstance().getSettings().getMovieSetPosterFilenames().isEmpty()) {
                    return;
                }
                imageType = MediaArtwork.MediaArtworkType.POSTER;
                break;
            }
            case FANART: {
                if (MovieModuleManager.getInstance().getSettings().getMovieSetFanartFilenames().isEmpty()) {
                    return;
                }
                imageType = MediaArtwork.MediaArtworkType.BACKGROUND;
                break;
            }
            case BANNER: {
                if (MovieModuleManager.getInstance().getSettings().getMovieSetBannerFilenames().isEmpty()) {
                    return;
                }
                imageType = MediaArtwork.MediaArtworkType.BANNER;
                break;
            }
            case CLEARLOGO: 
            case LOGO: {
                if (MovieModuleManager.getInstance().getSettings().getMovieSetClearlogoFilenames().isEmpty()) {
                    return;
                }
                imageType = MediaArtwork.MediaArtworkType.CLEARLOGO;
                break;
            }
            case CLEARART: {
                if (MovieModuleManager.getInstance().getSettings().getMovieSetClearartFilenames().isEmpty()) {
                    return;
                }
                imageType = MediaArtwork.MediaArtworkType.CLEARART;
                break;
            }
            case DISC: {
                if (MovieModuleManager.getInstance().getSettings().getMovieSetDiscartFilenames().isEmpty()) {
                    return;
                }
                imageType = MediaArtwork.MediaArtworkType.DISC;
                break;
            }
            case THUMB: {
                if (MovieModuleManager.getInstance().getSettings().getMovieSetThumbFilenames().isEmpty()) {
                    return;
                }
                imageType = MediaArtwork.MediaArtworkType.THUMB;
                break;
            }
            default: {
                return;
            }
        }
        HashMap<String, Object> newIds = new HashMap<String, Object>(this.movieSetToScrape.getIds());
        String imageUrl = ImageChooserDialog.chooseImage(this, newIds, imageType, MovieModuleManager.getInstance().getMovieList().getDefaultArtworkScrapers(), MediaType.MOVIE_SET, MovieModuleManager.getInstance().getSettings().getMovieSetDataFolder());
        this.movieSetToScrape.setArtworkUrl(imageUrl, mediaFileType);
    }

    private void startProgressBar(String description) {
        SwingUtilities.invokeLater(() -> {
            this.lblProgressAction.setText(description);
            this.progressBar.setVisible(true);
            this.progressBar.setIndeterminate(true);
        });
    }

    private void stopProgressBar() {
        SwingUtilities.invokeLater(() -> {
            this.lblProgressAction.setText("");
            this.progressBar.setVisible(false);
            this.progressBar.setIndeterminate(false);
        });
    }

    public boolean showDialog() {
        this.setVisible(true);
        return this.continueQueue;
    }

    private class SearchAction
    extends AbstractAction {
        SearchAction() {
            this.putValue("Name", TmmResourceBundle.getString("Button.search"));
            this.putValue("ShortDescription", TmmResourceBundle.getString("movieset.search"));
            this.putValue("SmallIcon", IconManager.SEARCH_INV);
            this.putValue("SwingLargeIconKey", IconManager.SEARCH_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MovieSetChooserDialog.this.searchMovieSet();
        }
    }

    private static class SearchResultTableFormat
    extends TmmTableFormat<MovieSetChooserModel> {
        private SearchResultTableFormat() {
            TmmTableFormat.Column col = new TmmTableFormat.Column(TmmResourceBundle.getString("chooser.searchresult"), "title", MovieSetChooserModel::getName, String.class);
            col.setCellTooltip(MovieSetChooserModel::getName);
            this.addColumn(col);
        }
    }

    private static class MovieInSetTableFormat
    extends TmmTableFormat<MovieSetChooserModel.MovieInSet> {
        public MovieInSetTableFormat() {
            TmmTableFormat.Column col = new TmmTableFormat.Column(TmmResourceBundle.getString("metatag.title"), "title", MovieSetChooserModel.MovieInSet::getName, String.class);
            this.addColumn(col);
            col = new TmmTableFormat.Column(TmmResourceBundle.getString("metatag.year"), "year", MovieSetChooserModel.MovieInSet::getYear, Integer.class);
            col.setCellRenderer(new IntegerTableCellRenderer());
            col.setColumnResizeable(false);
            col.setMinWidth(this.getFontMetrics().stringWidth("2000") + this.getCellPadding());
            this.addColumn(col);
            col = new TmmTableFormat.Column(TmmResourceBundle.getString("movieset.movie.matched"), "machtedTitle", movieInSet -> {
                Movie movie = movieInSet.getMovie();
                if (movie != null) {
                    return movie.getTitle();
                }
                return null;
            }, String.class);
            this.addColumn(col);
        }
    }

    private class SearchTask
    extends SwingWorker<Void, Void> {
        private final String searchTerm;
        private List<MediaSearchResult> searchResult;
        private Throwable error = null;
        boolean cancel = false;

        public SearchTask(String searchTerm) {
            this.searchTerm = searchTerm;
        }

        @Override
        public Void doInBackground() {
            MovieSetChooserDialog.this.startProgressBar(TmmResourceBundle.getString("chooser.searchingfor") + " " + this.searchTerm);
            try {
                List<MediaScraper> sets = MediaScraper.getMediaScrapers(ScraperType.MOVIE_SET);
                if (sets != null && !sets.isEmpty()) {
                    MediaScraper first = sets.get(0);
                    IMovieSetMetadataProvider mp = (IMovieSetMetadataProvider)first.getMediaProvider();
                    MovieSetSearchAndScrapeOptions options = new MovieSetSearchAndScrapeOptions();
                    options.setSearchQuery(this.searchTerm);
                    options.setLanguage(MovieModuleManager.getInstance().getSettings().getScraperLanguage());
                    this.searchResult = mp.search(options);
                }
            }
            catch (Exception e1) {
                this.error = e1;
                LOGGER.debug("SearchTask", (Throwable)e1);
            }
            return null;
        }

        @Override
        public void done() {
            MovieSetChooserDialog.this.stopProgressBar();
            MovieSetChooserDialog.this.searchResultEventList.clear();
            if (this.searchResult.isEmpty()) {
                MovieSetChooserDialog.this.searchResultEventList.add((Object)MovieSetChooserModel.EMPTY_RESULT);
            } else {
                for (MediaSearchResult collection : this.searchResult) {
                    MovieSetChooserModel model = new MovieSetChooserModel(collection);
                    MovieSetChooserDialog.this.searchResultEventList.add((Object)model);
                }
            }
            if (!MovieSetChooserDialog.this.searchResultEventList.isEmpty()) {
                MovieSetChooserDialog.this.tableMovieSets.setRowSelectionInterval(0, 0);
            }
        }
    }

    private class ScrapeTask
    extends SwingWorker<Void, Void> {
        private final MovieSetChooserModel model;

        ScrapeTask(MovieSetChooserModel model) {
            this.model = model;
        }

        @Override
        public Void doInBackground() {
            MovieSetChooserDialog.this.startProgressBar(TmmResourceBundle.getString("chooser.scrapeing") + " " + this.model.getName());
            MovieSetChooserDialog.this.btnOk.setEnabled(false);
            this.model.scrapeMetadata();
            MovieSetChooserDialog.this.btnOk.setEnabled(true);
            return null;
        }

        @Override
        public void done() {
            MovieSetChooserDialog.this.stopProgressBar();
        }
    }
}

