/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.thetvdb;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.scraper.exceptions.HttpException;
import org.tinymediamanager.scraper.exceptions.NothingFoundException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.interfaces.IMovieArtworkProvider;
import org.tinymediamanager.scraper.thetvdb.TheTvDbArtworkProvider;
import org.tinymediamanager.scraper.thetvdb.entities.ArtworkBaseRecord;
import org.tinymediamanager.scraper.thetvdb.entities.MovieExtendedResponse;
import retrofit2.Response;

public class TheTvDbMovieArtworkProvider
extends TheTvDbArtworkProvider
implements IMovieArtworkProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(TheTvDbMovieArtworkProvider.class);

    @Override
    protected String getSubId() {
        return "movie_artwork";
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    @Override
    protected List<ArtworkBaseRecord> fetchArtwork(int id) throws ScrapeException {
        ArrayList<ArtworkBaseRecord> images = new ArrayList<ArtworkBaseRecord>();
        try {
            Response response = this.tvdb.getMoviesService().getMovieExtended(id).execute();
            if (!response.isSuccessful()) {
                if (response.code() == 404) {
                    throw new NothingFoundException();
                }
                throw new HttpException(response.code(), response.message());
            }
            if (response.body() != null && ((MovieExtendedResponse)response.body()).data != null && ((MovieExtendedResponse)response.body()).data.artworks != null) {
                images.addAll(((MovieExtendedResponse)response.body()).data.artworks);
            }
        }
        catch (Exception e) {
            LOGGER.debug("failed to get artwork: {}", (Object)e.getMessage());
            throw new ScrapeException(e);
        }
        return images;
    }
}

