/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.dialogs;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.AbstractSettings;
import org.tinymediamanager.core.TmmProperties;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.components.NoBorderScrollPane;
import org.tinymediamanager.ui.components.button.FlatButton;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.components.tabbedpane.TmmTabbedPane;
import org.tinymediamanager.ui.components.tree.TmmTreeNode;
import org.tinymediamanager.ui.components.treetable.TmmTreeTable;
import org.tinymediamanager.ui.dialogs.TmmDialog;
import org.tinymediamanager.ui.panels.FilterSavePanel;
import org.tinymediamanager.ui.panels.ModalPopupPanel;
import org.tinymediamanager.ui.tvshows.filters.ITvShowUIFilter;
import org.tinymediamanager.ui.tvshows.filters.TvShowAllInOneFilter;
import org.tinymediamanager.ui.tvshows.filters.TvShowAspectRatioFilter;
import org.tinymediamanager.ui.tvshows.filters.TvShowAudioChannelFilter;
import org.tinymediamanager.ui.tvshows.filters.TvShowAudioCodecFilter;
import org.tinymediamanager.ui.tvshows.filters.TvShowAudioLanguageFilter;
import org.tinymediamanager.ui.tvshows.filters.TvShowAudioStreamCountFilter;
import org.tinymediamanager.ui.tvshows.filters.TvShowAudioTitleFilter;
import org.tinymediamanager.ui.tvshows.filters.TvShowBannerSizeFilter;
import org.tinymediamanager.ui.tvshows.filters.TvShowCastFilter;
import org.tinymediamanager.ui.tvshows.filters.TvShowCertificationFilter;
import org.tinymediamanager.ui.tvshows.filters.TvShowClearArtSizeFilter;
import org.tinymediamanager.ui.tvshows.filters.TvShowClearLogoSizeFilter;
import org.tinymediamanager.ui.tvshows.filters.TvShowCountryFilter;
import org.tinymediamanager.ui.tvshows.filters.TvShowDatasourceFilter;
import org.tinymediamanager.ui.tvshows.filters.TvShowDateAddedFilter;
import org.tinymediamanager.ui.tvshows.filters.TvShowDecadeFilter;
import org.tinymediamanager.ui.tvshows.filters.TvShowDiscArtSizeFilter;
import org.tinymediamanager.ui.tvshows.filters.TvShowDuplicateEpisodesFilter;
import org.tinymediamanager.ui.tvshows.filters.TvShowEmptyFilter;
import org.tinymediamanager.ui.tvshows.filters.TvShowEpisodeCountFilter;
import org.tinymediamanager.ui.tvshows.filters.TvShowEpisodeCrc32Filter;
import org.tinymediamanager.ui.tvshows.filters.TvShowFanartSizeFilter;
import org.tinymediamanager.ui.tvshows.filters.TvShowFilenameFilter;
import org.tinymediamanager.ui.tvshows.filters.TvShowFrameRateFilter;
import org.tinymediamanager.ui.tvshows.filters.TvShowGenreFilter;
import org.tinymediamanager.ui.tvshows.filters.TvShowHDRFormatFilter;
import org.tinymediamanager.ui.tvshows.filters.TvShowKeyArtSizeFilter;
import org.tinymediamanager.ui.tvshows.filters.TvShowLockedFilter;
import org.tinymediamanager.ui.tvshows.filters.TvShowMediaFilesFilter;
import org.tinymediamanager.ui.tvshows.filters.TvShowMediaSourceFilter;
import org.tinymediamanager.ui.tvshows.filters.TvShowMissingArtworkFilter;
import org.tinymediamanager.ui.tvshows.filters.TvShowMissingEpisodesFilter;
import org.tinymediamanager.ui.tvshows.filters.TvShowMissingMetadataFilter;
import org.tinymediamanager.ui.tvshows.filters.TvShowMissingSubtitlesFilter;
import org.tinymediamanager.ui.tvshows.filters.TvShowNewEpisodesFilter;
import org.tinymediamanager.ui.tvshows.filters.TvShowNoteFilter;
import org.tinymediamanager.ui.tvshows.filters.TvShowPathFilter;
import org.tinymediamanager.ui.tvshows.filters.TvShowPosterSizeFilter;
import org.tinymediamanager.ui.tvshows.filters.TvShowRuntimeFilter;
import org.tinymediamanager.ui.tvshows.filters.TvShowSeasonCountFilter;
import org.tinymediamanager.ui.tvshows.filters.TvShowStatusFilter;
import org.tinymediamanager.ui.tvshows.filters.TvShowStudioFilter;
import org.tinymediamanager.ui.tvshows.filters.TvShowSubtitleCountFilter;
import org.tinymediamanager.ui.tvshows.filters.TvShowSubtitleFormatFilter;
import org.tinymediamanager.ui.tvshows.filters.TvShowSubtitleLanguageFilter;
import org.tinymediamanager.ui.tvshows.filters.TvShowSubtitleTypeFilter;
import org.tinymediamanager.ui.tvshows.filters.TvShowTagFilter;
import org.tinymediamanager.ui.tvshows.filters.TvShowThumbSizeFilter;
import org.tinymediamanager.ui.tvshows.filters.TvShowUncategorizedEpisodesFilter;
import org.tinymediamanager.ui.tvshows.filters.TvShowVideoBitdepthFilter;
import org.tinymediamanager.ui.tvshows.filters.TvShowVideoBitrateFilter;
import org.tinymediamanager.ui.tvshows.filters.TvShowVideoCodecFilter;
import org.tinymediamanager.ui.tvshows.filters.TvShowVideoContainerFilter;
import org.tinymediamanager.ui.tvshows.filters.TvShowVideoFilenameFilter;
import org.tinymediamanager.ui.tvshows.filters.TvShowVideoFilesizeFilter;
import org.tinymediamanager.ui.tvshows.filters.TvShowVideoFormatFilter;
import org.tinymediamanager.ui.tvshows.filters.TvShowWatchedFilter;
import org.tinymediamanager.ui.tvshows.filters.TvShowYearFilter;

public class TvShowFilterDialog
extends TmmDialog {
    private static final String PANEL_COL_CONSTRAINTS = "[][][][200lp:250lp,grow]";
    private final TmmTreeTable treeTable;
    private final Map<JPanel, Set<ITvShowUIFilter<?>>> filterMap;
    private final Set<ITvShowUIFilter<?>> filters;
    private final JTabbedPane tabbedPane;
    private JComboBox<String> cbPreset;

    public TvShowFilterDialog(TmmTreeTable treeTable) {
        super(TmmResourceBundle.getString("movieextendedsearch.options") + " - " + TmmResourceBundle.getString("tmm.tvshows"), "tvShowFilter");
        this.setModalityType(Dialog.ModalityType.MODELESS);
        this.treeTable = treeTable;
        this.filterMap = new HashMap();
        this.filters = new HashSet();
        this.treeTable.addPropertyChangeListener("filterChanged", evt -> this.filterChanged());
        ActionListener actionListener = e -> {
            String filterName = (String)this.cbPreset.getSelectedItem();
            if (StringUtils.isNotBlank((CharSequence)filterName)) {
                treeTable.setFilterValues(TvShowModuleManager.getInstance().getSettings().getUiFilterPresets().get(filterName));
                treeTable.storeFilters();
            } else {
                treeTable.clearFilter();
            }
        };
        this.tabbedPane = new TmmTabbedPane();
        this.getContentPane().add((Component)this.tabbedPane, "Center");
        JPanel panelMain = new JPanel((LayoutManager)new MigLayout("", PANEL_COL_CONSTRAINTS, "[]"));
        this.tabbedPane.addTab(TmmResourceBundle.getString("metatag.details"), this.createTabPanel(panelMain));
        this.addFilter(new TvShowNewEpisodesFilter(), panelMain);
        this.addFilter(new TvShowDatasourceFilter(), panelMain);
        this.addFilter(new TvShowWatchedFilter(), panelMain);
        this.addFilter(new TvShowLockedFilter(), panelMain);
        this.addFilter(new TvShowDateAddedFilter(), panelMain);
        this.addFilter(new TvShowDuplicateEpisodesFilter(), panelMain);
        this.addFilter(new TvShowStatusFilter(), panelMain);
        this.addFilter(new TvShowAllInOneFilter(), panelMain);
        this.addFilter(new TvShowEmptyFilter(), panelMain);
        JPanel panelMetadata = new JPanel((LayoutManager)new MigLayout("", PANEL_COL_CONSTRAINTS, "[]"));
        this.tabbedPane.addTab(TmmResourceBundle.getString("tmm.metadata"), this.createTabPanel(panelMetadata));
        this.addFilter(new TvShowYearFilter(), panelMetadata);
        this.addFilter(new TvShowDecadeFilter(), panelMetadata);
        this.addFilter(new TvShowGenreFilter(), panelMetadata);
        this.addFilter(new TvShowCertificationFilter(), panelMetadata);
        this.addFilter(new TvShowCastFilter(), panelMetadata);
        this.addFilter(new TvShowCountryFilter(), panelMetadata);
        this.addFilter(new TvShowStudioFilter(), panelMetadata);
        this.addFilter(new TvShowTagFilter(), panelMetadata);
        this.addFilter(new TvShowNoteFilter(), panelMetadata);
        this.addFilter(new TvShowEpisodeCountFilter(), panelMetadata);
        this.addFilter(new TvShowSeasonCountFilter(), panelMetadata);
        JPanel panelVideo = new JPanel((LayoutManager)new MigLayout("", PANEL_COL_CONSTRAINTS, "[]"));
        this.tabbedPane.addTab(TmmResourceBundle.getString("metatag.video"), this.createTabPanel(panelVideo));
        this.addFilter(new TvShowVideoFormatFilter(), panelVideo);
        this.addFilter(new TvShowVideoCodecFilter(), panelVideo);
        this.addFilter(new TvShowVideoBitrateFilter(), panelVideo);
        this.addFilter(new TvShowVideoBitdepthFilter(), panelVideo);
        this.addFilter(new TvShowVideoContainerFilter(), panelVideo);
        this.addFilter(new TvShowAspectRatioFilter(), panelVideo);
        this.addFilter(new TvShowFrameRateFilter(), panelVideo);
        this.addFilter(new TvShowHDRFormatFilter(), panelVideo);
        this.addFilter(new TvShowEpisodeCrc32Filter(), panelVideo);
        JPanel panelAudio = new JPanel((LayoutManager)new MigLayout("", PANEL_COL_CONSTRAINTS, "[]"));
        this.tabbedPane.addTab(TmmResourceBundle.getString("metatag.audio"), this.createTabPanel(panelAudio));
        this.addFilter(new TvShowAudioCodecFilter(), panelAudio);
        this.addFilter(new TvShowAudioChannelFilter(), panelAudio);
        this.addFilter(new TvShowAudioStreamCountFilter(), panelAudio);
        this.addFilter(new TvShowAudioLanguageFilter(), panelAudio);
        this.addFilter(new TvShowAudioTitleFilter(), panelAudio);
        JPanel panelArtwork = new JPanel((LayoutManager)new MigLayout("", PANEL_COL_CONSTRAINTS, "[]"));
        this.tabbedPane.addTab(TmmResourceBundle.getString("filter.artwork"), this.createTabPanel(panelArtwork));
        this.addFilter(new TvShowPosterSizeFilter(), panelArtwork);
        this.addFilter(new TvShowFanartSizeFilter(), panelArtwork);
        this.addFilter(new TvShowBannerSizeFilter(), panelArtwork);
        this.addFilter(new TvShowThumbSizeFilter(), panelArtwork);
        this.addFilter(new TvShowClearLogoSizeFilter(), panelArtwork);
        this.addFilter(new TvShowClearArtSizeFilter(), panelArtwork);
        this.addFilter(new TvShowDiscArtSizeFilter(), panelArtwork);
        this.addFilter(new TvShowKeyArtSizeFilter(), panelArtwork);
        this.addFilter(new TvShowMissingArtworkFilter(), panelArtwork);
        JPanel panelOthers = new JPanel((LayoutManager)new MigLayout("", PANEL_COL_CONSTRAINTS, "[]"));
        this.tabbedPane.addTab(TmmResourceBundle.getString("filter.others"), this.createTabPanel(panelOthers));
        this.addFilter(new TvShowMediaSourceFilter(), panelOthers);
        this.addFilter(new TvShowMediaFilesFilter(), panelOthers);
        this.addFilter(new TvShowFilenameFilter(), panelOthers);
        this.addFilter(new TvShowVideoFilenameFilter(), panelOthers);
        this.addFilter(new TvShowVideoFilesizeFilter(), panelOthers);
        this.addFilter(new TvShowRuntimeFilter(), panelOthers);
        this.addFilter(new TvShowPathFilter(), panelOthers);
        this.addFilter(new TvShowSubtitleCountFilter(), panelOthers);
        this.addFilter(new TvShowSubtitleLanguageFilter(), panelOthers);
        this.addFilter(new TvShowSubtitleFormatFilter(), panelOthers);
        this.addFilter(new TvShowSubtitleTypeFilter(), panelOthers);
        this.addFilter(new TvShowUncategorizedEpisodesFilter(), panelOthers);
        this.addFilter(new TvShowMissingEpisodesFilter(), panelOthers);
        this.addFilter(new TvShowMissingMetadataFilter(), panelOthers);
        this.addFilter(new TvShowMissingSubtitlesFilter(), panelOthers);
        JPanel panelFilterPreset = new JPanel();
        panelFilterPreset.setLayout((LayoutManager)new MigLayout("insets n 0 n 0", "[5lp!][10lp][150lp,grow][5lp!]", "[]"));
        JSeparator separator = new JSeparator();
        panelFilterPreset.add((Component)separator, "cell 0 1 4 1,growx,aligny top");
        TmmLabel lblEnableAllT = new TmmLabel(TmmResourceBundle.getString("filter.enableall"));
        panelFilterPreset.add((Component)lblEnableAllT, "cell 1 2, alignx trailing");
        JCheckBox chkbxEnableAll = new JCheckBox();
        chkbxEnableAll.setSelected(true);
        chkbxEnableAll.addActionListener(e -> treeTable.setFiltersActive(chkbxEnableAll.isSelected()));
        panelFilterPreset.add((Component)chkbxEnableAll, "cell 2 2");
        TmmLabel lblFilterPresetT = new TmmLabel(TmmResourceBundle.getString("filter.presets"));
        panelFilterPreset.add((Component)lblFilterPresetT, "cell 1 3, alignx trailing");
        this.cbPreset = new JComboBox();
        panelFilterPreset.add(this.cbPreset, "cell 2 3");
        FlatButton btnSavePreset = new FlatButton(IconManager.SAVE);
        btnSavePreset.setToolTipText(TmmResourceBundle.getString("filter.savepreset"));
        btnSavePreset.addActionListener(e -> {
            Set<AbstractSettings.UIFilters> activeUiFilters = this.getActiveUiFilters();
            if (!activeUiFilters.isEmpty()) {
                HashMap<String, List<AbstractSettings.UIFilters>> uiFilters = new HashMap<String, List<AbstractSettings.UIFilters>>(TvShowModuleManager.getInstance().getSettings().getUiFilterPresets());
                ModalPopupPanel popupPanel = this.createModalPopupPanel();
                popupPanel.setTitle(TmmResourceBundle.getString("filter.savepreset"));
                FilterSavePanel filterSavePanel = new FilterSavePanel(activeUiFilters, uiFilters);
                popupPanel.setOnCloseHandler(() -> {
                    String savedPreset = filterSavePanel.getSavedPreset();
                    if (StringUtils.isNotBlank((CharSequence)savedPreset)) {
                        this.cbPreset.removeActionListener(actionListener);
                        TvShowModuleManager.getInstance().getSettings().setUiFilterPresets(uiFilters);
                        TvShowModuleManager.getInstance().getSettings().saveSettings();
                        this.loadPresets();
                        this.cbPreset.setSelectedItem(savedPreset);
                        this.cbPreset.addActionListener(actionListener);
                    }
                });
                popupPanel.setContent(filterSavePanel);
                this.showModalPopupPanel(popupPanel);
            }
        });
        panelFilterPreset.add((Component)btnSavePreset, "cell 2 3");
        FlatButton btnDeletePreset = new FlatButton(IconManager.DELETE_GRAY);
        btnDeletePreset.setToolTipText(TmmResourceBundle.getString("filter.remove"));
        btnDeletePreset.addActionListener(e -> {
            HashMap<String, List<AbstractSettings.UIFilters>> tvShowUiFilters;
            String filterName = (String)this.cbPreset.getSelectedItem();
            if (StringUtils.isBlank((CharSequence)filterName)) {
                return;
            }
            if (!TmmProperties.getInstance().getPropertyAsBoolean("tvshow.hidefilterhint")) {
                JCheckBox checkBox = new JCheckBox(TmmResourceBundle.getString("tmm.donotshowagain"));
                TmmFontHelper.changeFont((JComponent)checkBox, 0.91667);
                checkBox.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
                Object[] options = new Object[]{TmmResourceBundle.getString("Button.yes"), TmmResourceBundle.getString("Button.no")};
                Object[] params = new Object[]{TmmResourceBundle.getString("filter.remove"), checkBox};
                int answer = JOptionPane.showOptionDialog(MainWindow.getInstance(), params, TmmResourceBundle.getString("filter.remove"), 0, 3, null, options, null);
                if (checkBox.isSelected()) {
                    TmmProperties.getInstance().putProperty("tvshow.hidefilterhint", String.valueOf(checkBox.isSelected()));
                }
                if (answer != 0) {
                    return;
                }
            }
            if ((tvShowUiFilters = new HashMap<String, List<AbstractSettings.UIFilters>>(TvShowModuleManager.getInstance().getSettings().getUiFilterPresets())).remove(filterName) != null) {
                this.cbPreset.removeActionListener(actionListener);
                TvShowModuleManager.getInstance().getSettings().setUiFilterPresets(tvShowUiFilters);
                TvShowModuleManager.getInstance().getSettings().saveSettings();
                this.loadPresets();
                this.cbPreset.addActionListener(actionListener);
            }
        });
        panelFilterPreset.add((Component)btnDeletePreset, "cell 2 3");
        this.getContentPane().add((Component)panelFilterPreset, "South");
        this.loadPresets();
        this.cbPreset.addActionListener(actionListener);
    }

    private JPanel createTabPanel(JPanel content) {
        JPanel panel = new JPanel((LayoutManager)new MigLayout("insets 0", "[grow][]", "[][][]"));
        panel.add((Component)new TmmLabel(TmmResourceBundle.getString("movieextendedsearch.filterby")), "cell 0 0");
        panel.add((Component)new JLabel(TmmResourceBundle.getString("filter.reset")), "cell 1 0, right");
        panel.add((Component)new FlatButton(IconManager.DELETE, e -> SwingUtilities.invokeLater(this.treeTable::clearFilter)), "cell 1 0, right");
        NoBorderScrollPane scrollPane = new NoBorderScrollPane(content);
        scrollPane.setHorizontalScrollBarPolicy(31);
        scrollPane.getVerticalScrollBar().setUnitIncrement(4);
        panel.add((Component)scrollPane, "cell 0 2 2 1, grow, wrap");
        return panel;
    }

    private Set<AbstractSettings.UIFilters> getActiveUiFilters() {
        return new HashSet<AbstractSettings.UIFilters>(ITvShowUIFilter.morphToUiFilters(this.filters));
    }

    private void loadPresets() {
        String preset = (String)this.cbPreset.getSelectedItem();
        this.cbPreset.removeAllItems();
        this.cbPreset.addItem("");
        TvShowModuleManager.getInstance().getSettings().getUiFilterPresets().keySet().stream().sorted().forEach(key -> this.cbPreset.addItem((String)key));
        if (StringUtils.isNotBlank((CharSequence)preset)) {
            this.cbPreset.setSelectedItem(preset);
        }
    }

    private void addFilter(ITvShowUIFilter<TmmTreeNode> filter, JPanel panel) {
        panel.add((Component)filter.getCheckBox(), "");
        panel.add((Component)filter.getLabel(), "");
        if (filter.getFilterOptionComboBox() != null) {
            panel.add(filter.getFilterOptionComboBox(), "");
        } else {
            panel.add(Box.createGlue(), "");
        }
        if (filter.getFilterComponent() != null) {
            panel.add((Component)filter.getFilterComponent(), "wmin 100, grow, wrap");
        } else {
            panel.add(Box.createGlue(), "wrap");
        }
        this.filterMap.computeIfAbsent(panel, k -> new HashSet()).add(filter);
        this.filters.add(filter);
        this.treeTable.addFilter(filter);
    }

    private void filterChanged() {
        block3: for (Map.Entry<JPanel, Set<ITvShowUIFilter<?>>> entry : this.filterMap.entrySet()) {
            boolean active = false;
            if (this.treeTable.isFiltersActive()) {
                for (ITvShowUIFilter<?> filter : entry.getValue()) {
                    switch (filter.getFilterState()) {
                        case ACTIVE: 
                        case ACTIVE_NEGATIVE: {
                            active = true;
                            break;
                        }
                    }
                    if (!active) continue;
                    break;
                }
            }
            for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
                if (!SwingUtilities.isDescendingFrom(entry.getKey(), this.tabbedPane.getComponentAt(i))) continue;
                if (active) {
                    this.tabbedPane.setIconAt(i, IconManager.FILTER_ACTIVE);
                    continue block3;
                }
                this.tabbedPane.setIconAt(i, null);
                continue block3;
            }
        }
    }

    @Override
    protected void initBottomPanel() {
    }
}

