/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.thetvdb;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.tinymediamanager.scraper.ArtworkSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaProviderInfo;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.NothingFoundException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.interfaces.IMediaArtworkProvider;
import org.tinymediamanager.scraper.thetvdb.TheTvDbMetadataProvider;
import org.tinymediamanager.scraper.thetvdb.entities.ArtworkBaseRecord;
import org.tinymediamanager.scraper.util.LanguageUtils;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.scraper.util.MediaIdUtil;

public abstract class TheTvDbArtworkProvider
extends TheTvDbMetadataProvider
implements IMediaArtworkProvider {
    @Override
    protected MediaProviderInfo createMediaProviderInfo() {
        MediaProviderInfo info = super.createMediaProviderInfo();
        info.getConfig().addText("apiKey", "", true);
        info.getConfig().addText("pin", "", true);
        info.getConfig().load();
        return info;
    }

    @Override
    public List<MediaArtwork> getArtwork(ArtworkSearchAndScrapeOptions options) throws ScrapeException {
        this.initAPI();
        this.getLogger().debug("getting artwork: {}", (Object)options);
        ArrayList<MediaArtwork> artwork = new ArrayList<MediaArtwork>();
        int id = options.getIdAsInt(this.getProviderInfo().getId());
        if (id == 0 && MediaIdUtil.isValidImdbId(options.getImdbId())) {
            id = this.getTvdbIdViaImdbId(options.getImdbId());
        }
        if (id == 0) {
            return Collections.emptyList();
        }
        List<ArtworkBaseRecord> images = null;
        try {
            images = this.fetchArtwork(id);
        }
        catch (MissingIdException | NothingFoundException e) {
            return Collections.emptyList();
        }
        catch (ScrapeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ScrapeException(e);
        }
        if (ListUtils.isEmpty(images)) {
            return artwork;
        }
        images.sort(new ImageComparator(LanguageUtils.getIso3Language(options.getLanguage().toLocale())));
        for (ArtworkBaseRecord image : images) {
            MediaArtwork ma = this.parseArtwork(image);
            if (ma == null || options.getArtworkType() != MediaArtwork.MediaArtworkType.ALL && options.getArtworkType() != ma.getType()) continue;
            artwork.add(ma);
        }
        return artwork;
    }

    protected abstract List<ArtworkBaseRecord> fetchArtwork(int var1) throws ScrapeException;

    protected static class ImageComparator
    implements Comparator<ArtworkBaseRecord> {
        private final String preferredLangu;
        private final String english;

        protected ImageComparator(String language) {
            this.preferredLangu = language;
            this.english = "eng";
        }

        @Override
        public int compare(ArtworkBaseRecord arg0, ArtworkBaseRecord arg1) {
            if (this.preferredLangu.equals(arg0.language) && !this.preferredLangu.equals(arg1.language)) {
                return -1;
            }
            if (!this.preferredLangu.equals(arg0.language) && this.preferredLangu.equals(arg1.language)) {
                return 1;
            }
            if (this.english.equals(arg0.language) && !this.english.equals(arg1.language)) {
                return -1;
            }
            if (!this.english.equals(arg0.language) && this.english.equals(arg1.language)) {
                return 1;
            }
            int result = 0;
            if (arg0.score != null && arg1.score != null) {
                result = Long.compare(arg1.score.intValue(), arg0.score.intValue());
            }
            if (result == 0) {
                result = Long.compare(arg0.id.intValue(), arg1.id.intValue());
            }
            return result;
        }
    }
}

