/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.moviesets.actions;

import java.awt.Cursor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.KeyStroke;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.moviesets.MovieSetUIModule;

public class MovieSetRemoveMovieFromSetAction
extends TmmAction {
    public MovieSetRemoveMovieFromSetAction() {
        this.putValue("Name", TmmResourceBundle.getString("movieset.movies.remove"));
        this.putValue("SwingLargeIconKey", IconManager.DELETE);
        this.putValue("SmallIcon", IconManager.DELETE);
        this.putValue("ShortDescription", TmmResourceBundle.getString("movieset.movies.remove"));
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(82, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx()));
    }

    @Override
    protected void processAction(ActionEvent e) {
        List<Movie> selectedMovies = MovieSetUIModule.getInstance().getSelectionModel().getSelectedMovies();
        if (selectedMovies.isEmpty()) {
            return;
        }
        MainWindow.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        for (Movie movie : selectedMovies) {
            movie.removeFromMovieSet();
            movie.writeNFO();
            movie.saveToDb();
        }
        MainWindow.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }
}

