/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.settings;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.swingbinding.JTableBinding;
import org.jdesktop.swingbinding.SwingBindings;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieSettings;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.ui.TableColumnResizer;
import org.tinymediamanager.ui.components.NoBorderScrollPane;
import org.tinymediamanager.ui.components.button.DocsButton;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.components.panel.CollapsiblePanel;
import org.tinymediamanager.ui.components.table.TmmTable;
import org.tinymediamanager.ui.components.textfield.ReadOnlyTextPane;
import org.tinymediamanager.ui.movies.MovieScraper;
import org.tinymediamanager.ui.panels.MediaScraperConfigurationPanel;
import org.tinymediamanager.ui.panels.ScrollablePanel;

class MovieScraperSettingsPanel
extends JPanel {
    private final MovieSettings settings = MovieModuleManager.getInstance().getSettings();
    private final List<MovieScraper> scrapers = new ArrayList<MovieScraper>();
    private JPanel panelScraperOptions;
    private JScrollPane scrollPaneScraperDetails;
    private JTextPane tpScraperDescription;
    private TmmTable tableScraper;

    MovieScraperSettingsPanel() {
        MediaScraper defaultMediaScraper = MovieModuleManager.getInstance().getMovieList().getDefaultMediaScraper();
        int selectedIndex = 0;
        for (MediaScraper mediaScraper : MovieModuleManager.getInstance().getMovieList().getAvailableMediaScrapers()) {
            MovieScraper movieScraper = new MovieScraper(mediaScraper);
            this.scrapers.add(movieScraper);
        }
        Collections.sort(this.scrapers);
        for (int i = 0; i < this.scrapers.size(); ++i) {
            MovieScraper movieScraper = this.scrapers.get(i);
            if (!movieScraper.getMediaScraper().equals(defaultMediaScraper)) continue;
            movieScraper.setDefaultScraper(true);
            selectedIndex = i;
            break;
        }
        this.initComponents();
        this.initDataBindings();
        Font font = UIManager.getFont("Label.font");
        Color color = UIManager.getColor("Label.foreground");
        String bodyRule = "body { font-family: " + font.getFamily() + "; font-size: " + font.getSize() + "pt; color: rgb(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + "); }";
        ((HTMLDocument)this.tpScraperDescription.getDocument()).getStyleSheet().addRule(bodyRule);
        TableColumnResizer.setMaxWidthForColumn(this.tableScraper, 0, 2);
        TableColumnResizer.setMaxWidthForColumn(this.tableScraper, 1, 10);
        TableColumnResizer.adjustColumnPreferredWidths(this.tableScraper, 5);
        this.tableScraper.getModel().addTableModelListener(arg0 -> {
            int row;
            MovieScraper changedScraper;
            if (arg0.getColumn() == 0 && (changedScraper = this.scrapers.get(row = arg0.getFirstRow())).getDefaultScraper().booleanValue()) {
                this.settings.setMovieScraper(changedScraper.getScraperId());
                for (MovieScraper scraper : this.scrapers) {
                    if (scraper == changedScraper) continue;
                    scraper.setDefaultScraper(Boolean.FALSE);
                }
            }
        });
        this.tableScraper.getSelectionModel().addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                return;
            }
            int index = this.tableScraper.convertRowIndexToModel(this.tableScraper.getSelectedRow());
            if (index > -1) {
                this.panelScraperOptions.removeAll();
                if (this.scrapers.get(index).getMediaProvider().getProviderInfo().getConfig().hasConfig()) {
                    this.panelScraperOptions.add((Component)new MediaScraperConfigurationPanel(this.scrapers.get(index).getMediaProvider()), "Center");
                }
                this.scrollPaneScraperDetails.revalidate();
                this.scrollPaneScraperDetails.repaint();
            }
        });
        if (!this.scrapers.isEmpty()) {
            this.tableScraper.getSelectionModel().setSelectionInterval(selectedIndex, selectedIndex);
        }
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("", "[grow]", "[400lp,grow]"));
        JPanel panelScraper = new JPanel((LayoutManager)new MigLayout("hidemode 1, insets 0", "[20lp!][grow]", "[][shrink 0][grow,fill]"));
        TmmLabel lblScraper = new TmmLabel(TmmResourceBundle.getString("scraper.metadata"), 1.16667);
        CollapsiblePanel collapsiblePanel = new CollapsiblePanel((JComponent)panelScraper, lblScraper, true);
        collapsiblePanel.addExtraTitleComponent(new DocsButton("/movies/settings#scraper"));
        this.add((Component)collapsiblePanel, "cell 0 0,wmin 0,grow");
        this.tableScraper = new TmmTable(){

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                Component comp = super.prepareRenderer(renderer, row, column);
                MovieScraper scraper = MovieScraperSettingsPanel.this.scrapers.get(row);
                comp.setEnabled(scraper.isEnabled());
                return comp;
            }
        };
        this.tableScraper.setRowHeight(29);
        this.tableScraper.setShowGrid(true);
        panelScraper.add((Component)this.tableScraper, "cell 1 0,grow");
        JSeparator separator = new JSeparator();
        panelScraper.add((Component)separator, "cell 1 1,growx");
        this.scrollPaneScraperDetails = new NoBorderScrollPane();
        panelScraper.add((Component)this.scrollPaneScraperDetails, "cell 1 2,grow");
        this.scrollPaneScraperDetails.setHorizontalScrollBarPolicy(31);
        this.scrollPaneScraperDetails.setVerticalScrollBarPolicy(20);
        ScrollablePanel panelScraperDetails = new ScrollablePanel();
        panelScraperDetails.setLayout((LayoutManager)new MigLayout("insets 0", "[400lp,grow]", "[][grow]"));
        this.scrollPaneScraperDetails.setViewportView(panelScraperDetails);
        this.tpScraperDescription = new ReadOnlyTextPane();
        this.tpScraperDescription.setEditorKit(new HTMLEditorKit());
        panelScraperDetails.add((Component)this.tpScraperDescription, "cell 0 0, growx, wmin 0");
        this.panelScraperOptions = new JPanel();
        this.panelScraperOptions.setLayout(new BorderLayout());
        panelScraperDetails.add((Component)this.panelScraperOptions, "cell 0 1,grow");
    }

    protected void initDataBindings() {
        JTableBinding jTableBinding = SwingBindings.createJTableBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, this.scrapers, (JTable)this.tableScraper);
        BeanProperty movieScraperBeanProperty = BeanProperty.create((String)"defaultScraper");
        jTableBinding.addColumnBinding((Property)movieScraperBeanProperty).setColumnName(TmmResourceBundle.getString("Settings.active")).setColumnClass(Boolean.class);
        BeanProperty movieScraperBeanProperty_1 = BeanProperty.create((String)"scraperLogo");
        jTableBinding.addColumnBinding((Property)movieScraperBeanProperty_1).setColumnName(TmmResourceBundle.getString("mediafiletype.logo")).setColumnClass(Icon.class).setEditable(false);
        BeanProperty movieScraperBeanProperty_2 = BeanProperty.create((String)"scraperName");
        jTableBinding.addColumnBinding((Property)movieScraperBeanProperty_2).setColumnName(TmmResourceBundle.getString("metatag.name")).setEditable(false);
        jTableBinding.bind();
        BeanProperty jTableBeanProperty = BeanProperty.create((String)"selectedElement.scraperDescription");
        BeanProperty jTextPaneBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding_12 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tableScraper, (Property)jTableBeanProperty, (Object)this.tpScraperDescription, (Property)jTextPaneBeanProperty);
        autoBinding_12.bind();
    }
}

