/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui;

import java.awt.Image;
import java.awt.Taskbar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.ui.MainWindow;

public class TmmTaskbar {
    private static final Logger LOGGER = LoggerFactory.getLogger(TmmTaskbar.class);
    private static final Taskbar TASKBAR = TmmTaskbar.initTaskbar();

    private TmmTaskbar() {
    }

    private static Taskbar initTaskbar() {
        if (Taskbar.isTaskbarSupported()) {
            return Taskbar.getTaskbar();
        }
        return null;
    }

    public static void setImage(Image image) {
        try {
            if (TASKBAR != null && TASKBAR.isSupported(Taskbar.Feature.ICON_IMAGE)) {
                TASKBAR.setIconImage(image);
            }
        }
        catch (Exception e) {
            LOGGER.debug("could not set taskbar image - {}", (Object)e.getMessage());
        }
    }

    public static void setBadge(String text) {
        try {
            if (TASKBAR != null && TASKBAR.isSupported(Taskbar.Feature.ICON_BADGE_TEXT)) {
                TASKBAR.setIconBadge(text);
            }
        }
        catch (Exception e) {
            LOGGER.debug("could not set taskbar badge - {}", (Object)e.getMessage());
        }
    }

    public static void setBadge(Image image) {
        try {
            if (TASKBAR != null && TASKBAR.isSupported(Taskbar.Feature.ICON_BADGE_IMAGE_WINDOW)) {
                TASKBAR.setWindowIconBadge(MainWindow.getInstance(), image);
            }
        }
        catch (Exception e) {
            LOGGER.debug("could not set taskbar badge - {}", (Object)e.getMessage());
        }
    }

    public static void requestUserAttention() {
        try {
            if (TASKBAR != null && TASKBAR.isSupported(Taskbar.Feature.USER_ATTENTION)) {
                TASKBAR.requestUserAttention(true, true);
            } else if (TASKBAR != null && TASKBAR.isSupported(Taskbar.Feature.USER_ATTENTION_WINDOW)) {
                TASKBAR.requestWindowUserAttention(MainWindow.getInstance());
            }
        }
        catch (Exception e) {
            LOGGER.debug("could not request user attention - {}", (Object)e.getMessage());
        }
    }

    public static void setProgressValue(int progress) {
        try {
            if (TASKBAR != null && TASKBAR.isSupported(Taskbar.Feature.PROGRESS_VALUE)) {
                TASKBAR.setProgressValue(progress);
            } else if (TASKBAR != null && TASKBAR.isSupported(Taskbar.Feature.PROGRESS_VALUE_WINDOW)) {
                TASKBAR.setWindowProgressValue(MainWindow.getInstance(), progress);
            }
        }
        catch (Exception e) {
            LOGGER.debug("could not set progress value - {}", (Object)e.getMessage());
        }
    }

    public static void setProgressState(Taskbar.State state) {
        try {
            if (TASKBAR != null && TASKBAR.isSupported(Taskbar.Feature.PROGRESS_STATE_WINDOW)) {
                TASKBAR.setWindowProgressState(MainWindow.getInstance(), state);
            }
        }
        catch (Exception e) {
            LOGGER.debug("could not set progress state - {}", (Object)e.getMessage());
        }
    }
}

