/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.SwingPropertyChangeSupport;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.ui.ITmmUIFilter;
import org.tinymediamanager.ui.components.button.TriStateCheckBox;

public abstract class AbstractTmmUIFilter<E>
implements ITmmUIFilter<E> {
    protected static ObjectMapper objectMapper = new ObjectMapper();
    protected final TriStateCheckBox checkBox;
    protected final JLabel label;
    protected final JComboBox<ITmmUIFilter.FilterOption> cbOption;
    protected final JComponent filterComponent;
    protected final ActionListener checkBoxActionListener;
    protected final ActionListener filterComponentActionListener;
    protected final ChangeListener changeListener;
    protected final PropertyChangeSupport propertyChangeSupport = new SwingPropertyChangeSupport(this, true);

    public AbstractTmmUIFilter() {
        this.checkBoxActionListener = e -> this.filterChanged();
        this.filterComponentActionListener = e -> {
            if (this.getFilterState() != ITmmUIFilter.FilterState.INACTIVE) {
                this.filterChanged();
            }
        };
        this.changeListener = e -> {
            if (this.getFilterState() != ITmmUIFilter.FilterState.INACTIVE) {
                this.filterChanged();
            }
        };
        this.checkBox = new TriStateCheckBox();
        this.checkBox.setToolTipText(TmmResourceBundle.getString("filter.hint"));
        this.label = this.createLabel();
        this.filterComponent = this.createFilterComponent();
        this.cbOption = this.createOptionComboBox();
        if (this.cbOption != null) {
            this.cbOption.addActionListener(this.filterComponentActionListener);
        }
        this.checkBox.addActionListener(this.checkBoxActionListener);
        JComponent jComponent = this.filterComponent;
        if (jComponent instanceof JTextComponent) {
            JTextComponent textComponent = (JTextComponent)jComponent;
            textComponent.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void removeUpdate(DocumentEvent e) {
                    if (AbstractTmmUIFilter.this.getFilterState() != ITmmUIFilter.FilterState.INACTIVE) {
                        AbstractTmmUIFilter.this.filterChanged();
                    }
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    if (AbstractTmmUIFilter.this.getFilterState() != ITmmUIFilter.FilterState.INACTIVE) {
                        AbstractTmmUIFilter.this.filterChanged();
                    }
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    if (AbstractTmmUIFilter.this.getFilterState() != ITmmUIFilter.FilterState.INACTIVE) {
                        AbstractTmmUIFilter.this.filterChanged();
                    }
                }
            });
        } else {
            jComponent = this.filterComponent;
            if (jComponent instanceof AbstractButton) {
                AbstractButton abstractButton = (AbstractButton)jComponent;
                abstractButton.addActionListener(this.filterComponentActionListener);
            } else if (this.filterComponent instanceof JComboBox) {
                ((JComboBox)this.filterComponent).addActionListener(this.filterComponentActionListener);
            } else {
                jComponent = this.filterComponent;
                if (jComponent instanceof JSpinner) {
                    JSpinner jSpinner = (JSpinner)jComponent;
                    jSpinner.addChangeListener(this.changeListener);
                }
            }
        }
    }

    @Override
    public JCheckBox getCheckBox() {
        return this.checkBox;
    }

    @Override
    public JLabel getLabel() {
        return this.label;
    }

    @Override
    public JComponent getFilterComponent() {
        return this.filterComponent;
    }

    protected abstract JLabel createLabel();

    protected JComboBox<ITmmUIFilter.FilterOption> createOptionComboBox() {
        return null;
    }

    @Override
    public JComboBox<ITmmUIFilter.FilterOption> getFilterOptionComboBox() {
        return this.cbOption;
    }

    protected abstract JComponent createFilterComponent();

    @Override
    public ITmmUIFilter.FilterState getFilterState() {
        if (this.checkBox.isMixed()) {
            return ITmmUIFilter.FilterState.ACTIVE_NEGATIVE;
        }
        if (!this.checkBox.isMixed() && this.checkBox.isSelected()) {
            return ITmmUIFilter.FilterState.ACTIVE;
        }
        return ITmmUIFilter.FilterState.INACTIVE;
    }

    @Override
    public void setFilterState(ITmmUIFilter.FilterState state) {
        switch (state) {
            case ACTIVE: {
                this.checkBox.setSelected(true);
                break;
            }
            case ACTIVE_NEGATIVE: {
                this.checkBox.setMixed(true);
                break;
            }
            case INACTIVE: {
                this.checkBox.setSelected(false);
            }
        }
    }

    @Override
    @NotNull
    public ITmmUIFilter.FilterOption getFilterOption() {
        Object selectedItem;
        if (this.cbOption != null && (selectedItem = this.cbOption.getSelectedItem()) instanceof ITmmUIFilter.FilterOption) {
            ITmmUIFilter.FilterOption filterOption = (ITmmUIFilter.FilterOption)((Object)selectedItem);
            return filterOption;
        }
        return ITmmUIFilter.FilterOption.EQ;
    }

    @Override
    public void setFilterOption(@NotNull ITmmUIFilter.FilterOption filterOption) {
        if (this.cbOption != null) {
            this.cbOption.setSelectedItem((Object)filterOption);
        }
    }

    protected void filterChanged() {
        SwingUtilities.invokeLater(() -> this.firePropertyChange("filterChanged", false, true));
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    protected void firePropertyChange(PropertyChangeEvent evt) {
        this.propertyChangeSupport.firePropertyChange(evt);
    }
}

