/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.trakt;

import com.uwetrottmann.trakt5.TraktV2;
import com.uwetrottmann.trakt5.TraktV2Interceptor;
import com.uwetrottmann.trakt5.entities.SearchResult;
import com.uwetrottmann.trakt5.entities.TraktError;
import com.uwetrottmann.trakt5.enums.Extended;
import com.uwetrottmann.trakt5.enums.IdType;
import com.uwetrottmann.trakt5.enums.Type;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.tinymediamanager.core.FeatureNotEnabledException;
import org.tinymediamanager.scraper.MediaProviderInfo;
import org.tinymediamanager.scraper.MediaSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.exceptions.HttpException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.http.TmmHttpClient;
import org.tinymediamanager.scraper.interfaces.IMediaProvider;
import org.tinymediamanager.scraper.trakt.TraktUtils;
import org.tinymediamanager.scraper.util.MediaIdUtil;
import retrofit2.Call;
import retrofit2.Response;

abstract class TraktMetadataProvider
implements IMediaProvider {
    static final String ID = "trakt";
    private final MediaProviderInfo providerInfo = this.createMediaProviderInfo();
    protected TraktV2 api;

    TraktMetadataProvider() {
    }

    protected abstract String getSubId();

    protected MediaProviderInfo createMediaProviderInfo() {
        MediaProviderInfo info = new MediaProviderInfo(ID, this.getSubId(), "Trakt.tv", "<html><h3>Trakt.tv</h3><br />Trakt.tv is a platform that does many things, but primarily keeps track of TV shows and movies you watch. It also provides meta data for movies and TV shows<br /><br />Available languages: EN</html>", TraktMetadataProvider.class.getResource("/org/tinymediamanager/scraper/trakt_tv.svg"), 10);
        info.getConfig().addText("clientId", "", true);
        info.getConfig().load();
        return info;
    }

    @Override
    public MediaProviderInfo getProviderInfo() {
        return this.providerInfo;
    }

    @Override
    public boolean isActive() {
        return this.isFeatureEnabled() && this.isApiKeyAvailable(this.providerInfo.getUserApiKey());
    }

    protected abstract Logger getLogger();

    protected synchronized void initAPI() throws ScrapeException {
        String userApiKey;
        if (this.api == null) {
            if (!this.isActive()) {
                throw new ScrapeException(new FeatureNotEnabledException(this));
            }
            try {
                this.api = new TraktV2(this.getApiKey()){

                    protected synchronized OkHttpClient okHttpClient() {
                        OkHttpClient.Builder builder = TmmHttpClient.newBuilderWithForcedCache(15, TimeUnit.MINUTES);
                        builder.addInterceptor((Interceptor)new TraktV2Interceptor((TraktV2)this));
                        return builder.build();
                    }
                };
            }
            catch (Exception e) {
                this.getLogger().error("could not initialize the API: {}", (Object)e.getMessage());
                this.api = null;
                throw new ScrapeException(e);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(userApiKey = this.providerInfo.getUserApiKey()))) {
            this.api.apiKey(userApiKey);
        }
        if (StringUtils.isBlank((CharSequence)userApiKey)) {
            this.api.apiKey(this.getApiKey());
        }
    }

    protected <T> T executeCall(Call<T> call) throws IOException {
        Response response = call.execute();
        if (!response.isSuccessful() && response.code() == 401) {
            this.api.refreshToken();
            response = call.execute();
        }
        if (!response.isSuccessful()) {
            String message = "Request failed: " + response.code() + " " + response.message();
            TraktError error = this.api.checkForTraktError(response);
            if (error != null && error.message != null) {
                message = message + " message: " + error.message;
            }
            throw new HttpException(response.code(), message);
        }
        Object body = response.body();
        if (body != null) {
            return (T)body;
        }
        throw new IOException("Body should not be null for successful response");
    }

    public List<MediaSearchResult> lookupWithId(MediaSearchAndScrapeOptions options) throws ScrapeException {
        String imdbId;
        List<SearchResult> results = new ArrayList<SearchResult>();
        String string = imdbId = options.getImdbId().isEmpty() ? null : options.getImdbId();
        if (MediaIdUtil.isValidImdbId(options.getSearchQuery())) {
            imdbId = options.getSearchQuery();
        }
        String traktId = options.getIdAsString(this.providerInfo.getId());
        String tmdbId = options.getIdAsString("tmdb");
        String tvdbId = options.getIdAsString("tvdb");
        String tvrageId = options.getIdAsString("tvrage");
        Type type = null;
        switch (options.getMediaType()) {
            case MOVIE: {
                type = Type.MOVIE;
                break;
            }
            case TV_SHOW: {
                type = Type.SHOW;
                break;
            }
            case TV_EPISODE: {
                type = Type.EPISODE;
                break;
            }
        }
        results = this.lookupWithId(results, IdType.TRAKT, traktId, type);
        results = this.lookupWithId(results, IdType.IMDB, imdbId, type);
        results = this.lookupWithId(results, IdType.TMDB, tmdbId, type);
        results = this.lookupWithId(results, IdType.TVDB, tvdbId, type);
        results = this.lookupWithId(results, IdType.TVRAGE, tvrageId, type);
        ArrayList<MediaSearchResult> msr = new ArrayList<MediaSearchResult>();
        for (SearchResult sr : results) {
            MediaSearchResult m = TraktUtils.morphTraktResultToTmmResult(options, sr);
            m.setScore(1.0f);
            msr.add(m);
        }
        return msr;
    }

    private List<SearchResult> lookupWithId(List<SearchResult> results, IdType id, String value, Type type) throws ScrapeException {
        this.initAPI();
        if (results.isEmpty() && value != null) {
            this.getLogger().debug("found {} id {} - direct lookup", (Object)id, (Object)value);
            try {
                Response response = this.api.search().idLookup(id, value, type, Extended.FULL, Integer.valueOf(1), Integer.valueOf(25)).execute();
                if (!response.isSuccessful()) {
                    this.getLogger().warn("request was NOT successful: HTTP/{} - {}", (Object)response.code(), (Object)response.message());
                    return results;
                }
                results = (List)response.body();
                this.getLogger().debug("Found {} result with ID lookup", (Object)results.size());
            }
            catch (Exception e) {
                this.getLogger().warn("request was NOT successful: {}", (Object)e.getMessage());
            }
        }
        return results;
    }
}

