/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.library.bluray.movieobject;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import org.tinymediamanager.library.bluray.movieobject.MovieObjectFile;
import org.tinymediamanager.library.bluray.movieobject.MovieObjectReader;
import org.tinymediamanager.library.bluray.movieobject.MovieObjectWriter;

public class Main {
    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 2) {
            System.out.println("Missing input and output arguments");
            Main.usage();
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        if (!string.toLowerCase().endsWith(".xml") && !string.toLowerCase().endsWith(".bdmv") || !string2.toLowerCase().endsWith(".xml") && !string2.toLowerCase().endsWith(".bdmv")) {
            System.out.println("Input and output can only have xml or bdmv extension.");
            Main.usage();
        }
        if (!new File(string).exists()) {
            System.out.println("File " + string + " not found.");
            Main.usage();
        }
        MovieObjectFile movieObjectFile = null;
        FileInputStream fileInputStream = new FileInputStream(string);
        DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(fileInputStream));
        movieObjectFile = string.toLowerCase().endsWith("xml") ? new MovieObjectReader().readXml(dataInputStream) : new MovieObjectReader().readBinary(dataInputStream);
        dataInputStream.close();
        FileOutputStream fileOutputStream = new FileOutputStream(string2);
        DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(fileOutputStream));
        if (string2.toLowerCase().endsWith("xml")) {
            new MovieObjectWriter().writeXml(movieObjectFile, dataOutputStream);
        } else {
            new MovieObjectWriter().writeBinary(movieObjectFile, dataOutputStream);
        }
        dataOutputStream.close();
    }

    public static void usage() {
        System.out.println("\n\nThis is a tool to convert MovieObject.bdmv to an xml format and back.\n\n");
        System.out.println("Usage:");
        System.out.println("\n" + Main.class.getName() + " Input Output \n");
        System.out.println("where Input can be one of");
        System.out.println("   location of MovieObject.bdmv");
        System.out.println("   location of MovieObject.xml");
        System.out.println("and the Output can be one of");
        System.out.println("   MovieObject.bdmv");
        System.out.println("   MovieObject.xml");
        System.exit(1);
    }
}

