/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.plaf;

import com.formdev.flatlaf.ui.FlatViewportUI;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ViewportUI;
import javax.swing.table.TableColumn;

public class TmmViewportUI
extends FlatViewportUI {
    private static ViewportUI viewportUI;
    private boolean paintTmmGrid;
    private Color gridColor;
    private Color gridColor2;

    public static ComponentUI createUI(JComponent c) {
        if (viewportUI == null) {
            viewportUI = new TmmViewportUI();
        }
        return viewportUI;
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        this.paintTmmGrid = UIManager.getBoolean("Table.paintTmmGrid");
        if (this.paintTmmGrid) {
            this.gridColor = UIManager.getColor("Table.gridColor");
            this.gridColor2 = UIManager.getColor("Table.gridColor2");
        }
    }

    public void paint(Graphics g, JComponent c) {
        super.paint(g, c);
        if (this.paintTmmGrid) {
            JViewport viewport = (JViewport)c;
            JTable table = null;
            if (viewport.getView() instanceof JTable) {
                table = (JTable)((JViewport)c).getView();
            }
            if (table != null) {
                this.paintVerticalGridLines(g, c, table);
                this.paintHorizontalGridLines(g, c, table);
            }
        }
    }

    private void paintVerticalGridLines(Graphics g, JComponent c, JTable fTable) {
        JViewport viewport = (JViewport)c;
        int offset = viewport.getViewPosition().x;
        int x = -offset;
        for (int i = 0; i < fTable.getColumnCount() - 1; ++i) {
            TableColumn column = fTable.getColumnModel().getColumn(i);
            if ((x += column.getWidth()) < 0) continue;
            g.setColor(this.gridColor);
            g.drawLine(x - 1, 0, x - 1, viewport.getHeight());
        }
    }

    private void paintHorizontalGridLines(Graphics g, JComponent c, JTable fTable) {
        JViewport viewport = (JViewport)c;
        Point viewPosition = viewport.getViewPosition();
        g.translate(0, -viewPosition.y);
        int rowAtPoint = fTable.rowAtPoint(g.getClipBounds().getLocation());
        int topY = rowAtPoint < 0 ? g.getClipBounds().y : fTable.getCellRect((int)rowAtPoint, (int)0, (boolean)true).y;
        int currentRow = Math.max(rowAtPoint, 0);
        int viewPortWidth = viewport.getWidth();
        int defaultRowHeight = fTable.getRowHeight();
        while (topY < g.getClipBounds().y + g.getClipBounds().height) {
            int rowHeight = fTable.getRowHeight(currentRow);
            if (rowHeight <= 0) {
                rowHeight = defaultRowHeight;
            }
            int bottomY = topY + rowHeight;
            g.setColor(this.gridColor);
            g.drawLine(5, bottomY - 1, viewPortWidth, bottomY - 1);
            g.setColor(this.gridColor2);
            g.drawLine(5, bottomY, viewPortWidth, bottomY);
            topY = bottomY;
            ++currentRow;
        }
        g.translate(0, viewPosition.y);
    }
}

