/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.thesportsdb;

import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.scraper.thesportsdb.entities.League;
import org.tinymediamanager.scraper.thesportsdb.entities.Leagues;

public class TheSportsDbHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(TheSportsDbHelper.class);
    public static final Map<String, League> SPORT_LEAGUES = TheSportsDbHelper.loadLeagues();

    private static synchronized Map<String, League> loadLeagues() {
        HashMap<String, League> ret = new HashMap<String, League>();
        try {
            InputStream is = TheSportsDbHelper.class.getResourceAsStream("/org/tinymediamanager/scraper/TSDB_all_leagues.php.json");
            JsonReader reader = new JsonReader((Reader)new InputStreamReader(is));
            Leagues loaded = (Leagues)new Gson().fromJson(reader, Leagues.class);
            loaded.leagues.forEach(league -> {
                ret.put(league.strLeague, (League)league);
                if (league.strLeagueAlternate != null) {
                    String[] alt;
                    for (String a : alt = league.strLeagueAlternate.split("\\s*,\\s*")) {
                        if (a.isEmpty()) continue;
                        ret.put(a, (League)league);
                    }
                }
            });
            return ret;
        }
        catch (Exception e) {
            LOGGER.debug("Could not load leagues from json file: '{}'", (Object)e.getMessage());
            return Collections.emptyMap();
        }
    }
}

