/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.support.model.item;

import java.util.Arrays;
import java.util.List;
import org.jupnp.support.model.DIDLObject;
import org.jupnp.support.model.Person;
import org.jupnp.support.model.Res;
import org.jupnp.support.model.StorageMedium;
import org.jupnp.support.model.container.Container;
import org.jupnp.support.model.item.Item;

public class ImageItem
extends Item {
    public static final DIDLObject.Class CLASS = new DIDLObject.Class("object.item.imageItem");

    public ImageItem() {
        this.setClazz(CLASS);
    }

    public ImageItem(Item other) {
        super(other);
    }

    public ImageItem(String id, Container parent, String title, String creator, Res ... resource) {
        this(id, parent.getId(), title, creator, resource);
    }

    public ImageItem(String id, String parentID, String title, String creator, Res ... resource) {
        super(id, parentID, title, creator, CLASS);
        if (resource != null) {
            this.getResources().addAll(Arrays.asList(resource));
        }
    }

    public String getDescription() {
        return (String)this.getFirstPropertyValue(DIDLObject.Property.DC.DESCRIPTION.class);
    }

    public ImageItem setDescription(String description) {
        this.replaceFirstProperty(new DIDLObject.Property.DC.DESCRIPTION(description));
        return this;
    }

    public String getLongDescription() {
        return (String)this.getFirstPropertyValue(DIDLObject.Property.UPNP.LONG_DESCRIPTION.class);
    }

    public ImageItem setLongDescription(String description) {
        this.replaceFirstProperty(new DIDLObject.Property.UPNP.LONG_DESCRIPTION(description));
        return this;
    }

    public Person getFirstPublisher() {
        return (Person)this.getFirstPropertyValue(DIDLObject.Property.DC.PUBLISHER.class);
    }

    public Person[] getPublishers() {
        List list = this.getPropertyValues(DIDLObject.Property.DC.PUBLISHER.class);
        return list.toArray(new Person[list.size()]);
    }

    public ImageItem setPublishers(Person[] publishers) {
        this.removeProperties(DIDLObject.Property.DC.PUBLISHER.class);
        for (Person publisher : publishers) {
            this.addProperty(new DIDLObject.Property.DC.PUBLISHER(publisher));
        }
        return this;
    }

    public StorageMedium getStorageMedium() {
        return (StorageMedium)((Object)this.getFirstPropertyValue(DIDLObject.Property.UPNP.STORAGE_MEDIUM.class));
    }

    public ImageItem setStorageMedium(StorageMedium storageMedium) {
        this.replaceFirstProperty(new DIDLObject.Property.UPNP.STORAGE_MEDIUM(storageMedium));
        return this;
    }

    public String getRating() {
        return (String)this.getFirstPropertyValue(DIDLObject.Property.UPNP.RATING.class);
    }

    public ImageItem setRating(String rating) {
        this.replaceFirstProperty(new DIDLObject.Property.UPNP.RATING(rating));
        return this;
    }

    public String getDate() {
        return (String)this.getFirstPropertyValue(DIDLObject.Property.DC.DATE.class);
    }

    public ImageItem setDate(String date) {
        this.replaceFirstProperty(new DIDLObject.Property.DC.DATE(date));
        return this;
    }

    public String getFirstRights() {
        return (String)this.getFirstPropertyValue(DIDLObject.Property.DC.RIGHTS.class);
    }

    public String[] getRights() {
        List list = this.getPropertyValues(DIDLObject.Property.DC.RIGHTS.class);
        return list.toArray(new String[list.size()]);
    }

    public ImageItem setRights(String[] rights) {
        this.removeProperties(DIDLObject.Property.DC.RIGHTS.class);
        for (String right : rights) {
            this.addProperty(new DIDLObject.Property.DC.RIGHTS(right));
        }
        return this;
    }
}

