/*
 * Decompiled with CFR 0.152.
 */
package io.github.jacksonbrienen.jwfd;

import io.github.jacksonbrienen.jwfd.JNIException;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;

final class WindowsFileDialog {
    static final boolean IS_WINDOWS;

    private WindowsFileDialog() {
    }

    private static boolean loadLibraries() {
        Path dllPath;
        URL dllLocal;
        block41: {
            String title;
            switch (System.getProperty("sun.arch.data.model")) {
                case "32": {
                    dllLocal = WindowsFileDialog.class.getResource("/io/github/jacksonbrienen/jwfd/natives/jwfd_Win32.dll");
                    title = "jwfd_Win32.dll";
                    break;
                }
                case "64": {
                    dllLocal = WindowsFileDialog.class.getResource("/io/github/jacksonbrienen/jwfd/natives/jwfd_x64.dll");
                    title = "jwfd_x64.dll";
                    break;
                }
                default: {
                    return false;
                }
            }
            dllPath = Paths.get(System.getProperty("java.io.tmpdir"), "/", title);
            if (Files.exists(dllPath, new LinkOption[0])) {
                try {
                    System.load(dllPath.toString());
                    return true;
                }
                catch (Exception e) {
                    if (dllPath.toFile().delete()) break block41;
                    return false;
                }
            }
        }
        try {
            Files.createFile(dllPath, new FileAttribute[0]);
        }
        catch (IOException n) {
            return false;
        }
        File dllFile = dllPath.toFile();
        try (InputStream dllIn = dllLocal.openStream();
             OutputStream dllOut = Files.newOutputStream(dllPath, new OpenOption[0]);){
            int bytesRead;
            byte[] buffer = new byte[4096];
            while ((bytesRead = dllIn.read(buffer)) != -1) {
                dllOut.write(buffer, 0, bytesRead);
            }
        }
        catch (IOException e) {
            if (!dllFile.delete()) {
                dllFile.deleteOnExit();
            }
            return false;
        }
        System.load(dllFile.getAbsolutePath());
        return true;
    }

    private static native boolean initAWT();

    private static boolean safeInitAWT() {
        boolean b = false;
        try {
            b = WindowsFileDialog.initAWT();
        }
        catch (Exception | UnsatisfiedLinkError e) {
            return false;
        }
        return b;
    }

    private static native String openFileDialog0(Frame var0, String var1, String var2, String var3) throws JNIException, UnsatisfiedLinkError;

    static String openFileDialog(Frame frame, String title, String path, String filters) throws JNIException, UnsatisfiedLinkError {
        frame = WindowsFileDialog.validateFrame(frame);
        title = WindowsFileDialog.validateTitle(title);
        path = WindowsFileDialog.validatePath(path);
        return WindowsFileDialog.openFileDialog0(frame, title, path, filters);
    }

    private static native String openSaveDialog0(Frame var0, String var1, String var2, String var3) throws JNIException, UnsatisfiedLinkError;

    static String openSaveDialog(Frame frame, String title, String path, String filters) throws JNIException, UnsatisfiedLinkError {
        frame = WindowsFileDialog.validateFrame(frame);
        title = WindowsFileDialog.validateTitle(title);
        path = WindowsFileDialog.validatePath(path);
        return WindowsFileDialog.openSaveDialog0(frame, title, path, filters);
    }

    private static native String[] openMultipleDialog0(Frame var0, String var1, String var2, String var3) throws JNIException, UnsatisfiedLinkError;

    static String[] openMultipleDialog(Frame frame, String title, String path, String filters) throws JNIException, UnsatisfiedLinkError {
        frame = WindowsFileDialog.validateFrame(frame);
        title = WindowsFileDialog.validateTitle(title);
        path = WindowsFileDialog.validatePath(path);
        return WindowsFileDialog.openMultipleDialog0(frame, title, path, filters);
    }

    private static native String openDirDialog0(Frame var0, String var1, String var2) throws JNIException, UnsatisfiedLinkError;

    static String openDirDialog(Frame frame, String title, String path) throws JNIException, UnsatisfiedLinkError {
        frame = WindowsFileDialog.validateFrame(frame);
        title = WindowsFileDialog.validateTitle(title);
        path = WindowsFileDialog.validatePath(path);
        return WindowsFileDialog.openDirDialog0(frame, title, path);
    }

    private static Frame validateFrame(Frame frame) {
        if (frame == null || !frame.isVisible()) {
            return null;
        }
        return frame;
    }

    private static String validateTitle(String title) {
        if (title == null) {
            return "";
        }
        return title;
    }

    private static String validatePath(String path) {
        File fpath;
        if (path == null || !(fpath = new File(path)).exists()) {
            return System.getProperty("user.home");
        }
        if (!fpath.isDirectory()) {
            return fpath.getParentFile().getAbsolutePath();
        }
        return fpath.getAbsolutePath();
    }

    static {
        String os = System.getProperty("os.name");
        if (os.contains("Windows") && !os.contains("Windows 2000") && !os.contains("Windows XP") && !os.contains("Windows Server 2003")) {
            new Frame().dispose();
            try {
                System.loadLibrary("jawt");
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                // empty catch block
            }
            IS_WINDOWS = WindowsFileDialog.loadLibraries() && WindowsFileDialog.safeInitAWT();
        } else {
            IS_WINDOWS = false;
        }
    }
}

