/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.plaf;

import com.formdev.flatlaf.ui.FlatScrollBarUI;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import org.tinymediamanager.ui.components.table.TmmTable;

public class TmmScrollBarUI
extends FlatScrollBarUI {
    private int width;
    private int thumbWidth;
    private int gap;
    private Color borderColor;

    public static ComponentUI createUI(JComponent c) {
        return new TmmScrollBarUI();
    }

    protected void installDefaults() {
        super.installDefaults();
        this.width = UIManager.getInt("ScrollBar.width");
        this.thumbWidth = UIManager.getInt("ScrollBar.thumbWidth");
        if (this.thumbWidth == 0) {
            this.thumbWidth = this.width / 2;
        }
        this.gap = UIManager.getInt("ScrollBar.gap");
        this.borderColor = UIManager.getColor("Component.borderColor");
    }

    protected void layoutVScrollbar(JScrollBar sb) {
        super.layoutVScrollbar(sb);
        if (sb.getValue() == 0) {
            this.thumbRect.setBounds(this.thumbRect.x, -1 + this.gap, this.thumbRect.width, this.thumbRect.height - 2 * this.gap);
        } else {
            this.thumbRect.setBounds(this.thumbRect.x, this.thumbRect.y + this.gap, this.thumbRect.width, this.thumbRect.height - 2 * this.gap);
        }
        this.trackRect.setBounds(this.trackRect.x, this.trackRect.y + this.gap, this.trackRect.width, this.trackRect.height - 2 * this.gap);
    }

    protected void layoutHScrollbar(JScrollBar sb) {
        super.layoutHScrollbar(sb);
        this.trackRect.setBounds(this.trackRect.x + this.gap, this.trackRect.y, this.trackRect.width - 2 * this.gap, this.trackRect.height);
        this.thumbRect.setBounds(this.thumbRect.x + this.gap, this.thumbRect.y, this.thumbRect.width - 2 * this.gap, this.thumbRect.height);
    }

    protected void paintTrack(Graphics g, JComponent c, Rectangle trackBounds) {
        if (this.getThumbBounds().isEmpty()) {
            return;
        }
        g.setColor(this.trackColor);
        if (this.scrollbar.isEnabled()) {
            if (this.scrollbar.getOrientation() == 1) {
                int x = (this.width - this.thumbWidth) / 2;
                g.fillRoundRect(trackBounds.x + x, trackBounds.y, this.thumbWidth, trackBounds.height, this.thumbWidth, this.thumbWidth);
            } else {
                int y = (this.width - this.thumbWidth) / 2;
                g.fillRoundRect(trackBounds.x, trackBounds.y + y, trackBounds.width, this.thumbWidth, this.thumbWidth, this.thumbWidth);
            }
        }
        if (c.getParent() instanceof JScrollPane && (((JScrollPane)c.getParent()).getBorder() != null || ((JScrollPane)c.getParent()).getViewport().getView() instanceof TmmTable)) {
            g.setColor(this.borderColor);
            if (this.scrollbar.getOrientation() == 1) {
                g.drawLine(0, 0, 0, c.getHeight());
            } else {
                g.drawLine(0, 0, c.getWidth(), 0);
            }
        }
    }

    protected void paintThumb(Graphics g, JComponent c, Rectangle thumbBounds) {
        if (!c.isEnabled()) {
            return;
        }
        if (thumbBounds.isEmpty() || !this.scrollbar.isEnabled()) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g.setColor(this.thumbColor);
        g.translate(thumbBounds.x, thumbBounds.y);
        if (this.scrollbar.getOrientation() == 1) {
            int x = (this.width - this.thumbWidth) / 2;
            g.fillRoundRect(x + 1, 2, this.thumbWidth - 2, thumbBounds.height - 4, this.thumbWidth - 2, this.thumbWidth - 2);
        } else {
            int y = (this.width - this.thumbWidth) / 2;
            g.fillRoundRect(2, y + 1, thumbBounds.width - 4, this.thumbWidth - 2, this.thumbWidth - 2, this.thumbWidth - 2);
        }
    }

    protected Dimension getMinimumThumbSize() {
        if (this.scrollbar.getOrientation() == 1) {
            return new Dimension(this.thumbWidth - 2, this.width * 2);
        }
        return new Dimension(this.width * 2, this.thumbWidth - 2);
    }

    protected Dimension getMaximumThumbSize() {
        if (this.scrollbar.getOrientation() == 1) {
            return new Dimension(this.thumbWidth - 2, this.width * 3);
        }
        return new Dimension(this.width * 3, this.thumbWidth - 2);
    }
}

