/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.components.tree;

import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.components.textfield.EnhancedTextField;
import org.tinymediamanager.ui.components.tree.ITmmTreeFilter;
import org.tinymediamanager.ui.components.tree.TmmTreeNode;

public class TmmTreeTextFilter<E extends TmmTreeNode>
extends EnhancedTextField
implements ITmmTreeFilter<E> {
    protected String filterText = "";
    protected Pattern filterPattern;

    public TmmTreeTextFilter() {
        super(TmmResourceBundle.getString("tmm.searchfield"), IconManager.SEARCH_GREY);
        this.lblIcon.setCursor(Cursor.getPredefinedCursor(12));
        this.lblIcon.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (StringUtils.isNotBlank((CharSequence)TmmTreeTextFilter.this.getText())) {
                    TmmTreeTextFilter.this.setText("");
                }
            }
        });
        this.initDocumentListener();
    }

    @Override
    public String getId() {
        return "treeTextFilter";
    }

    protected void initDocumentListener() {
        this.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.changeIcon();
                this.updateFilter();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.changeIcon();
                this.updateFilter();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.changeIcon();
                this.updateFilter();
            }

            private void changeIcon() {
                if (StringUtils.isBlank((CharSequence)TmmTreeTextFilter.this.getText())) {
                    TmmTreeTextFilter.this.lblIcon.setIcon(IconManager.SEARCH_GREY);
                } else {
                    TmmTreeTextFilter.this.lblIcon.setIcon(IconManager.CLEAR_GREY);
                }
            }

            private void updateFilter() {
                String oldValue = TmmTreeTextFilter.this.filterText;
                TmmTreeTextFilter.this.filterText = TmmTreeTextFilter.this.prepareFilterText().strip();
                try {
                    TmmTreeTextFilter.this.filterPattern = Pattern.compile(TmmTreeTextFilter.this.filterText, 2);
                    TmmTreeTextFilter.this.firePropertyChange("treeFilterChanged", oldValue, TmmTreeTextFilter.this.filterText);
                }
                catch (PatternSyntaxException e) {
                    TmmTreeTextFilter.this.filterPattern = null;
                }
            }
        });
    }

    protected String prepareFilterText() {
        return this.getText();
    }

    @Override
    public boolean isActive() {
        return StringUtils.isNotBlank((CharSequence)this.filterText);
    }

    @Override
    public boolean accept(E node) {
        if (StringUtils.isBlank((CharSequence)this.filterText)) {
            return true;
        }
        Matcher matcher = this.filterPattern.matcher(((TmmTreeNode)node).toString());
        if (matcher.find()) {
            return true;
        }
        Enumeration<TreeNode> e = ((DefaultMutableTreeNode)node).children();
        while (e.hasMoreElements()) {
            if (!this.accept((TmmTreeNode)e.nextElement())) continue;
            return true;
        }
        return this.checkParent(((TmmTreeNode)node).getDataProvider().getParent((TmmTreeNode)node), this.filterPattern);
    }

    protected boolean checkParent(TmmTreeNode node, Pattern pattern) {
        if (node == null) {
            return false;
        }
        Matcher matcher = pattern.matcher(node.toString());
        if (matcher.find()) {
            return true;
        }
        return this.checkParent(node.getDataProvider().getParent(node), pattern);
    }
}

