/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie;

import java.text.Collator;
import java.text.RuleBasedCollator;
import java.util.Comparator;
import java.util.Locale;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.scraper.util.StrgUtils;

public class MovieComparator
implements Comparator<Movie> {
    protected Collator stringCollator;

    public MovieComparator() {
        RuleBasedCollator defaultCollator = (RuleBasedCollator)RuleBasedCollator.getInstance();
        try {
            this.stringCollator = new RuleBasedCollator(defaultCollator.getRules().replace("<'_'", "<' '<'_'"));
        }
        catch (Exception e) {
            this.stringCollator = defaultCollator;
        }
    }

    @Override
    public int compare(Movie movie1, Movie movie2) {
        if (this.stringCollator != null) {
            String titleMovie1 = StrgUtils.normalizeString(movie1.getTitleSortable().toLowerCase(Locale.ROOT));
            String titleMovie2 = StrgUtils.normalizeString(movie2.getTitleSortable().toLowerCase(Locale.ROOT));
            return this.stringCollator.compare(titleMovie1, titleMovie2);
        }
        return movie1.getTitleSortable().toLowerCase(Locale.ROOT).compareTo(movie2.getTitleSortable().toLowerCase(Locale.ROOT));
    }
}

