/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.loopfs.udf;

import com.github.stephenc.javaisotools.loopfs.api.FileEntry;
import com.github.stephenc.javaisotools.loopfs.spi.VolumeDescriptorSet;
import com.github.stephenc.javaisotools.loopfs.udf.UDFFileEntry;
import com.github.stephenc.javaisotools.loopfs.udf.UDFFileSystem;
import com.github.stephenc.javaisotools.loopfs.udf.UDFUtil;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.ExtendedFileEntryDescriptor;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.FileEntryDescriptor;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.FileSetDescriptor;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.ImplementationUseDescriptor;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.LogicalVolumeDescriptor;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.LogicalVolumeIntegrityDescriptor;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.PartitionDescriptor;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.PrimaryVolumeDescriptor;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.TerminatingDescriptor;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.UnallocatedSpaceDescriptor;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.element.DescriptorTag;
import com.github.stephenc.javaisotools.loopfs.udf.exceptions.InvalidDescriptor;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UDFVolumeDescriptorSet
implements VolumeDescriptorSet {
    private static final Log log = LogFactory.getLog(UDFVolumeDescriptorSet.class);
    private UDFFileSystem fs;
    public PrimaryVolumeDescriptor pvd;
    public LogicalVolumeDescriptor lvd;
    public LogicalVolumeIntegrityDescriptor lvid;
    public PartitionDescriptor pd;
    public ImplementationUseDescriptor impl;
    public UnallocatedSpaceDescriptor un;
    public FileSetDescriptor rootFSD;
    public FileEntryDescriptor rootEntry;
    private long fsdLocation = 0L;
    private int invalidCnt = 0;

    public UDFVolumeDescriptorSet(UDFFileSystem uDFFileSystem) {
        this.fs = uDFFileSystem;
    }

    public boolean deserialize(byte[] byArray) throws IOException {
        Integer n = UDFUtil.getUInt16(byArray, 0);
        boolean bl = false;
        try {
            switch (n) {
                case 1: {
                    log.debug((Object)"Found primary volume descriptor.");
                    this.pvd = new PrimaryVolumeDescriptor(byArray);
                    break;
                }
                case 2: {
                    log.debug((Object)"Found anchor pointer.");
                    break;
                }
                case 3: {
                    log.debug((Object)"Found volume descriptorpointer.");
                    break;
                }
                case 4: {
                    log.debug((Object)"Found implementation use descriptor.");
                    this.impl = new ImplementationUseDescriptor(byArray);
                    break;
                }
                case 5: {
                    log.debug((Object)"Found partition descriptor.");
                    this.pd = new PartitionDescriptor(byArray);
                    break;
                }
                case 6: {
                    log.debug((Object)"Found logical volume descriptor");
                    this.lvd = new LogicalVolumeDescriptor(byArray);
                    log.debug((Object)("Disc identifier: " + this.lvd.logicalVolumeIdentifier.toString().replace("\u0000.*$", "").trim()));
                    break;
                }
                case 7: {
                    log.debug((Object)"Found unallocated space descriptor.");
                    this.un = new UnallocatedSpaceDescriptor(byArray);
                    break;
                }
                case 8: {
                    log.debug((Object)"Found terminating descriptor.");
                    TerminatingDescriptor terminatingDescriptor = new TerminatingDescriptor(byArray);
                    bl = true;
                    this.tracePartition();
                    break;
                }
                case 9: {
                    log.debug((Object)"Found logical volume integrity descriptor.");
                    this.lvid = new LogicalVolumeIntegrityDescriptor(byArray);
                    break;
                }
                default: {
                    log.debug((Object)("Found unknown volume descriptor with type: " + n));
                    ++this.invalidCnt;
                    if (this.invalidCnt > 1000) {
                        bl = true;
                        log.warn((Object)"Too many unknown descriptors - giving up!");
                    }
                    break;
                }
            }
        }
        catch (InvalidDescriptor invalidDescriptor) {
            throw new IOException(invalidDescriptor.getMessage());
        }
        return bl;
    }

    private void tracePartition() throws IOException, InvalidDescriptor {
        DescriptorTag descriptorTag;
        Object object;
        byte[] byArray = new byte[2048];
        if (this.lvd.integritySequenceExtent.length > 0L) {
            this.fs.readBlock(this.lvd.integritySequenceExtent.location, byArray);
            this.lvid = new LogicalVolumeIntegrityDescriptor(byArray);
        }
        this.fsdLocation = this.pd.startingLocation;
        this.fs.readBlock(this.fsdLocation, byArray);
        int n = UDFUtil.getUInt16(byArray, 0);
        if (n == 261) {
            object = new FileEntryDescriptor(byArray);
            if (((FileEntryDescriptor)object).allocDescriptorLength > 0L) {
                int n2 = ((FileEntryDescriptor)object).allocDescriptors.get((int)0).location.intValue();
                this.fsdLocation += (long)n2;
                this.fs.readBlock(this.fsdLocation, byArray);
                n = UDFUtil.getUInt16(byArray, 0);
            }
        }
        if (n != 256) {
            this.fsdLocation = this.pd.startingLocation + this.lvd.logicalVolumeContentsUse.location.blockNumber;
            this.fs.readBlock(this.fsdLocation, byArray);
            n = UDFUtil.getUInt16(byArray, 0);
        }
        if (n != 256) {
            this.fsdLocation = 257L;
            this.fs.readBlock(this.fsdLocation, byArray);
            n = UDFUtil.getUInt16(byArray, 0);
        }
        if (n != 256) {
            this.fsdLocation = this.pd.startingLocation + this.fs.getAnchor().mainVolumeExtent.location;
            this.fs.readBlock(this.fsdLocation, byArray);
            n = UDFUtil.getUInt16(byArray, 0);
        }
        if (n != 256) {
            object = new ArrayList(300);
            this.fsdLocation = 32L;
            while (n != 256 && this.fsdLocation < 300L) {
                this.fs.readBlock(++this.fsdLocation, byArray);
                n = UDFUtil.getUInt16(byArray, 0);
                object.add(n);
            }
            log.debug((Object)("IDs of block 32-300: " + object));
        }
        this.rootFSD = new FileSetDescriptor(byArray);
        log.debug((Object)("Found FSD at block " + this.fsdLocation));
        if (this.rootFSD.rootICB.length > 0L) {
            this.fs.readBlock(this.fsdLocation + this.rootFSD.rootICB.location.blockNumber, byArray);
            descriptorTag = new DescriptorTag(byArray);
            if (descriptorTag.identifier == 261) {
                this.rootEntry = new FileEntryDescriptor(byArray);
            } else if (descriptorTag.identifier == 266) {
                this.rootEntry = new ExtendedFileEntryDescriptor(byArray);
            }
        }
        if (this.rootFSD.sysStreamDirICB.length > 0L) {
            this.fs.readBlock(this.fsdLocation + this.rootFSD.rootICB.location.blockNumber, byArray);
            descriptorTag = new DescriptorTag(byArray);
            if (descriptorTag.identifier == 261) {
                this.rootEntry = new FileEntryDescriptor(byArray);
            } else if (descriptorTag.identifier == 266) {
                this.rootEntry = new ExtendedFileEntryDescriptor(byArray);
            }
        }
    }

    public FileEntry getRootEntry() {
        return new UDFFileEntry(this.fs, this.rootEntry, null, null, true);
    }

    public long getPDStartPos() {
        return this.pd.startingLocation;
    }

    public long getFSDloc() {
        return this.fsdLocation;
    }
}

