/*
 * Decompiled with CFR 0.152.
 */
package org.mp4parser.muxer;

import java.util.LinkedList;
import java.util.List;
import org.mp4parser.muxer.Track;
import org.mp4parser.support.Matrix;
import org.mp4parser.tools.Mp4Math;

public class Movie {
    Matrix matrix = Matrix.ROTATE_0;
    List<Track> tracks = new LinkedList<Track>();

    public Movie() {
    }

    public Movie(List<Track> tracks) {
        this.tracks = tracks;
    }

    public List<Track> getTracks() {
        return this.tracks;
    }

    public void setTracks(List<Track> tracks) {
        this.tracks = tracks;
    }

    public void addTrack(Track nuTrack) {
        if (this.getTrackByTrackId(nuTrack.getTrackMetaData().getTrackId()) != null) {
            nuTrack.getTrackMetaData().setTrackId(this.getNextTrackId());
        }
        this.tracks.add(nuTrack);
    }

    public String toString() {
        String s = "Movie{ ";
        for (Track track : this.tracks) {
            s = s + "track_" + track.getTrackMetaData().getTrackId() + " (" + track.getHandler() + ") ";
        }
        s = s + '}';
        return s;
    }

    public long getNextTrackId() {
        long nextTrackId = 0L;
        for (Track track : this.tracks) {
            nextTrackId = nextTrackId < track.getTrackMetaData().getTrackId() ? track.getTrackMetaData().getTrackId() : nextTrackId;
        }
        return ++nextTrackId;
    }

    public Track getTrackByTrackId(long trackId) {
        for (Track track : this.tracks) {
            if (track.getTrackMetaData().getTrackId() != trackId) continue;
            return track;
        }
        return null;
    }

    public long getTimescale() {
        long timescale = this.getTracks().iterator().next().getTrackMetaData().getTimescale();
        for (Track track : this.getTracks()) {
            timescale = Mp4Math.gcd((long)track.getTrackMetaData().getTimescale(), (long)timescale);
        }
        return timescale;
    }

    public Matrix getMatrix() {
        return this.matrix;
    }

    public void setMatrix(Matrix matrix) {
        this.matrix = matrix;
    }
}

